package com.palacesun.masking.tools.ruleload;

import com.palacesun.masking.tools.EngineUtil;
import java.util.logging.Logger;

public class RuleLoadThread extends Thread {
   protected static Logger logger = Logger.getLogger(RuleLoadThread.class.getName());
   private static RuleLoadThread thread = new RuleLoadThread();
   private static boolean started = false;

   public void run() {
      while(true) {
         this.waittime();

         try {
            EngineUtil.initRule();
         } catch (Throwable e) {
            logger.severe(String.format("[%s][%s]", e.getClass().getName(), e.getMessage()));
         }
      }
   }

   protected void waittime() {
      try {
         Thread.sleep(RuleProps.getInstance().getRuleLoadPeriod() * 1000L);
      } catch (InterruptedException var2) {
         logger.severe("RuleLoadThread.waittime.error");
      }

   }

   public static synchronized void startup() {
      boolean bool = !RuleLoadUtil.isEncryptionRuleFromGateway() && !RuleLoadUtil.isMaskingRuleFromGateway();
      if (bool) {
         logger.info("Both encryptionrule and maskingrule come from localfile, so RuleLoadThread.startup is ignored.");
      } else {
         if (!started) {
            thread.start();
            started = true;
            logger.info("RuleLoadThread started.");
         } else {
            logger.info("RuleLoadThread start more than once.");
         }

      }
   }
}
