package com.palacesun.masking.tools.sm4fpe;

import com.palacesun.masking.tools.ReflectUtil;
import com.palacesun.masking.vo.Columninfo;
import java.io.UnsupportedEncodingException;

public class SM4FPEToolsTest {
   public static boolean isPrint = true;

   public static void main(String[] args) throws Exception {
      String key = SM4FPENameUtil.generateKey();
      System.out.println(key);
      String data = "张三跑";
      System.out.println(data);
      String encrypt = SM4FPENameUtil.encryptEcb(key, data, "1", "0", "3", "0");
      System.out.println(encrypt);
      String decrypt = SM4FPENameUtil.decryptEcb(key, encrypt, "1", "0", "3", "0");
      System.out.println(decrypt);
      System.out.println(data.equals(decrypt));
      encrypt = ReflectUtil.engine("SM4_FPE_NAME", data, key, "1", "0", "0", "0", true, (Columninfo)null);
      System.out.println(encrypt);
      decrypt = ReflectUtil.engine("SM4_FPE_NAME", encrypt, key, "1", "0", "0", "0", false, (Columninfo)null);
      System.out.println(decrypt);
      System.out.println(data.equals(decrypt));
   }

   private static void testSet() throws Exception {
      testAllExample();
   }

   public static byte[] convertEncoding_ByteArr(byte[] src, String srcCharset, String destCharet) throws UnsupportedEncodingException {
      String s = new String(src, srcCharset);
      return s.getBytes(destCharet);
   }

   private static void testCharSet() throws UnsupportedEncodingException {
      String test = "离中国";
      byte[] bytes = test.getBytes("UTF-8");
      byte[] bytes2 = convertEncoding_ByteArr(test.getBytes("UTF-8"), "UTF-8", "GBK");
      String test2 = new String(bytes2, "GBK");
      char[] chars = test.toCharArray();
      char[] chars2 = test2.toCharArray();
   }

   private static void testIsPersonName() throws Exception {
      String input = "周唉挨";
      input = "周唉挨";
      String key = SM4FPETools.generateKey();
      input = "周唉挨";
      String x = SM4FPETools.encryptEcbAuto(key, input);
      String y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "公孙唉";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "单于矮";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
   }

   private static void testPersonName() throws Exception {
      String input = "周唉挨";
      input = "周唉挨";
      String key = "9c073de10dca9daf1943f77048874ef39265eff78cf7af1c7e6bd17934ca71c9b288837ff6b528a87eb3e7bdf16b76e7ba05c9dbf3f4d68d5ff47ec27db04ccba032e7574e0c8e049ba3fe30711c7dbb1d96a9242fcf91760ab825c2515dbce76e4ba51f8f1ed4d4403dc69b25e36470595e6a2ee7ae540f33391cf748fff7366d63a04a2af5ca4421c8fa1f7f9c91798ed01db4f66ecd21b09254eb4de45606b0d9fd8005ba285b560253448465992be2d5b059e92e4c13fbd781a41f90ed228e703f44f8f2d826db08cb5b4f9a0c5aff2ab92684b5bbdbb10559c2d32247c922f24a114f8c08c011d033778c24cf2d";
      SM4FPEName name = new SM4FPEName();
      input = "王业明";
      String x = name.encryptEcb(key, input);
      String y = name.decryptEcb(key, x);
      print(key, input, x, y);
      input = "令狐西门";
      x = name.encryptEcb(key, input);
      y = name.decryptEcb(key, x);
      print(key, input, x, y);
      input = "驴头狼";
      x = name.encryptEcb(key, input);
      y = name.decryptEcb(key, x);
      print(key, input, x, y);
      input = "驴头狼2342";
      x = name.encryptEcb(key, input);
      y = name.decryptEcb(key, x);
      print(key, input, x, y);
      input = "刘偊偋偌偍偎偏偐偑偒偓偔";
      x = name.encryptEcb(key, input);
      y = name.decryptEcb(key, x);
      print(key, input, x, y);
      input = "驴头狼2342（）（sfsd**&…………SD";
      x = name.encryptEcb(key, input);
      y = name.decryptEcb(key, x);
      print(key, input, x, y);
   }

   private static void testPhoneNumber() throws Exception {
      String input = "周唉挨";
      input = "周唉挨";
      String key = SM4FPETools.generateKey();
      SM4FPECellPhone phone = new SM4FPECellPhone();
      System.out.println(key);
      key = "CAF36B99753915223C00B51D78BA395A";
      input = "+999999915615608356";
      String x = phone.encryptEcb(key, input);
      String y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "15615608356";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "15706966819";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "+115706966819";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "+8615706966819";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "+21215706966819";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "+144115706966819";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "+1439715706966819";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "+991439715706966819";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "+9914";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "+9915706966819";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "8615706966819";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "06966819";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
      input = "06966819sdf2348()*^中文";
      x = phone.encryptEcb(key, input);
      y = phone.decryptEcb(key, x);
      print(key, input, x, y);
   }

   private static void testIdentifyNo() throws Exception {
      String input = "周唉挨";
      input = "周唉挨";
      String key = SM4FPETools.generateKey();
      SM4FPEIdentityNo identityNo = new SM4FPEIdentityNo();
      input = "513030188001310014";
      String x = identityNo.encryptEcb(key, input);
      String y = identityNo.decryptEcb(key, x);
      print(key, input, x, y);
      input = "320000491231002";
      x = identityNo.encryptEcb(key, input);
      y = identityNo.decryptEcb(key, x);
      print(key, input, x, y);
      input = "32000049123100223423";
      x = identityNo.encryptEcb(key, input);
      y = identityNo.decryptEcb(key, x);
      print(key, input, x, y);
      input = "32000";
      x = identityNo.encryptEcb(key, input);
      y = identityNo.decryptEcb(key, x);
      print(key, input, x, y);
      input = "23sdfLKJ*&*)(__中文";
      x = identityNo.encryptEcb(key, input);
      y = identityNo.decryptEcb(key, x);
      print(key, input, x, y);
   }

   private static void testEmail() throws Exception {
      String input = "周唉挨";
      input = "周唉挨";
      String key = SM4FPETools.generateKey();
      SM4FPEEmail email = new SM4FPEEmail();
      input = "username@domain.com";
      String x = email.encryptEcb(key, input);
      String y = email.decryptEcb(key, x);
      print(key, input, x, y);
      input = "usernamedomaincom";
      x = email.encryptEcb(key, input);
      y = email.decryptEcb(key, x);
      print(key, input, x, y);
      input = "userna23423erweLKJ()*(&*(中文";
      x = email.encryptEcb(key, input);
      y = email.decryptEcb(key, x);
      print(key, input, x, y);
   }

   private static void testAddress() throws Exception {
      String input = "周唉挨";
      input = "周唉挨";
      String key = SM4FPETools.generateKey();
      SM4FPEAddress address = new SM4FPEAddress();
      input = "辽";
      String x = address.encryptEcb(key, input);
      String y = address.decryptEcb(key, x);
      print(key, input, x, y);
      input = "辽你说的覅寄送到南方山东福建山东分局送到送的飓风桑迪发吉萨配认为Joe均为哦附件为甲方哦点击发送i大家佛就15489）（&**……（&";
      x = address.encryptEcb(key, input);
      y = address.decryptEcb(key, x);
      print(key, input, x, y);
      input = "水電費收到附件兩款手機地位螺絲釘解放是考慮到房價";
      x = address.encryptEcb(key, input);
      y = address.decryptEcb(key, x);
      print(key, input, x, y);
   }

   private static void testCompany() throws Exception {
      String input = "周唉挨";
      input = "周唉挨";
      String key = SM4FPETools.generateKey();
      SM4FPECompany company = new SM4FPECompany();
      input = "光华冠群sdfs(*)(*JLKJK23";
      String x = company.encryptEcb(key, input);
      String y = company.decryptEcb(key, x);
      print(key, input, x, y);
      input = "士大夫勝多負少有限公司";
      x = company.encryptEcb(key, input);
      y = company.decryptEcb(key, x);
      print(key, input, x, y);
   }

   private static void testBase() throws Exception {
      String input = "周唉挨";
      String key = SM4FPETools.generateKey();
      SM4FPEBase base = new SM4FPEBase();
      input = "光华冠群sdfs(*)(*JLKJK23黜黝點黟黠黡黢黣黤黥黦黧黨黩黪黫黬黭黮黯";
      String x = base.encryptEcb(key, input);
      String y = base.decryptEcb(key, x);
      print(key, input, x, y);
   }

   private static void testAllExample() throws Exception {
      String key = SM4FPETools.generateKey();
      System.out.println(key.length());
      SM4FPEAddress address = new SM4FPEAddress();
      String input = "辽宁省沈阳市浑南区万达广场6号楼1501室士大夫士大夫士大夫士大夫士大夫胜多负少撒旦发射点发射点士大夫胜多负少手动阀手动阀手士大夫石帆胜丰士大夫士大夫随风倒士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫撒旦发射点士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫动阀手动阀手动阀手动阀手动阀手动阀士大夫士大夫士大夫士大夫士大夫士大夫辽宁省沈阳市浑南区万达广场6号楼1501室士大夫士大夫士大夫士大夫士大夫胜多负少撒旦发射点发射点士大夫胜多负少手动阀手动阀手士大夫石帆胜丰士大夫士大夫随风倒士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫撒旦发射点士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫动阀手动阀手动阀手动阀手动阀手动阀士大夫士大夫士大夫士大夫士大夫士大夫辽宁省沈阳市浑南区万达广场6号楼1501室士大夫士大夫士大夫士大夫士大夫胜多负少撒旦发射点发射点士大夫胜多负少手动阀手动阀手士大夫石帆胜丰士大夫士大夫随风倒士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫撒旦发射点士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫动阀手动阀手动阀手动阀手动阀手动阀士大夫士大夫士大夫士大夫士大夫士大夫辽宁省沈阳市浑南区万达广场6号楼1501室士大夫士大夫士大夫士大夫士大夫胜多负少撒旦发射点发射点士大夫胜多负少手动阀手动阀手士大夫石帆胜丰士大夫士大夫随风倒士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫撒旦发射点士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫动阀手动阀手动阀手动阀手动阀手动阀士大夫士大夫士大夫士大夫士大夫士大夫辽宁省沈阳市浑南区万达广场6号楼1501室士大夫士大夫士大夫士大夫士大夫胜多负少撒旦发射点发射点士大夫胜多负少手动阀手动阀手士大夫石帆胜丰士大夫士大夫随风倒士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫撒旦发射点士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫动阀手动阀手动阀手动阀手动阀手动阀士大夫士大夫士大夫士大夫士大夫士大夫辽宁省沈阳市浑南区万达广场6号楼1501室士大夫士大夫士大夫士大夫士大夫胜多负少撒旦发射点发射点士大夫胜多负少手动阀手动阀手士大夫石帆胜丰士大夫士大夫随风倒士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫撒旦发射点士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫动阀手动阀手动阀手动阀手动阀手动阀士大夫士大夫士大夫士大夫士大夫士大夫辽宁省沈阳市浑南区万达广场6号楼1501室士大夫士大夫士大夫士大夫士大夫胜多负少撒旦发射点发射点士大夫胜多负少手动阀手动阀手士大夫石帆胜丰士大夫士大夫随风倒士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫撒旦发射点士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫动阀手动阀手动阀手动阀手动阀手动阀士大夫士大夫士大夫士大夫士大夫士大夫辽宁省沈阳市浑南区万达广场6号楼1501室士大夫士大夫士大夫士大夫士大夫胜多负少撒旦发射点发射点士大夫胜多负少手动阀手动阀手士大夫石帆胜丰士大夫士大夫随风倒士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫撒旦发射点士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫动阀手动阀手动阀手动阀手动阀手动阀士大夫士大夫士大夫士大夫士大夫士大夫辽宁省沈阳市浑南区万达广场6号楼1501室士大夫士大夫士大夫士大夫士大夫胜多负少撒旦发射点发射点士大夫胜多负少手动阀手动阀手士大夫石帆胜丰士大夫士大夫随风倒士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫撒旦发射点士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫动阀手动阀手动阀手动阀手动阀手动阀士大夫士大夫士大夫士大夫士大夫士大夫辽宁省沈阳市浑南区万达广场6号楼1501室士大夫士大夫士大夫士大夫士大夫胜多负少撒旦发射点发射点士大夫胜多负少手动阀手动阀手士大夫石帆胜丰士大夫士大夫随风倒士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫撒旦发射点士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫士大夫动阀手动阀手动阀手动阀手动阀手动阀士大夫士大夫士大夫士大夫士大夫士大夫";
      String x = address.encryptEcb(key, input);
      String y = address.decryptEcb(key, x);
      print(key, input, x, y);
      input = "辽宁省沈阳市浑南区万达广场6号楼1501室";
      x = address.encryptEcb(key, input);
      y = address.decryptEcb(key, x);
      print(key, input, x, y);
      input = "中国医科大学附属盛京医院(南湖院区)";
      x = address.encryptEcb(key, input);
      y = address.decryptEcb(key, x);
      print(key, input, x, y);
      input = "新疆乌鲁木齐市南区天龙街52-4号";
      x = address.encryptEcb(key, input);
      y = address.decryptEcb(key, x);
      print(key, input, x, y);
      SM4FPECompany company = new SM4FPECompany();
      input = "光华冠群股份有限公司";
      x = company.encryptEcb(key, input);
      y = company.decryptEcb(key, x);
      print(key, input, x, y);
      input = "光华冠群有限公司";
      x = company.encryptEcb(key, input);
      y = company.decryptEcb(key, x);
      print(key, input, x, y);
      input = "光华冠群公司";
      x = company.encryptEcb(key, input);
      y = company.decryptEcb(key, x);
      print(key, input, x, y);
      input = "533223180003311620";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "452728189802290349";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "32000019491231002X";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "513030188001310014";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "320000491231002";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "513030800131001";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "15615608356";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "15706966819";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "+8615706966819";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "上海市宝山区丰村";
      x = SM4FPETools.encryptEcb(key, input);
      y = SM4FPETools.decryptEcb(key, x);
      print(key, input, x, y);
      input = "周唉星";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "公孙安";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "西门飞安";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "单于飞";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "1993-11-13 16:01:20";
      x = SM4FPETools.encryptEcb(key, input);
      y = SM4FPETools.decryptEcb(key, x);
      print(key, input, x, y);
      input = "username@domain.com";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "username@domain.com.cn";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "user.name@domain.com.cn";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "abc123@163.com";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
      input = "张三@123.com";
      x = SM4FPETools.encryptEcbAuto(key, input);
      y = SM4FPETools.decryptEcbAuto(key, x);
      print(key, input, x, y);
   }

   private static void test2() throws Exception {
      String key = SM4FPETools.generateKey();
      String input = "010101019999";
      String x = SM4FPETools.encryptEcb(key, input);
      SM4FPEBase.digitChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*'};
      ((SM4FPEEntity)SM4FPEBase.sm4FPEEntities.get(2)).setList(SM4FPEBase.toArrayList(SM4FPEBase.digitChars));
      String y = SM4FPETools.decryptEcb(key, x);
      print(key, input, x, y);
      input = "010101019999*";
      SM4FPEBase.digitChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
      ((SM4FPEEntity)SM4FPEBase.sm4FPEEntities.get(2)).setList(SM4FPEBase.toArrayList(SM4FPEBase.digitChars));
      x = SM4FPETools.encryptEcb(key, input);
      SM4FPEBase.digitChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*'};
      ((SM4FPEEntity)SM4FPEBase.sm4FPEEntities.get(2)).setList(SM4FPEBase.toArrayList(SM4FPEBase.digitChars));
      y = SM4FPETools.decryptEcb(key, x);
      print(key, input, x, y);
   }

   private static void print(String key, String input, String x, String y) {
      if (isPrint || !input.equals(y) && x.length() == input.length()) {
         System.out.println("----------- begin");
         System.out.println("输入的：" + input);
         System.out.println("加密后：" + x);
         System.out.println("解密后：" + y);
         System.out.println("----------- end");
      }

   }

   private static void randomPhone_test() throws Exception {
      SM4FPECellPhone phone = new SM4FPECellPhone();

      for(int i = 0; i < 2000; ++i) {
         String key = SM4FPETools.generateKey();
         String input = "";
         input = phone.generateInputRandom(input);
         String x = SM4FPETools.encryptEcbAuto(key, input);
         String y = SM4FPETools.decryptEcbAuto(key, x);
         if (!input.equals(y) && x.length() == input.length()) {
            print(key, input, x, y);
            System.out.println("-------------------- error");
         }
      }

   }

   private static void randomEmail_test() throws Exception {
      SM4FPEEmail email = new SM4FPEEmail();

      for(int i = 0; i < 2000; ++i) {
         String key = SM4FPETools.generateKey();
         String input = "";
         input = email.generateInputRandom(input);
         String x = email.encryptEcb(key, input);
         String y = email.decryptEcb(key, x);
         if (!input.equals(y) && x.length() == input.length()) {
            print(key, input, x, y);
            System.out.println("-------------------- error");
         }
      }

   }

   private static void randomAddress_test() throws Exception {
      SM4FPEAddress address = new SM4FPEAddress();
      String key = SM4FPETools.generateKey();
      String input = "辽宁省沈阳市浑南区万达广场6号楼1501室";
      String x = address.encryptEcb(key, input);
      String y = address.decryptEcb(key, x);
      if (!input.equals(y) && x.length() == input.length()) {
         print(key, input, x, y);
         System.out.println("-------------------- error");
      }

   }

   private static void randomCompany_test() throws Exception {
      SM4FPECompany company = new SM4FPECompany();

      for(int i = 0; i < 2000; ++i) {
         String key = SM4FPETools.generateKey();
         String input = "";
         input = company.generateInputRandom(input);
         String x = company.encryptEcb(key, input);
         String y = company.decryptEcb(key, x);
         if (!input.equals(y) && x.length() == input.length()) {
            print(key, input, x, y);
            System.out.println("-------------------- error");
         }
      }

   }

   private static void randomIdentify_test() throws Exception {
      SM4FPEIdentityNo identityNo = new SM4FPEIdentityNo();

      for(int i = 0; i < 2000; ++i) {
         String key = SM4FPETools.generateKey();
         String input = "";
         input = identityNo.generateInputRandom(input);
         String x = SM4FPETools.encryptEcbAuto(key, input);
         String y = SM4FPETools.decryptEcbAuto(key, x);
         if (!input.equals(y) && x.length() == input.length()) {
            print(key, input, x, y);
            System.out.println("-------------------- error");
         }
      }

   }

   private static void randomName_test() throws Exception {
      SM4FPEName name = new SM4FPEName();

      for(int i = 0; i < 200; ++i) {
         String key = SM4FPETools.generateKey();
         String input = "";
         input = name.generateInputRandom(input);
         String x = name.encryptEcb(key, input);
         String y = name.decryptEcb(key, x);
         if (!input.equals(y) && x.length() == input.length()) {
            print(key, input, x, y);
            System.out.println("-------------------- error");
         }
      }

   }

   private static void random_test() throws Exception {
      SM4FPEBase base = new SM4FPEBase();

      for(int i = 0; i < 2000; ++i) {
         String key = SM4FPETools.generateKey();
         String input = "";
         input = base.generateInputRandom(input);
         String x = SM4FPETools.encryptEcb(key, input);
         String y = SM4FPETools.decryptEcb(key, x);
         if (!input.equals(y) && x.length() == input.length()) {
            print(key, input, x, y);
            System.out.println("-------------------- error");
         }
      }

   }

   private static void unsupport_test() throws Exception {
      for(int i = 0; i < 20; ++i) {
         String key = SM4FPETools.generateKey();
         String input = "Test3.天下打乱#$￥";
         String x = SM4FPETools.encryptEcb(key, input);
         String y = SM4FPETools.decryptEcb(key, x);
         if (!input.equals(y) && x.length() == input.length()) {
            print(key, input, x, y);
            System.out.println("-------------------- error");
         }
      }

   }

   private static void generateAllChinese() {
      char c = 19968;

      for(char i = 0; c <= '龥'; ++i) {
         System.out.print(c);
         if (i % 70 == 69) {
            System.out.println();
         }

         ++c;
      }

   }

   private static void generateMothday() {
      getMothday(1, 31);
      getMothday(2, 29);
      getMothday(3, 31);
      getMothday(4, 30);
      getMothday(5, 31);
      getMothday(6, 30);
      getMothday(7, 31);
      getMothday(8, 31);
      getMothday(9, 30);
      getMothday(10, 31);
      getMothday(11, 30);
      getMothday(12, 31);
   }

   private static void getMothday(int month, int end) {
      for(int i = 1; i <= end; ++i) {
         System.out.println(expand(month) + expand(i));
      }

   }

   private static String expand(int i) {
      String a;
      for(a = String.valueOf(i); a.length() < 2; a = '0' + a) {
      }

      return a;
   }
}
