package org.chenyang.http.client.entity;

import org.chenyang.http.NameValuePair;
import org.chenyang.http.client.utils.URLEncodedUtils;
import org.chenyang.http.entity.ContentType;
import org.chenyang.http.entity.StringEntity;
import org.chenyang.http.protocol.HTTP;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;

public class UrlEncodedFormEntity extends StringEntity {
   public UrlEncodedFormEntity(List<? extends NameValuePair> parameters, String charset) throws UnsupportedEncodingException {
      super(URLEncodedUtils.format(parameters, charset != null ? charset : HTTP.DEF_CONTENT_CHARSET.name()), ContentType.create("application/x-www-form-urlencoded", charset));
   }

   public UrlEncodedFormEntity(Iterable<? extends NameValuePair> parameters, Charset charset) {
      super(URLEncodedUtils.format(parameters, charset != null ? charset : HTTP.DEF_CONTENT_CHARSET), ContentType.create("application/x-www-form-urlencoded", charset));
   }

   public UrlEncodedFormEntity(List<? extends NameValuePair> parameters) throws UnsupportedEncodingException {
      this(parameters, (Charset)((Charset)null));
   }

   public UrlEncodedFormEntity(Iterable<? extends NameValuePair> parameters) {
      this(parameters, (Charset)null);
   }
}
