package org.chenyang.http.client.methods;

import org.chenyang.http.Header;
import org.chenyang.http.HttpEntity;
import org.chenyang.http.HttpEntityEnclosingRequest;
import org.chenyang.http.client.utils.CloneUtils;

public abstract class HttpEntityEnclosingRequestBase extends HttpRequestBase implements HttpEntityEnclosingRequest {
   private HttpEntity entity;

   public HttpEntity getEntity() {
      return this.entity;
   }

   public void setEntity(HttpEntity entity) {
      this.entity = entity;
   }

   public boolean expectContinue() {
      Header expect = this.getFirstHeader("Expect");
      return expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
   }

   public Object clone() throws CloneNotSupportedException {
      HttpEntityEnclosingRequestBase clone = (HttpEntityEnclosingRequestBase)super.clone();
      if (this.entity != null) {
         clone.entity = (HttpEntity)CloneUtils.cloneObject(this.entity);
      }

      return clone;
   }
}
