package org.chenyang.http.client.methods;

import org.chenyang.http.Header;
import org.chenyang.http.HeaderElement;
import org.chenyang.http.HeaderIterator;
import org.chenyang.http.HttpResponse;
import org.chenyang.http.util.Args;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public class HttpOptions extends HttpRequestBase {
   public static final String METHOD_NAME = "OPTIONS";

   public HttpOptions() {
   }

   public HttpOptions(URI uri) {
      this.setURI(uri);
   }

   public HttpOptions(String uri) {
      this.setURI(URI.create(uri));
   }

   public String getMethod() {
      return "OPTIONS";
   }

   public Set<String> getAllowedMethods(HttpResponse response) {
      Args.notNull(response, "HTTP response");
      HeaderIterator it = response.headerIterator("Allow");
      Set<String> methods = new HashSet();

      while(it.hasNext()) {
         Header header = it.nextHeader();
         HeaderElement[] elements = header.getElements();

         for(HeaderElement element : elements) {
            methods.add(element.getName());
         }
      }

      return methods;
   }
}
