package org.chenyang.http.client.methods;

import org.chenyang.http.ProtocolVersion;
import org.chenyang.http.RequestLine;
import org.chenyang.http.client.config.RequestConfig;
import org.chenyang.http.message.BasicRequestLine;
import org.chenyang.http.params.HttpProtocolParams;
import java.net.URI;

public abstract class HttpRequestBase extends AbstractExecutionAwareRequest implements HttpUriRequest, Configurable {
   private ProtocolVersion version;
   private URI uri;
   private RequestConfig config;

   public abstract String getMethod();

   public void setProtocolVersion(ProtocolVersion version) {
      this.version = version;
   }

   public ProtocolVersion getProtocolVersion() {
      return this.version != null ? this.version : HttpProtocolParams.getVersion(this.getParams());
   }

   public URI getURI() {
      return this.uri;
   }

   public RequestLine getRequestLine() {
      String method = this.getMethod();
      ProtocolVersion ver = this.getProtocolVersion();
      URI uriCopy = this.getURI();
      String uritext = null;
      if (uriCopy != null) {
         uritext = uriCopy.toASCIIString();
      }

      if (uritext == null || uritext.isEmpty()) {
         uritext = "/";
      }

      return new BasicRequestLine(method, uritext, ver);
   }

   public RequestConfig getConfig() {
      return this.config;
   }

   public void setConfig(RequestConfig config) {
      this.config = config;
   }

   public void setURI(URI uri) {
      this.uri = uri;
   }

   public void started() {
   }

   public void releaseConnection() {
      this.reset();
   }

   public String toString() {
      return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
   }
}
