package org.chenyang.http.client.protocol;

import org.chenyang.http.HttpException;
import org.chenyang.http.HttpRequest;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.auth.AuthState;
import org.chenyang.http.conn.HttpRoutedConnection;
import org.chenyang.http.conn.routing.HttpRoute;
import org.chenyang.http.protocol.HttpContext;
import org.chenyang.http.util.Args;
import java.io.IOException;

/** @deprecated */
@Deprecated
@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class RequestProxyAuthentication extends RequestAuthenticationBase {
   public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
      Args.notNull(request, "HTTP request");
      Args.notNull(context, "HTTP context");
      if (!request.containsHeader("Proxy-Authorization")) {
         HttpRoutedConnection conn = (HttpRoutedConnection)context.getAttribute("http.connection");
         if (conn == null) {
            this.log.debug("HTTP connection not set in the context");
         } else {
            HttpRoute route = conn.getRoute();
            if (!route.isTunnelled()) {
               AuthState authState = (AuthState)context.getAttribute("http.auth.proxy-scope");
               if (authState == null) {
                  this.log.debug("Proxy auth state not set in the context");
               } else {
                  if (this.log.isDebugEnabled()) {
                     this.log.debug("Proxy auth state: " + authState.getState());
                  }

                  this.process(authState, request, context);
               }
            }
         }
      }
   }
}
