package org.chenyang.http.config;

import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Contract(
   threading = ThreadingBehavior.SAFE
)
public final class Registry<I> implements Lookup<I> {
   private final Map<String, I> map;

   Registry(Map<String, I> map) {
      this.map = new ConcurrentHashMap(map);
   }

   public I lookup(String key) {
      return (I)(key == null ? null : this.map.get(key.toLowerCase(Locale.ROOT)));
   }

   public String toString() {
      return this.map.toString();
   }
}
