package org.chenyang.http.conn.routing;

import org.chenyang.http.HttpHost;
import java.net.InetAddress;

public interface RouteInfo {
   HttpHost getTargetHost();

   InetAddress getLocalAddress();

   int getHopCount();

   HttpHost getHopTarget(int var1);

   HttpHost getProxyHost();

   TunnelType getTunnelType();

   boolean isTunnelled();

   LayerType getLayerType();

   boolean isLayered();

   boolean isSecure();

   public static enum TunnelType {
      PLAIN,
      TUNNELLED;
   }

   public static enum LayerType {
      PLAIN,
      LAYERED;
   }
}
