package org.chenyang.http.impl;

import org.chenyang.http.ConnectionReuseStrategy;
import org.chenyang.http.HttpResponse;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.protocol.HttpContext;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class NoConnectionReuseStrategy implements ConnectionReuseStrategy {
   public static final NoConnectionReuseStrategy INSTANCE = new NoConnectionReuseStrategy();

   public boolean keepAlive(HttpResponse response, HttpContext context) {
      return false;
   }
}
