package org.chenyang.http.impl.auth;

import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.auth.AuthScheme;
import org.chenyang.http.auth.AuthSchemeFactory;
import org.chenyang.http.auth.AuthSchemeProvider;
import org.chenyang.http.params.HttpParams;
import org.chenyang.http.protocol.HttpContext;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class SPNegoSchemeFactory implements AuthSchemeFactory, AuthSchemeProvider {
   private final boolean stripPort;
   private final boolean useCanonicalHostname;

   public SPNegoSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
      this.stripPort = stripPort;
      this.useCanonicalHostname = useCanonicalHostname;
   }

   public SPNegoSchemeFactory(boolean stripPort) {
      this.stripPort = stripPort;
      this.useCanonicalHostname = true;
   }

   public SPNegoSchemeFactory() {
      this(true, true);
   }

   public boolean isStripPort() {
      return this.stripPort;
   }

   public boolean isUseCanonicalHostname() {
      return this.useCanonicalHostname;
   }

   public AuthScheme newInstance(HttpParams params) {
      return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
   }

   public AuthScheme create(HttpContext context) {
      return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
   }
}
