package org.chenyang.http.impl.client;

import org.chenyang.http.HeaderElement;
import org.chenyang.http.HeaderElementIterator;
import org.chenyang.http.HttpResponse;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.conn.ConnectionKeepAliveStrategy;
import org.chenyang.http.message.BasicHeaderElementIterator;
import org.chenyang.http.protocol.HttpContext;
import org.chenyang.http.util.Args;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class DefaultConnectionKeepAliveStrategy implements ConnectionKeepAliveStrategy {
   public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

   public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
      Args.notNull(response, "HTTP response");
      HeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));

      while(it.hasNext()) {
         HeaderElement he = it.nextElement();
         String param = he.getName();
         String value = he.getValue();
         if (value != null && param.equalsIgnoreCase("timeout")) {
            try {
               return Long.parseLong(value) * 1000L;
            } catch (NumberFormatException var8) {
            }
         }
      }

      return -1L;
   }
}
