package org.chenyang.http.impl.client;

import org.chenyang.http.HttpRequest;
import org.chenyang.http.HttpResponse;
import org.chenyang.http.ProtocolException;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.client.RedirectHandler;
import org.chenyang.http.client.RedirectStrategy;
import org.chenyang.http.client.methods.HttpGet;
import org.chenyang.http.client.methods.HttpHead;
import org.chenyang.http.client.methods.HttpUriRequest;
import org.chenyang.http.protocol.HttpContext;
import java.net.URI;

/** @deprecated */
@Deprecated
@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
class DefaultRedirectStrategyAdaptor implements RedirectStrategy {
   private final RedirectHandler handler;

   public DefaultRedirectStrategyAdaptor(RedirectHandler handler) {
      this.handler = handler;
   }

   public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
      return this.handler.isRedirectRequested(response, context);
   }

   public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
      URI uri = this.handler.getLocationURI(response, context);
      String method = request.getRequestLine().getMethod();
      return (HttpUriRequest)(method.equalsIgnoreCase("HEAD") ? new HttpHead(uri) : new HttpGet(uri));
   }

   public RedirectHandler getHandler() {
      return this.handler;
   }
}
