package org.chenyang.http.impl.conn;

import org.chenyang.http.HttpException;
import org.chenyang.http.HttpHost;
import org.chenyang.http.HttpRequest;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.conn.SchemePortResolver;
import org.chenyang.http.protocol.HttpContext;
import org.chenyang.http.util.Args;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE_CONDITIONAL
)
public class DefaultProxyRoutePlanner extends DefaultRoutePlanner {
   private final HttpHost proxy;

   public DefaultProxyRoutePlanner(HttpHost proxy, SchemePortResolver schemePortResolver) {
      super(schemePortResolver);
      this.proxy = (HttpHost)Args.notNull(proxy, "Proxy host");
   }

   public DefaultProxyRoutePlanner(HttpHost proxy) {
      this(proxy, (SchemePortResolver)null);
   }

   protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
      return this.proxy;
   }
}
