package org.chenyang.http.impl.cookie;

import org.chenyang.http.Header;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.cookie.Cookie;
import org.chenyang.http.cookie.CookieOrigin;
import org.chenyang.http.cookie.MalformedCookieException;
import java.util.Collections;
import java.util.List;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class IgnoreSpec extends CookieSpecBase {
   public int getVersion() {
      return 0;
   }

   public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
      return Collections.emptyList();
   }

   public boolean match(Cookie cookie, CookieOrigin origin) {
      return false;
   }

   public List<Header> formatCookies(List<Cookie> cookies) {
      return Collections.emptyList();
   }

   public Header getVersionHeader() {
      return null;
   }
}
