package org.chenyang.http.impl.cookie;

import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.cookie.CookieSpec;
import org.chenyang.http.cookie.CookieSpecProvider;
import org.chenyang.http.protocol.HttpContext;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class IgnoreSpecProvider implements CookieSpecProvider {
   private volatile CookieSpec cookieSpec;

   public CookieSpec create(HttpContext context) {
      if (this.cookieSpec == null) {
         synchronized(this) {
            if (this.cookieSpec == null) {
               this.cookieSpec = new IgnoreSpec();
            }
         }
      }

      return this.cookieSpec;
   }
}
