package org.chenyang.http.impl.cookie;

import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.cookie.CommonCookieAttributeHandler;
import org.chenyang.http.cookie.MalformedCookieException;
import org.chenyang.http.cookie.SetCookie;
import org.chenyang.http.util.Args;
import org.chenyang.http.util.TextUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class LaxMaxAgeHandler extends AbstractCookieAttributeHandler implements CommonCookieAttributeHandler {
   private static final Pattern MAX_AGE_PATTERN = Pattern.compile("^\\-?[0-9]+$");

   public void parse(SetCookie cookie, String value) throws MalformedCookieException {
      Args.notNull(cookie, "Cookie");
      if (!TextUtils.isBlank(value)) {
         Matcher matcher = MAX_AGE_PATTERN.matcher(value);
         if (matcher.matches()) {
            int age;
            try {
               age = Integer.parseInt(value);
            } catch (NumberFormatException var6) {
               return;
            }

            Date expiryDate = age >= 0 ? new Date(System.currentTimeMillis() + (long)age * 1000L) : new Date(Long.MIN_VALUE);
            cookie.setExpiryDate(expiryDate);
         }

      }
   }

   public String getAttributeName() {
      return "max-age";
   }
}
