package org.chenyang.http.impl.io;

import org.chenyang.http.HttpRequest;
import org.chenyang.http.HttpRequestFactory;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.config.MessageConstraints;
import org.chenyang.http.impl.DefaultHttpRequestFactory;
import org.chenyang.http.io.HttpMessageParser;
import org.chenyang.http.io.HttpMessageParserFactory;
import org.chenyang.http.io.SessionInputBuffer;
import org.chenyang.http.message.BasicLineParser;
import org.chenyang.http.message.LineParser;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE_CONDITIONAL
)
public class DefaultHttpRequestParserFactory implements HttpMessageParserFactory<HttpRequest> {
   public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
   private final LineParser lineParser;
   private final HttpRequestFactory requestFactory;

   public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
      this.lineParser = (LineParser)(lineParser != null ? lineParser : BasicLineParser.INSTANCE);
      this.requestFactory = (HttpRequestFactory)(requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE);
   }

   public DefaultHttpRequestParserFactory() {
      this((LineParser)null, (HttpRequestFactory)null);
   }

   public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
      return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
   }
}
