package org.chenyang.http.impl.io;

import org.chenyang.http.HttpResponse;
import org.chenyang.http.io.SessionOutputBuffer;
import org.chenyang.http.message.LineFormatter;
import java.io.IOException;

public class DefaultHttpResponseWriter extends AbstractMessageWriter<HttpResponse> {
   public DefaultHttpResponseWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
      super(buffer, formatter);
   }

   public DefaultHttpResponseWriter(SessionOutputBuffer buffer) {
      super(buffer, (LineFormatter)null);
   }

   protected void writeHeadLine(HttpResponse message) throws IOException {
      this.lineFormatter.formatStatusLine(this.lineBuf, message.getStatusLine());
      this.sessionBuffer.writeLine(this.lineBuf);
   }
}
