package org.chenyang.http.impl.pool;

import org.chenyang.http.HttpClientConnection;
import org.chenyang.http.HttpHost;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.pool.PoolEntry;
import java.io.IOException;

@Contract(
   threading = ThreadingBehavior.SAFE_CONDITIONAL
)
public class BasicPoolEntry extends PoolEntry<HttpHost, HttpClientConnection> {
   public BasicPoolEntry(String id, HttpHost route, HttpClientConnection conn) {
      super(id, route, conn);
   }

   public void close() {
      try {
         HttpClientConnection connection = (HttpClientConnection)this.getConnection();

         try {
            int socketTimeout = connection.getSocketTimeout();
            if (socketTimeout <= 0 || socketTimeout > 1000) {
               connection.setSocketTimeout(1000);
            }

            connection.close();
         } catch (IOException var3) {
            connection.shutdown();
         }
      } catch (IOException var4) {
      }

   }

   public boolean isClosed() {
      return !((HttpClientConnection)this.getConnection()).isOpen();
   }
}
