package org.chenyang.http.message;

import org.chenyang.http.Header;
import org.chenyang.http.HttpEntity;
import org.chenyang.http.HttpEntityEnclosingRequest;
import org.chenyang.http.ProtocolVersion;
import org.chenyang.http.RequestLine;

public class BasicHttpEntityEnclosingRequest extends BasicHttpRequest implements HttpEntityEnclosingRequest {
   private HttpEntity entity;

   public BasicHttpEntityEnclosingRequest(String method, String uri) {
      super(method, uri);
   }

   public BasicHttpEntityEnclosingRequest(String method, String uri, ProtocolVersion ver) {
      super(method, uri, ver);
   }

   public BasicHttpEntityEnclosingRequest(RequestLine requestline) {
      super(requestline);
   }

   public HttpEntity getEntity() {
      return this.entity;
   }

   public void setEntity(HttpEntity entity) {
      this.entity = entity;
   }

   public boolean expectContinue() {
      Header expect = this.getFirstHeader("Expect");
      return expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
   }
}
