package org.chenyang.http.message;

import org.chenyang.http.HttpRequest;
import org.chenyang.http.HttpVersion;
import org.chenyang.http.ProtocolVersion;
import org.chenyang.http.RequestLine;
import org.chenyang.http.util.Args;

public class BasicHttpRequest extends AbstractHttpMessage implements HttpRequest {
   private final String method;
   private final String uri;
   private RequestLine requestline;

   public BasicHttpRequest(String method, String uri) {
      this.method = (String)Args.notNull(method, "Method name");
      this.uri = (String)Args.notNull(uri, "Request URI");
      this.requestline = null;
   }

   public BasicHttpRequest(String method, String uri, ProtocolVersion ver) {
      this(new BasicRequestLine(method, uri, ver));
   }

   public BasicHttpRequest(RequestLine requestline) {
      this.requestline = (RequestLine)Args.notNull(requestline, "Request line");
      this.method = requestline.getMethod();
      this.uri = requestline.getUri();
   }

   public ProtocolVersion getProtocolVersion() {
      return this.getRequestLine().getProtocolVersion();
   }

   public RequestLine getRequestLine() {
      if (this.requestline == null) {
         this.requestline = new BasicRequestLine(this.method, this.uri, HttpVersion.HTTP_1_1);
      }

      return this.requestline;
   }

   public String toString() {
      return this.method + ' ' + this.uri + ' ' + this.headergroup;
   }
}
