package org.chenyang.http.protocol;

import org.chenyang.http.HttpException;
import org.chenyang.http.HttpResponse;
import org.chenyang.http.HttpResponseInterceptor;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.util.Args;
import java.io.IOException;

@Contract(
   threading = ThreadingBehavior.SAFE
)
public class ResponseDate implements HttpResponseInterceptor {
   private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

   public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
      Args.notNull(response, "HTTP response");
      int status = response.getStatusLine().getStatusCode();
      if (status >= 200 && !response.containsHeader("Date")) {
         String httpdate = DATE_GENERATOR.getCurrentDate();
         response.setHeader("Date", httpdate);
      }

   }
}
