package test;

import java.util.HashMap;
import java.util.Map;
import util.JdbcUtil;
import util.SqlUtil;

public class HiveTest {
   public static void main(String[] args) throws Exception {
      hiveParseTest("grant select on test to role public");
   }

   static Map<String, Object> hiveParseTest(String sql) throws Exception {
      String content = "{\n      \"ip_port\": \"10.11.120.15:10000\",\n      \"url\": \"jdbc:hive2://10.11.120.15:10000/default\",\n      \"username\": \"admin\",\n      \"password\": \"admin\",\n      \"dbType\": \"hive_tdh\",\n      \"clickhouseJdbcUrl\": \"jdbc:clickhouse://192.168.2.155:8123/zero_trust\",\n      \"isIgnorecase\": \"0\",\n      \"excludeSchema\": [],\n      \"includeSchema\": [\"default\",\"testdb\"]\n    }";
      JdbcUtil.initData(content);

      try {
         Thread.sleep(2000L);
      } catch (InterruptedException e) {
         e.printStackTrace();
      }

      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "hive_tdh");
      params.put("schema", "default");
      params.put("url", "jdbc:hive2://10.11.120.15:10000/default");
      params.put("sql", sql);
      params.put("replaceSchema", ".*");
      params.put("replaceNewTable", "people_bk");
      params.put("replaceTable", ".*");
      params.put("replaceColumn", ".*");
      params.put("expression", "concat(substr(${value},1,1),'**')");
      params.put("configPath", "D:/masking-mysql.properties");
      params.put("limit", "3");
      SqlUtil sqlUtil = new SqlUtil();
      Map<String, Object> stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
      System.out.println("..............table_desensitization.....................................");
      String sql3 = sqlUtil.table_desensitization(new HashMap(params));
      System.out.println(sql3);
      return stringObjectMap;
   }

   static Map<String, Object> hiveParseTest2(String sql) throws Exception {
      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "hive_tdh");
      params.put("schema", "default");
      params.put("url", "jdbc:hive2://10.11.120.15:10000/default");
      SqlUtil sqlUtil = new SqlUtil();
      Map<String, Object> stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
      return stringObjectMap;
   }
}
