package test;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.visitor.SchemaStatVisitor;
import com.chenyang.druid.stat.TableStat;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SchemaVistorTest {
   public static void main(String[] args) {
      testKingbaseSchemaVisitor();
   }

   static void testKingbaseSchemaVisitor() {
      String sql = "select this_.USER_ID as USER1_31_0_, this_.ACL_SET as ACL2_31_0_, this_.ALIAS as ALIAS31_0_, this_.CERT_SN as CERT5_31_0_, this_.CHECK_TYPE as CHECK6_31_0_, this_.EMAIL as EMAIL31_0_, this_.GIVEN_NAME as GIVEN9_31_0_, this_.LAST_LOGIN_TIME as LAST11_31_0_, this_.LOCATION as LOCATION31_0_, this_.LOCK_TYPE as LOCK13_31_0_, this_.ORG as ORG31_0_, this_.ORG_ID as ORG15_31_0_, this_.PASSWORD as PASSWORD31_0_, this_.PHONE as PHONE31_0_, this_.PWD_ERR_COUNT as PWD19_31_0_, this_.PWD_UPD_TIME as PWD20_31_0_, this_.ADMIN_ROLE_ID as ADMIN3_31_0_, this_.STATE as STATE31_0_, this_.STATUS as STATUS31_0_, this_.SUBJECT_CN as SUBJECT23_31_0_ from TB_SYS_ADMIN this_  ";
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, DbType.of("oracle"));
      SchemaStatVisitor visitor = SQLUtils.createSchemaStatVisitor(DbType.of("oracle"));
      SQLStatement sqlStatement = (SQLStatement)stmtList.get(0);
      sqlStatement.accept(visitor);
      Map<TableStat.Name, TableStat> tables = visitor.getTables();
      Collection<TableStat.Column> columns = visitor.getColumns();
      System.out.println(tables);
      System.out.println(columns);
   }
}
