package util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ThreadLocalVariable {
    private static ThreadLocal<Map> threadLocal = new ThreadLocal();

    public ThreadLocalVariable() {
    }

    public static void remove() {
        threadLocal.remove();
    }

    public static ThreadLocal<Map> getThreadLocal() {
        return threadLocal;
    }

    public static boolean checkColumn(String schema, String table, String column) {
        Map map = (Map)threadLocal.get();
        if (map == null) {
            return true;
        } else {
            Object columns = map.get("columns");
            if (columns != null) {
                Set<ColumnMeta> columnsSet = (HashSet)columns;
                if (columnsSet.isEmpty()) {
                    return true;
                } else {
                    ColumnMeta temp = new ColumnMeta(schema, table, column);
                    return columnsSet.contains(temp);
                }
            } else {
                return true;
            }
        }
    }

    public static void setcolumns(Set<ColumnMeta> columnMetas) {
        remove();
        Map threadMap = new HashMap();
        threadMap.put("columns", columnMetas);
        ThreadLocal<Map> threadLocal = getThreadLocal();
        threadLocal.set(threadMap);
    }
}
