package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import bean.View;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public abstract class CacheData implements Runnable {
   protected DataBase DataBase;
   protected CountDownLatch cdl;
   protected Connection connection = null;
   protected Statement statement = null;

   public DataBase getDataBase() {
      return this.DataBase;
   }

   public void setDataBase(DataBase dataBase) {
      this.DataBase = dataBase;
   }

   public CountDownLatch getCdl() {
      return this.cdl;
   }

   public void setCdl(CountDownLatch cdl) {
      this.cdl = cdl;
   }

   public CacheData(DataBase dataBase, CountDownLatch cdl) {
      this.DataBase = dataBase;
      this.cdl = cdl;
   }

   public abstract List<Schema> getSchema(Statement var1) throws SQLException;

   public abstract List<Table> getTable(Statement var1, String var2) throws SQLException;

   public abstract List<Column> getColumn(Statement var1, String var2, String var3) throws SQLException;

   public abstract List<View> getView(Statement var1, String var2) throws SQLException;

   public List<Schema> cacheToMemory() throws SQLException, InterruptedException, ClassNotFoundException, IOException {
      throw new RuntimeException("To be implemented.");
   }

   public void cacheWriteToRedis() throws SQLException, InterruptedException, ClassNotFoundException, IOException {
      List<Schema> schemaList = this.cacheToMemory();
      this.DataBase.setSchemaList(schemaList);
      this.DataBase.simpleCache = new DatabaseCache(this.DataBase);
      this.DataBase.simpleCache.init();
   }
}
