package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import bean.View;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import util.JdbcCacheUtil;

public class CacheSparkSQL extends CacheData {
   public CacheSparkSQL(DataBase dataBase, CountDownLatch cdl) {
      super(dataBase, cdl);
   }

   public void run() {
      System.out.println("SparkSQL开始缓存");

      try {
         this.cacheWriteToRedis();
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            JdbcCacheUtil.closeConnection(this.connection);
            if (this.statement != null) {
               this.statement.close();
            }
         } catch (SQLException throwables) {
            throwables.printStackTrace();
         }

         this.getCdl().countDown();
         System.out.println("SparkSQL结束缓存");
      }

   }

   public List<Schema> cacheToMemory() throws SQLException {
      this.connection = JdbcCacheUtil.getConnection(this.DataBase.getUrl(), this.DataBase.getUsername(), this.DataBase.getPassword());
      this.statement = this.connection.createStatement();
      SparkTool spark = new SparkTool(this.connection);
      List<Schema> schemaList = spark.loadDatabase(this.DataBase);
      this.toUppercase(schemaList);
      this.DataBase.setCaseSensitive(false);
      return schemaList;
   }

   public List<Schema> getSchema(Statement statement) throws SQLException {
      return null;
   }

   public List<Table> getTable(Statement statement, String schema) throws SQLException {
      return null;
   }

   public List<Column> getColumn(Statement statement, String schema, String table) throws SQLException {
      return null;
   }

   public List<View> getView(Statement statement, String schema) throws SQLException {
      return null;
   }

   private void toUppercase(List<Schema> schemaList) {
      if (schemaList != null && schemaList.size() != 0) {
         for(Schema schema : schemaList) {
            if (schema != null) {
               schema.setName(schema.getName());
               if (schema.getViewList() != null && schema.getViewList().size() > 0) {
                  for(View view : schema.getViewList()) {
                     if (view != null) {
                        view.setName(view.getName());
                     }
                  }
               }

               if (schema.getTableList() != null && schema.getTableList().size() > 0) {
                  for(Table table : schema.getTableList()) {
                     if (table != null) {
                        table.setName(table.getName());
                        if (table.getColumnList() != null && table.getColumnList().size() != 0) {
                           for(Column column : table.getColumnList()) {
                              if (column != null) {
                                 column.setColumnName(column.getColumnName());
                              }
                           }
                        }
                     }
                  }
               }
            }
         }

      }
   }

   static {
      try {
         Class.forName("org.apache.hive.jdbc.HiveDriver");
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

   }
}
