package util.sqlparse;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLLimit;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.expr.SQLAggregateExpr;
import com.chenyang.druid.sql.ast.expr.SQLBetweenExpr;
import com.chenyang.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.chenyang.druid.sql.ast.expr.SQLBinaryOperator;
import com.chenyang.druid.sql.ast.expr.SQLCaseExpr;
import com.chenyang.druid.sql.ast.expr.SQLCharExpr;
import com.chenyang.druid.sql.ast.expr.SQLExistsExpr;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLInListExpr;
import com.chenyang.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.chenyang.druid.sql.ast.expr.SQLIntegerExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.ast.expr.SQLPropertyExpr;
import com.chenyang.druid.sql.ast.expr.SQLQueryExpr;
import com.chenyang.druid.sql.ast.expr.SQLVariantRefExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLColumnDefinition;
import com.chenyang.druid.sql.ast.statement.SQLCreateStatement;
import com.chenyang.druid.sql.ast.statement.SQLCreateViewStatement;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLDropTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLGrantStatement;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLJoinTableSource;
import com.chenyang.druid.sql.ast.statement.SQLMergeStatement;
import com.chenyang.druid.sql.ast.statement.SQLRevokeStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.chenyang.druid.sql.ast.statement.SQLSelectItem;
import com.chenyang.druid.sql.ast.statement.SQLSelectQuery;
import com.chenyang.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.chenyang.druid.sql.ast.statement.SQLSelectStatement;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLTableElement;
import com.chenyang.druid.sql.ast.statement.SQLTableSource;
import com.chenyang.druid.sql.ast.statement.SQLTruncateStatement;
import com.chenyang.druid.sql.ast.statement.SQLUnionQuery;
import com.chenyang.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUpdateSetItem;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.chenyang.druid.util.StringUtils;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import util.JdbcUtil;
import util.StringJoin;
import util.sqlparse.visitor.common.Context;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.oracle.OracleNameWrapper;
import util.sqlparse.visitor.oracle.SQLParser;
import util.sqlparse.visitor.oracle.visitor.Desensitization;
import util.sqlparse.visitor.oracle.visitor.FieldVisitor;
import util.sqlparse.visitor.oracle.visitor.OracleScopeDialector;
import util.sqlparse.visitor.oracle.visitor.ScopeVisitor;

public class OracleParse {
   public HashMap<String, List<Column>> tableList = new HashMap();
   public List<Column> columnList = new ArrayList();
   public Map<String, String> tableMap = new HashMap();
   public Map<String, Object> whereMap = new HashMap();
   public List<Map<String, Object>> whereValueList = new ArrayList();
   public Map<String, String> unionTableMap = new HashMap();
   public Map<String, String> schemaMap = new HashMap();
   public Map<String, String> params;
   public String withSql = "";
   public String dbType = "oracle";
   private int num = 1;
   private List<SQLObject> parsedCache = new ArrayList();
   private List<SQLExpr> parsedWhereExprs = new ArrayList();
   public List<Map<String, Object>> whereList = new ArrayList();

   public OracleParse(Map<String, String> params) {
      this.params = params;
   }

   public OracleParse() {
   }

   public String rowVisitControl(Map<String, Object> param) throws SQLException {
      Desensitization desensitization = new Desensitization();
      Map map = desensitization.parseRowVisit(param);
      return (String)map.get("newSql");
   }

   public String addWhereCondition(Map<String, Object> param) throws SQLException {
      String sql = (String)param.get("sql");
      String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
      if ("select".equals(sqlType)) {
         SQLSelectQueryBlock query = this.aliParseSelect(this.dbType, sql, false);
         this.parseFromAndAddWhereCondition(((SQLSelectQueryBlock)query).getFrom(), param);
         sql = ((SQLSelectQueryBlock)query).toString();
      } else if ("update".equals(sqlType)) {
         SQLUpdateStatement update = this.aliParseUpdate(this.dbType, sql);
         this.parseUpdateAndAddWhereCondition(update, param);
         sql = update.toString();
      } else if ("delete".equals(sqlType)) {
         SQLDeleteStatement delete = this.aliParseDelete(this.dbType, sql);
         this.parseDeleteAndAddWhereCondition(delete, param);
         sql = delete.toString();
      }

      return sql;
   }

   public void parseFromAndAddWhereCondition(SQLTableSource from, Map<String, Object> param) {
      if (from instanceof SQLExprTableSource) {
         Map<String, List<String>> modifyTable = (Map)param.get("modifyTable");
         Map<String, String> tableKeyWord = (Map)param.get("tableKeyWord");
         SQLExprTableSource fromContent = (SQLExprTableSource)from;
         String[] split = fromContent.getExpr().toString().split("\\.");
         String tableName = "";
         if (split.length > 1) {
            tableName = split[1];
         } else {
            tableName = split[0];
         }

         tableName = tableName.replaceAll("`", "");
         String tableAlisa = fromContent.getAlias();
         tableAlisa = tableAlisa == null ? tableName : tableAlisa;

         SQLObject parent;
         for(parent = fromContent.getParent(); !(parent instanceof SQLSelectQueryBlock) && !(parent instanceof SQLDeleteStatement); parent = parent.getParent()) {
         }

         Iterator var11;
         String key;
         String id;
         String condition;
         if (parent instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock p = (SQLSelectQueryBlock)parent;
            var11 = modifyTable.keySet().iterator();

            while(var11.hasNext()) {
               key = (String)var11.next();
               if (key.equalsIgnoreCase(tableName)) {
                  id = (String)tableKeyWord.get(tableName);
                  condition = "(" + tableAlisa + "." + id + " not in ('";
                  condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
                  condition = condition + " or " + tableAlisa + "." + id + " is null)";
                  p.addCondition(condition);
               }
            }
         } else if (parent instanceof SQLDeleteStatement) {
            SQLDeleteStatement p = (SQLDeleteStatement)parent;
            var11 = modifyTable.keySet().iterator();

            while(var11.hasNext()) {
               key = (String)var11.next();
               if (key.equalsIgnoreCase(tableName)) {
                  id = (String)tableKeyWord.get(tableName);
                  condition = tableAlisa + "." + id + " not in ('";
                  condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
                  p.addCondition(condition);
               }
            }
         }
      } else if (from instanceof SQLJoinTableSource) {
         SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
         SQLTableSource left = fromContent.getLeft();
         this.parseFromAndAddWhereCondition(left, param);
         SQLTableSource right = fromContent.getRight();
         this.parseFromAndAddWhereCondition(right, param);
      } else if (from instanceof SQLUnionQueryTableSource) {
         SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
         String alias = fromContent.getAlias();
         SQLUnionQuery union = fromContent.getUnion();
         List<SQLSelectQueryBlock> unionList = new ArrayList();
         this.parseUnionFrom(union, unionList);
      } else if (from instanceof SQLSubqueryTableSource) {
         SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
         SQLSelect select = fromContent.getSelect();
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
         this.parseFromAndAddWhereCondition(query.getFrom(), param);
      }

   }

   public void parseUpdateAndAddWhereCondition(SQLUpdateStatement update, Map<String, Object> param) {
      Map<String, List<String>> modifyTable = (Map)param.get("modifyTable");
      Map<String, String> tableKeyWord = (Map)param.get("tableKeyWord");
      SQLName table = update.getTableName();
      String tableName = table.getSimpleName();
      String tableAlisa = tableName;
      String[] tableInfo = tableName.split("\\.");
      if (tableInfo.length > 1) {
         tableName = tableInfo[1];
         tableAlisa = tableInfo[0];
      }

      tableName = tableName;
      Iterator var9 = modifyTable.keySet().iterator();

      while(var9.hasNext()) {
         String key = (String)var9.next();
         if (key.equalsIgnoreCase(tableName)) {
            String id = (String)tableKeyWord.get(tableName);
            String condition = "(" + tableAlisa + "." + id + " not in ('";
            condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
            condition = condition + " or " + tableAlisa + "." + id + " is null)";
            update.addCondition(condition);
         }
      }

   }

   public void parseDeleteAndAddWhereCondition(SQLDeleteStatement delete, Map<String, Object> param) {
      Map<String, List<String>> modifyTable = (Map)param.get("modifyTable");
      Map<String, String> tableKeyWord = (Map)param.get("tableKeyWord");
      SQLName table = delete.getTableName();
      String tableName = table.getSimpleName();
      String tableAlisa = tableName;
      String[] tableInfo = tableName.split("\\.");
      if (tableInfo.length > 1) {
         tableName = tableInfo[1];
         tableAlisa = tableInfo[0];
      }

      tableName = tableName;
      Iterator var9 = modifyTable.keySet().iterator();

      while(var9.hasNext()) {
         String key = (String)var9.next();
         if (key.equalsIgnoreCase(tableName)) {
            String id = (String)tableKeyWord.get(tableName);
            String condition = "(" + tableAlisa + "." + id + " not in ('";
            condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
            condition = condition + " or " + tableAlisa + "." + id + " is null)";
            delete.addCondition(condition);
         }
      }

   }

   public String parseSql() {
      Desensitization desensitization = new Desensitization();
      Map map = desensitization.parseData(this.params);
      return (String)map.get("newSql");
   }

   public String parseSql_column() {
      Desensitization desensitization = new Desensitization();
      Map map = desensitization.parseColumn(this.params);
      return (String)map.get("newSql");
   }

   public String parseSql_table() {
      try {
         Desensitization desensitization = new Desensitization();
         desensitization.parseTable(this.params);
      } catch (Exception var2) {
         Exception throwables = var2;
         throwables.printStackTrace();
      }

      return (String)this.params.get("newSql");
   }

   public String parseSql_data() {
      Desensitization desensitization = new Desensitization();
      Map map = desensitization.parseData(this.params);
      return (String)map.get("newSql");
   }

   public void parseSqlStructureAndReplace(Map<String, Object> paramMap, List<Map> repalceMap) throws SQLException {
      String sql = (String)this.params.get("sql");
      String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
      String parseSql;
      if ("select".equals(sqlType)) {
         parseSql = this.parseSelect(this.dbType, sql);
         paramMap.put("type", "select");
         paramMap.put("sql", parseSql);
      } else if ("union".equals(sqlType)) {
         parseSql = this.parseUnion(this.dbType, sql);
         paramMap.put("type", "union");
         paramMap.put("sql", parseSql);
      }

      paramMap.put("tableMap", this.tableMap);
      paramMap.put("columnList", this.columnList);
      paramMap.put("schemaMap", this.schemaMap);
      paramMap.put("whereMap", this.whereMap);
      paramMap.put("whereList", this.flatWhereListValues());
   }

   public void parseSqlStructureAndReplace2(Map<String, Object> paramMap, List<Map> repalceMap) throws SQLException {
      String sql = (String)this.params.get("sql");
      String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
      if ("select".equals(sqlType) || "union".equals(sqlType) || "update".equals(sqlType) || "insert".equals(sqlType) || "delete".equals(sqlType) || "merge".equals(sqlType)) {
         String permission = (String)this.params.get("permission");
         String url = (String)this.params.get("url");
         String schema = (String)this.params.get("schema");
         String url1 = url.substring(url.indexOf(64) + 1);
         int idx = url1.lastIndexOf(47);
         if (idx == -1) {
            idx = url1.lastIndexOf(58);
         }

         String ip_port = url1.substring(0, idx);
         SQLParser sqlParser = new SQLParser();
         DataBase dataBase = new DataBase();
         Iterator var13 = JdbcUtil.dataBaseList.iterator();

         while(var13.hasNext()) {
            DataBase db = (DataBase)var13.next();
            if (ip_port.equalsIgnoreCase(db.getIp_port())) {
               dataBase = db;
               break;
            }
         }

         SQLResult parse = sqlParser.parse(sql, dataBase, schema);
         List<FieldInfo> columnlist = new ArrayList();
         if ("masking".equalsIgnoreCase(permission)) {
            columnlist = parse.outputs;
         } else if ("full".equalsIgnoreCase(permission)) {
            columnlist = parse.fields;
         } else if (!"insert".equalsIgnoreCase(sqlType) && !"update".equalsIgnoreCase(sqlType)) {
            columnlist = parse.outputs;
         }

         Iterator var15 = ((List)columnlist).iterator();

         while(var15.hasNext()) {
            FieldInfo fieldInfo = (FieldInfo)var15.next();
            List<FieldInfo> fieldInfoList = new ArrayList();
            if (fieldInfo.getRelations().size() > 1) {
               fieldInfoList = fieldInfo.getRelations();
            } else {
               ((List)fieldInfoList).add(fieldInfo);
            }

            Iterator var18 = ((List)fieldInfoList).iterator();

            while(var18.hasNext()) {
               FieldInfo info = (FieldInfo)var18.next();
               String name = info.getName();
               Map<String, TableInfo> tables = info.getTables();
               String tableName = "";

               String s;
               for(Iterator var23 = tables.keySet().iterator(); var23.hasNext(); tableName = s.split("\\.")[1]) {
                  s = (String)var23.next();
               }

               Column column = new Column();
               column.setColumnName(tableName + "." + name);
               column.setColumnAlisa(info.getAlias() != null && !"".equals(info.getAlias()) ? info.getAlias().replaceAll("\"", "") : "");
               column.setSubQuery(false);
               this.columnList.add(column);
            }
         }

         var15 = parse.tables.iterator();

         while(var15.hasNext()) {
            TableInfo table = (TableInfo)var15.next();
            TableMemo tb = table.getTable();
            this.tableMap.put(tb.name, tb.name);
            this.schemaMap.put(tb.name, tb.schema);
         }

         var15 = parse.values.iterator();

         while(var15.hasNext()) {
            ValueInfo value = (ValueInfo)var15.next();
            FieldMemo field = value.field;
            this.whereMap.put(field.name, value.value.toString());
            Map<String, Object> map = new HashMap();
            map.put("column", field.getAtomName());
            map.put("columnValue", value.value.toString());
            map.put("type", value.operator);
            this.whereList.add(map);
         }

         sqlParser.replace(parse.values, repalceMap);
         paramMap.put("whereList", this.whereList);
         paramMap.put("statement", parse.statement);
         paramMap.put("type", parse.sqlType.name().toLowerCase());
         paramMap.put("sql", parse.statement.toString());
      }

      paramMap.put("tableMap", this.tableMap);
      paramMap.put("columnList", this.columnList);
      paramMap.put("schemaMap", this.schemaMap);
      paramMap.put("whereMap", this.whereMap);
      paramMap.put("whereList", this.flatWhereListValues());
   }

   private List<Map<String, Object>> flatWhereListValues() {
      if (this.whereValueList != null && this.whereValueList.size() != 0) {
         List<Map<String, Object>> flats = new ArrayList();
         Iterator var2 = this.whereValueList.iterator();

         while(true) {
            while(true) {
               while(var2.hasNext()) {
                  Map<String, Object> column = (Map)var2.next();
                  Object columnValue = column.get("columnValue");
                  if (columnValue instanceof List) {
                     List values = (List)columnValue;
                     if (values != null && values.size() != 0) {
                        Iterator var6 = values.iterator();

                        while(var6.hasNext()) {
                           Object value = var6.next();
                           Map<String, Object> columnMap = new HashMap(column);
                           columnMap.put("columnValue", value);
                           flats.add(columnMap);
                        }
                     } else {
                        column.put("columnValue", "");
                        flats.add(column);
                     }
                  } else {
                     flats.add(column);
                  }
               }

               return flats;
            }
         }
      } else {
         return this.whereValueList;
      }
   }

   private void putInWhereParams(SQLExpr expr, String key, Object value) {
      Iterator var4 = this.parsedWhereExprs.iterator();

      while(var4.hasNext()) {
         SQLExpr parsedExpr = (SQLExpr)var4.next();
         if (expr == parsedExpr) {
            return;
         }
      }

      HashMap<String, Object> map = new HashMap();
      String type = SQLBinaryOperator.Equality.toString();
      SQLObject curr = expr;
      SQLObject op = null;
      int MAX_STEP = 10;

      for(int i = 0; i < MAX_STEP; ++i) {
         if (curr instanceof SQLBinaryOpExpr) {
            op = curr;
            break;
         }

         if (curr instanceof SQLInListExpr) {
            op = curr;
            break;
         }

         if (((SQLObject)curr).getParent() == null) {
            break;
         }

         curr = ((SQLObject)curr).getParent();
      }

      if (op != null) {
         if (op instanceof SQLBinaryOpExpr) {
            type = ((SQLBinaryOpExpr)op).getOperator().toString();
         }

         if (op instanceof SQLInListExpr) {
            type = "IN";
         }
      }

      map.put("column", key);
      map.put("columnValue", value);
      map.put("type", type);
      this.whereValueList.add(map);
      this.parsedWhereExprs.add(expr);
   }

   private boolean parseMethodInvokeExpr(SQLExpr expr, SQLExpr right) {
      if (!(expr instanceof SQLMethodInvokeExpr)) {
         return false;
      } else {
         List<SQLExpr> params = ((SQLMethodInvokeExpr)expr).getParameters();
         String colValue = right.toString();
         if (params != null) {
            Iterator var5 = params.iterator();

            while(true) {
               SQLExpr param;
               String colName;
               String tableName;
               String schema;
               while(true) {
                  if (!var5.hasNext()) {
                     return true;
                  }

                  param = (SQLExpr)var5.next();
                  colName = "";
                  tableName = "";
                  schema = "";
                  String key;
                  if (!(param instanceof SQLIdentifierExpr)) {
                     if (param instanceof SQLPropertyExpr) {
                        SQLExpr owner = ((SQLPropertyExpr)param).getOwner();
                        key = ((SQLIdentifierExpr)owner).getName();
                        colName = ((SQLPropertyExpr)param).getName();
                        tableName = (String)this.tableMap.get(key);
                        schema = (String)this.schemaMap.get(tableName);
                        break;
                     }

                     if (param instanceof SQLCharExpr) {
                        continue;
                     }
                     break;
                  }

                  colName = ((SQLIdentifierExpr)param).getName();
                  Iterator var10 = this.tableMap.keySet().iterator();

                  while(var10.hasNext()) {
                     key = (String)var10.next();
                     if (!key.isEmpty()) {
                        tableName = (String)this.tableMap.get(key);
                     }
                  }

                  schema = (String)this.schemaMap.get(tableName);
                  break;
               }

               this.whereMap.put(schema + "." + tableName + "." + colName, colValue);
               this.putInWhereParams(param, schema + "." + tableName + "." + colName, colValue);
            }
         } else {
            return true;
         }
      }
   }

   public void parseWhere(SQLExpr where) throws SQLException {
      if (where != null) {
         boolean exists = false;

         for(int i = 0; i < this.parsedCache.size(); ++i) {
            SQLExpr expr = (SQLExpr)this.parsedCache.get(i);
            if (expr == where) {
               exists = true;
            }
         }

         if (!exists) {
            this.parsedCache.add(where);
            String tableAlias = null;
            String tableName;
            String schema;
            String colValue;
            String value;
            if (where instanceof SQLBinaryOpExpr) {
               SQLBinaryOpExpr sqlExpr = (SQLBinaryOpExpr)where;
               SQLBinaryOperator operator = sqlExpr.getOperator();
               if (operator.toString().equalsIgnoreCase("BooleanAnd")) {
                  this.parseWhere(sqlExpr.getLeft());
                  this.parseWhere(sqlExpr.getRight());
               } else if (operator.toString().equalsIgnoreCase("BooleanOr")) {
                  this.parseWhere(sqlExpr.getLeft());
                  this.parseWhere(sqlExpr.getRight());
               } else {
                  String colName;
                  SQLExpr left;
                  SQLExpr right;
                  Iterator var12;
                  String finalColName;
                  SQLExpr owner;
                  if (operator.toString().equalsIgnoreCase("like")) {
                     tableName = "";
                     colName = "";
                     Object colValueNew582 = "";
                     schema = "";
                     left = sqlExpr.getLeft();
                     right = sqlExpr.getRight();
                     if (right instanceof SQLCharExpr) {
                        colValueNew582 = ((SQLCharExpr)right).getText().replaceAll("%", "").replaceAll("_", "");
                     } else if (right instanceof SQLVariantRefExpr) {
                        colValueNew582 = right.toString().replaceAll("%", "").replaceAll("_", "");
                     } else if (right instanceof SQLMethodInvokeExpr) {
                        colValueNew582 = ((SQLMethodInvokeExpr)right).getArguments();
                     }

                     if (!this.parseMethodInvokeExpr(left, right)) {
                        if (!(left instanceof SQLIdentifierExpr)) {
                           if (left instanceof SQLPropertyExpr) {
                              owner = ((SQLPropertyExpr)left).getOwner();
                              finalColName = ((SQLIdentifierExpr)owner).getName();
                              colName = ((SQLPropertyExpr)left).getName();
                              tableName = (String)this.tableMap.get(finalColName);
                              schema = (String)this.schemaMap.get(tableName);
                           }
                        } else {
                           colName = ((SQLIdentifierExpr)left).getName();
                           var12 = this.tableMap.keySet().iterator();

                           while(var12.hasNext()) {
                              finalColName = (String)var12.next();
                              if (!finalColName.isEmpty()) {
                                 tableName = (String)this.tableMap.get(finalColName);
                              }
                           }

                           schema = (String)this.schemaMap.get(tableName);
                        }

                        this.whereMap.put(schema + "." + tableName + "." + colName, colValueNew582);
                        this.putInWhereParams(left, schema + "." + tableName + "." + colName, colValueNew582);
                     }
                  } else if (!operator.toString().equalsIgnoreCase("equality") && !operator.toString().equalsIgnoreCase("LessThanOrGreater") && !operator.toString().equalsIgnoreCase("NotEqual") && !operator.toString().equalsIgnoreCase(SQLBinaryOperator.LessThan.toString()) && !operator.toString().equalsIgnoreCase(SQLBinaryOperator.LessThanOrEqual.toString()) && !operator.toString().equalsIgnoreCase(SQLBinaryOperator.GreaterThan.toString()) && !operator.toString().equalsIgnoreCase(SQLBinaryOperator.GreaterThanOrEqual.toString())) {
                     if (!operator.toString().equalsIgnoreCase(SQLBinaryOperator.Is.toString()) && !operator.toString().equalsIgnoreCase(SQLBinaryOperator.IsNot.toString())) {
                        left = sqlExpr.getLeft();
                        right = sqlExpr.getRight();
                        if (!this.parseMethodInvokeExpr(left, right)) {
                           try {
                              if (left.getClass().getName().contains("SQLIdentifierExpr") && left.toString().split("\\.").length == 1) {
                                 Map<String, String> localMap = new HashMap();
                                 this.parseFrom(((SQLSelectQueryBlock)where.getParent()).getFrom(), localMap, "", true);
                                 this.columnAddTableAlias(left, localMap);
                              }
                           } catch (SQLException var17) {
                              var17.printStackTrace();
                           }

                           colValue = left.toString();
                           schema = right.toString();
                           value = (String)this.whereMap.get(colValue);
                           if (value == null) {
                              this.whereMap.put(colValue, schema);
                              this.putInWhereParams(left, colValue, schema);
                           } else if (!value.equalsIgnoreCase(schema)) {
                              this.whereMap.put(colValue, value + "," + schema);
                              this.putInWhereParams(left, colValue, value + "," + schema);
                           }
                        }
                     }
                  } else {
                     tableName = "";
                     colName = "";
                     colValue = "";
                     schema = "";
                     left = sqlExpr.getLeft();
                     right = sqlExpr.getRight();
                     if (!(left instanceof SQLIntegerExpr) && !(left instanceof SQLCharExpr) && !this.parseMethodInvokeExpr(left, right)) {
                        if (!(left instanceof SQLIdentifierExpr)) {
                           if (left instanceof SQLPropertyExpr) {
                              owner = ((SQLPropertyExpr)left).getOwner();
                              finalColName = ((SQLIdentifierExpr)owner).getName();
                              colName = ((SQLPropertyExpr)left).getName();
                              tableAlias = finalColName.toLowerCase();
                              tableName = (String)this.tableMap.get(finalColName.toLowerCase());
                              schema = (String)this.schemaMap.get(tableName);
                           }
                        } else {
                           colName = ((SQLIdentifierExpr)left).getName();
                           var12 = this.tableMap.keySet().iterator();

                           while(var12.hasNext()) {
                              finalColName = (String)var12.next();
                              if (!finalColName.isEmpty()) {
                                 tableName = (String)this.tableMap.get(finalColName);
                              }
                           }

                           schema = (String)this.schemaMap.get(tableName);
                        }

                        if (right instanceof SQLCharExpr) {
                           colValue = ((SQLCharExpr)right).getText();
                        } else if (right instanceof SQLVariantRefExpr) {
                           colValue = right.toString();
                        } else if (right instanceof SQLIntegerExpr) {
                           colValue = right.toString();
                        }

                        if (tableName == null && tableAlias != null && this.tableList.containsKey(tableAlias)) {
                           List<Column> columns = (List)this.tableList.get(tableAlias);
                           finalColName = colName;
                           Column column = null;

                           for(int i = 0; i < columns.size(); ++i) {
                              Column columnTemp = (Column)columns.get(i);
                              if (finalColName.equalsIgnoreCase(columnTemp.getColumnName()) || columnTemp.getColumnName().contains("." + finalColName)) {
                                 column = columnTemp;
                                 break;
                              }
                           }

                           if (column != null) {
                              String[] arr = column.getColumnName().split("\\.");
                              String alias = "";
                              if (arr.length == 2) {
                                 alias = arr[0];
                              } else if (arr.length == 3) {
                                 alias = arr[1];
                              }

                              if (alias != "") {
                                 tableName = (String)this.tableMap.get(alias.toLowerCase());
                                 schema = (String)this.schemaMap.get(tableName);
                              }
                           }
                        }

                        this.whereMap.put(schema + "." + tableName + "." + colName, colValue);
                        this.putInWhereParams(left, schema + "." + tableName + "." + colName, colValue);
                     }
                  }
               }
            } else if (where instanceof SQLExistsExpr) {
               SQLExistsExpr existsExpr = (SQLExistsExpr)where;
               SQLSelect sqlSelect = existsExpr.subQuery;
               SQLBinaryOpExpr curWhere = (SQLBinaryOpExpr)((SQLSelectQueryBlock)sqlSelect.getQuery()).getWhere();
               this.parseWhere(curWhere);
            } else if (where instanceof SQLInListExpr) {
               SQLInListExpr sqlInListExpr = (SQLInListExpr)where;
               String columnWithTable = "";
               tableName = "";
               if (this.isHaveOwner(sqlInListExpr)) {
                  SQLPropertyExpr expr = (SQLPropertyExpr)sqlInListExpr.getExpr();
                  SQLIdentifierExpr owner = (SQLIdentifierExpr)expr.getOwner();
                  schema = owner.getName();
                  tableName = (String)this.tableMap.get(schema);
                  value = (String)this.schemaMap.get(tableName);
                  columnWithTable = value + "." + tableName + "." + expr.getName();
               } else {
                  SQLObject parent;
                  for(parent = sqlInListExpr.getParent(); !(parent instanceof SQLSelectQueryBlock); parent = parent.getParent()) {
                  }

                  tableName = ((SQLPropertyExpr)((SQLExprTableSource)((SQLSelectQueryBlock)parent).getFrom()).getExpr()).getName();
                  colValue = (String)this.schemaMap.get(tableName);
                  tableName = colValue + "." + tableName;
                  columnWithTable = tableName + "." + ((SQLIdentifierExpr)sqlInListExpr.getExpr()).getName();
               }

               this.whereMap.put(columnWithTable, sqlInListExpr.getTargetList());
               this.putInWhereParams(sqlInListExpr, columnWithTable, sqlInListExpr.getTargetList());
            } else if (where instanceof SQLInSubQueryExpr) {
               SQLInSubQueryExpr subInQuery = (SQLInSubQueryExpr)where;
               this.parseSelect(subInQuery.getSubQuery());
            }

         }
      }
   }

   public boolean isHaveOwner(SQLInListExpr sqlInListExpr) {
      boolean isHave = true;

      try {
         SQLPropertyExpr expr = (SQLPropertyExpr)sqlInListExpr.getExpr();
         SQLIdentifierExpr var4 = (SQLIdentifierExpr)expr.getOwner();
      } catch (Exception var5) {
         isHave = false;
      }

      return isHave;
   }

   public void parseLimit(SQLLimit limit) {
      if (limit != null) {
         SQLExpr offset = limit.getOffset();
         SQLExpr rowCount = limit.getRowCount();
         if (offset != null) {
            this.putInWhereParams(offset, "a.b.limit1", offset.toString());
         }

         if (rowCount != null) {
            this.putInWhereParams(rowCount, "a.b.limit2", rowCount.toString());
         }

      }
   }

   public static void main(String[] args) {
      String ipPort = getIpPort("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.2.236)(PORT=1521))(CONNECT_DATA=(SERVER=DEDICATED)(SERVICE_NAME=ORCL)))");
      System.out.print(ipPort);
   }

   public static String getIpPort(String url) {
      Pattern pattern = Pattern.compile("\\(HOST", 2);
      String ip_port;
      if (pattern.matcher(url).find()) {
         String hostAfter = url.substring(url.indexOf("(HOST") + 6);
         ip_port = hostAfter.substring(0, hostAfter.indexOf(")")).trim();
         String portAfter = url.substring(url.indexOf("(PORT") + 6);
         String port = portAfter.substring(0, portAfter.indexOf(")")).trim();
         return ip_port + ":" + port;
      } else {
         String[] urlSplit = url.split("@")[1].split(":");
         ip_port = urlSplit[0] + ":" + urlSplit[1];
         int idx = ip_port.indexOf(47);
         if (idx != -1) {
            ip_port = ip_port.substring(0, idx);
         }

         return ip_port;
      }
   }

   public void parseSqlStructure(Map<String, Object> paramMap) throws SQLException {
      System.out.println("传入的参数：=========================================>" + this.params);
      String sql = (String)this.params.get("sql");
      boolean isEncryption = this.params.containsKey("encryption");
      List<SQLStatement> statements = SQLUtils.parseStatements(sql, "oracle");
      if (statements != null && statements.size() != 0) {
         String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
         if (!"insert_select".equals(sqlType) && !"insert".equals(sqlType) && !"update".equals(sqlType) && !"delete".equals(sqlType) && !"select".equals(sqlType) && !"union".equals(sqlType) && !"merge".equals(sqlType)) {
            if ("truncate".equals(sqlType)) {
               SQLTruncateStatement truncate = this.parseTruncate(this.dbType, sql);
               paramMap.put("type", "truncate");
               paramMap.put("statement", truncate);
               paramMap.put("sql", truncate.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("create".equals(sqlType)) {
               paramMap.put("type", "create");
               paramMap.put("sql", sql);
               SQLCreateStatement create = this.parseCreate(this.dbType, sql);
               paramMap.put("statement", create);
               paramMap.put("sql", create.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("alter".equals(sqlType)) {
               SQLAlterTableStatement alter = this.parseAlter(this.dbType, sql);
               paramMap.put("type", "alter");
               paramMap.put("statement", alter);
               paramMap.put("sql", alter.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("with_select".equals(sqlType)) {
               String parseSql = this.parseWithSelect(this.dbType, sql);
               paramMap.put("type", "with_select");
               paramMap.put("sql", parseSql);
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("drop".equals(sqlType)) {
               SQLDropTableStatement drop = this.parseDrop(this.dbType, sql);
               paramMap.put("type", "drop");
               paramMap.put("sql", sql);
               paramMap.put("statement", drop);
               paramMap.put("sql", drop.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("grant".equals(sqlType)) {
               SQLGrantStatement grant = this.parseGrant(this.dbType, sql);
               paramMap.put("type", "grant");
               paramMap.put("statement", grant);
               paramMap.put("sql", grant.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("revoke".equals(sqlType)) {
               SQLRevokeStatement revoke = this.parseRevoke(this.dbType, sql);
               paramMap.put("type", "revoke");
               paramMap.put("statement", revoke);
               paramMap.put("sql", revoke.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            }
         } else {
            String permission = (String)this.params.get("permission");
            String url = (String)this.params.get("url");
            String schema = (String)this.params.get("schema");
            String ip_port = getIpPort(url);
            SQLParser sqlParser = new SQLParser();
            DataBase dataBase = new DataBase();
            Iterator var13 = JdbcUtil.dataBaseList.iterator();

            while(var13.hasNext()) {
               DataBase db = (DataBase)var13.next();
               if (ip_port.equalsIgnoreCase(db.getIp_port())) {
                  dataBase = db;
                  break;
               }
            }

            if (!isEncryption && sqlType.equalsIgnoreCase("delete")) {
               SQLDeleteStatement stmt = (SQLDeleteStatement)statements.get(0);
               this.parseDeleteColumns(stmt);
               paramMap.put("tableMap", this.tableMap);
               paramMap.put("columnList", this.columnList);
               paramMap.put("schemaMap", this.schemaMap);
               paramMap.put("whereMap", this.whereMap);
               paramMap.put("sql", stmt.toString());
               paramMap.put("whereList", this.flatWhereListValues());
               paramMap.put("type", sqlType);
               return;
            }

            SQLResult parse = sqlParser.parse(sql, dataBase, schema);
            new ArrayList();
            List columnlist;
            if ("masking".equalsIgnoreCase(permission)) {
               columnlist = parse.outputs;
            } else if ("full".equalsIgnoreCase(permission)) {
               columnlist = parse.fields;
            } else if (isEncryption) {
               if (!"insert".equalsIgnoreCase(sqlType) && !"update".equalsIgnoreCase(sqlType)) {
                  columnlist = parse.outputs;
               } else {
                  columnlist = parse.fields;
               }
            } else {
               columnlist = parse.outputs;
            }

            OracleNameWrapper wrapper = new OracleNameWrapper(dataBase.simpleCache);
            Set<String> tabSet = new HashSet();
            List<Column> cols = new ArrayList();
            int i = 0;
            Iterator var19 = columnlist.iterator();

            label161:
            while(var19.hasNext()) {
               FieldInfo fieldInfo = (FieldInfo)var19.next();
               ++i;
               List<FieldInfo> fieldInfoList = new ArrayList();
               if (fieldInfo.getRelations().size() > 0) {
                  fieldInfoList = fieldInfo.getRelations();
               } else {
                  ((List)fieldInfoList).add(fieldInfo);
               }

               Iterator var22 = ((List)fieldInfoList).iterator();

               while(true) {
                  FieldInfo info;
                  String name;
                  do {
                     if (!var22.hasNext()) {
                        continue label161;
                     }

                     info = (FieldInfo)var22.next();
                     name = info.getName();
                  } while(StringJoin.isEmpty(name));

                  Map<String, TableInfo> tables = info.getTables();
                  String tableName = "";
                  String schemaName = "";
                  Iterator var28 = tables.keySet().iterator();

                  while(var28.hasNext()) {
                     String s = (String)var28.next();
                     String[] segment = s.split("\\.");
                     if (!StringJoin.isEmpty(segment[0]) && !StringJoin.isEmpty(segment[1])) {
                        schemaName = segment[0];
                        tableName = segment[1];
                        break;
                     }
                  }

                  if (tableName.length() == 0 && info.getTables().size() > 0) {
                     var28 = info.getTables().entrySet().iterator();

                     while(var28.hasNext()) {
                        Map.Entry<String, TableInfo> entry = (Map.Entry)var28.next();
                        TableInfo tbInfo = (TableInfo)entry.getValue();
                        if (tbInfo != null && tbInfo.getTable() != null && !StringJoin.isEmpty(tbInfo.getTable().schema) && !StringJoin.isEmpty(tbInfo.getTable().name)) {
                           tableName = tbInfo.getTable().name;
                           schemaName = tbInfo.getTable().schema;
                           break;
                        }
                     }
                  }

                  schemaName = wrapper.unwrapSchema(schemaName);
                  tableName = wrapper.unwrapTable(schemaName, tableName);
                  tabSet.add(tableName);
                  Column column = new Column();
                  column.setColumnName(tableName + "." + name);
                  column.setTable(tableName);
                  column.setSchema(schemaName);
                  column.setColumnAlisa(info.getAlias() != null && !"".equals(info.getAlias()) ? info.getAlias().replaceAll("\"", "") : "");
                  column.setSubQuery(false);
                  column.seq = i;
                  cols.add(column);
                  if (!name.equalsIgnoreCase("ROWID") && !name.equalsIgnoreCase("ORA_ROWSCN")) {
                     this.columnList.add(column);
                  }
               }
            }

            var19 = parse.tables.iterator();

            String colName;
            while(var19.hasNext()) {
               TableInfo table = (TableInfo)var19.next();
               TableMemo tb = table.getTable();
               String schName = wrapper.unwrapSchema(tb.schema);
               colName = wrapper.unwrapTable(schName, tb.name);
               if (tabSet.contains(colName)) {
                  this.tableMap.put(colName, colName);
                  this.schemaMap.put(colName, schName);
               }
            }

            var19 = parse.values.iterator();

            while(var19.hasNext()) {
               ValueInfo value = (ValueInfo)var19.next();
               FieldMemo field = value.field;
               this.whereMap.put(field.name, value.value.toString());
               Map<String, Object> map = new HashMap();
               colName = value.getValueNames();
               if (colName != null) {
                  colName = colName.replace("\"", "");
               }

               map.put("column", colName);
               map.put("columnValue", value.value.toString());
               map.put("type", value.operator);
               this.whereList.add(map);
            }

            paramMap.put("whereList", this.whereList);
            paramMap.put("statement", parse.statement);
            paramMap.put("type", parse.sqlType.name().toLowerCase());
            paramMap.put("sql", parse.statement.toString());
            paramMap.put("output-cols", cols);
            wrapper.unwrapFullColumns(this.columnList);
         }

         paramMap.put("tableMap", this.tableMap);
         paramMap.put("columnList", this.columnList);
         paramMap.put("schemaMap", this.schemaMap);
         paramMap.put("whereMap", this.whereMap);
      }
   }

   private void parseSelect(SQLSelect select) throws SQLException {
      SQLSelectQuery selectQuery = select.getQueryBlock();
      if (selectQuery instanceof SQLUnionQuery) {
         StringBuilder result = new StringBuilder();
         SQLUnionQuery query = (SQLUnionQuery)selectQuery;
         this.dealUnion(query, result);
      } else {
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
         this.parseFrom(query.getFrom(), (Map)null, "", true);
         this.parseFrom(query.getFrom(), (Map)null, "", false);
         this.parseWhere(query.getWhere());
         this.parseLimit(query.getLimit());
         String sql = this.parseSelectStar(query);
         SQLSelectQueryBlock queryNew1952 = this.aliParseSelect(this.dbType, sql, false);
         this.parseQueryColumns(queryNew1952, "");
         this.parseSelectStar(queryNew1952);
      }

   }

   public String parseSelect(String dbType, String sql) throws SQLException {
      OracleSelectQueryBlock query = this.aliParseSelect(dbType, sql, true);
      this.parseFrom(query.getFrom(), (Map)null, "", true);
      this.parseFrom(query.getFrom(), (Map)null, "", false);
      this.parseWhere(query.getWhere());
      this.parseLimit(query.getLimit());
      sql = this.parseSelectStar(query);
      query = this.aliParseSelect(dbType, sql, false);
      this.parseQueryColumns(query, "");
      sql = this.parseSelectStar(query);
      return sql;
   }

   public OracleSelectQueryBlock aliParseSelect(String dbType, String sql, boolean first) throws SQLException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
         SQLSelect select = stmt.getSelect();
         OracleSelectQueryBlock query = (OracleSelectQueryBlock)select.getQuery();
         if (first) {
            query = JdbcUtil.oracleJudgeViewAndModify(query, this.params, this.tableList);
         }

         return query;
      }
   }

   public Map<String, String> parseFrom(SQLTableSource from, Map<String, String> map, String subTableAlias, boolean first) throws SQLException {
      String className = from.getClass().getName();
      String tableName;
      String sql;
      if (className.contains("OracleSelectTableReference")) {
         OracleSelectTableReference fromContent = (OracleSelectTableReference)from;
         tableName = fromContent.getExpr().toString();
         String tableAlisa = fromContent.getAlias();
         sql = fromContent.getExpr().getClass().getName();
         String name;
         String realTable;
         if (sql.contains("SQLPropertyExpr")) {
            SQLPropertyExpr expr = (SQLPropertyExpr)fromContent.getExpr();
            tableName = expr.getName();
            name = expr.getOwner().toString();
            this.schemaMap.put(tableName, name);
         } else {
            realTable = (String)this.params.get("schema");
            SQLIdentifierExpr expr = (SQLIdentifierExpr)fromContent.getExpr();
            SQLPropertyExpr pExpr = new SQLPropertyExpr();
            pExpr.setName(expr.getName());
            pExpr.setOwner(realTable);
            fromContent.setExpr(pExpr);
            this.schemaMap.put(tableName, realTable);
         }

         tableAlisa = tableAlisa == null ? tableName : tableAlisa;
         if (map == null) {
            this.tableMap.put(tableAlisa.toLowerCase(), tableName);
            realTable = (String)this.tableMap.get(subTableAlias);
            if (realTable == null) {
               if (subTableAlias != null && !"".equals(subTableAlias)) {
                  subTableAlias = subTableAlias.toLowerCase();
               } else {
                  subTableAlias = "";
               }

               this.tableMap.put(subTableAlias, tableName);
            } else if (!realTable.equalsIgnoreCase(subTableAlias)) {
               if (subTableAlias != null && !"".equals(subTableAlias)) {
                  subTableAlias = subTableAlias.toLowerCase();
               } else {
                  subTableAlias = "";
               }

               this.tableMap.put(subTableAlias, realTable + "." + tableName);
            }

            name = fromContent.getParent().getClass().getName().toLowerCase();
            if (name.contains("SQLSelectQueryBlock".toLowerCase()) && !first) {
               this.parseWhere(((SQLSelectQueryBlock)from.getParent()).getWhere());
               SQLSelectGroupByClause groupBy = ((SQLSelectQueryBlock)from.getParent()).getGroupBy();
               if (groupBy != null && !first) {
                  this.parseHaving(((SQLSelectQueryBlock)from.getParent()).getGroupBy().getHaving());
               }
            } else if (name.contains("SQLJoinTableSource".toLowerCase()) && !first) {
               this.parseWhere(((SQLJoinTableSource)from.getParent()).getCondition());
            }
         } else {
            map.put(tableAlisa, tableName);
         }
      } else if (className.contains("OracleSelectJoin")) {
         OracleSelectJoin fromContent = (OracleSelectJoin)from;
         SQLTableSource left = fromContent.getLeft();
         this.parseFrom(left, map, "", first);
         SQLTableSource right = fromContent.getRight();
         this.parseFrom(right, map, "", first);
         if (fromContent.getCondition() != null && map == null && !first) {
            this.parseWhere(fromContent.getCondition());
         }

         if (from.getParent().getClass().equals(SQLSelectQueryBlock.class)) {
            SQLSelectQueryBlock block = (SQLSelectQueryBlock)from.getParent();
            if (block.getWhere() != null && map == null && !first) {
               this.parseWhere(block.getWhere());
               if (block.getGroupBy() != null && !first) {
                  this.parseHaving(block.getGroupBy().getHaving());
               }
            }
         }
      } else {
         SQLSelect select;
         SQLSelectQueryBlock query;
         OracleSelectQueryBlock subQuery;
         if (className.contains("OracleSelectSubqueryTableSource")) {
            OracleSelectSubqueryTableSource fromContent = (OracleSelectSubqueryTableSource)from;
            select = fromContent.getSelect();
            if (map == null) {
               query = (SQLSelectQueryBlock)select.getQuery();
               this.parseFrom(query.getFrom(), map, fromContent.getAlias(), first);
               sql = this.parseSelectStar(query);
               subQuery = this.aliParseSelect(this.dbType, sql, false);
               this.parseQueryColumns(subQuery, fromContent.getAlias());
               if (!"".equalsIgnoreCase(subTableAlias)) {
                  this.tableMap.put(subTableAlias.toLowerCase(), fromContent.getAlias());
               }

               if (!first) {
                  this.parseWhere(query.getWhere());
               }
            } else {
               map.put(fromContent.getAlias(), fromContent.getAlias());
            }
         } else if (className.contains("SQLUnionQueryTableSource")) {
            SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
            tableName = fromContent.getAlias();
            SQLUnionQuery union = fromContent.getUnion();
            List<SQLSelectQueryBlock> unionList = new ArrayList();
            this.parseUnionFrom(union, unionList);
            this.paresUnionFromSql(unionList, tableName, first);
            if (map == null) {
               this.tableMap.put(tableName.toLowerCase(), tableName);
            } else {
               map.put(tableName, tableName);
            }
         } else if (className.contains("SQLSubqueryTableSource")) {
            SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
            select = fromContent.getSelect();
            if (map == null) {
               query = (SQLSelectQueryBlock)select.getQuery();
               this.parseFrom(query.getFrom(), map, fromContent.getAlias(), first);
               sql = this.parseSelectStar(query);
               subQuery = this.aliParseSelect(this.dbType, sql, false);
               this.parseQueryColumns(subQuery, fromContent.getAlias());
               if (!"".equalsIgnoreCase(subTableAlias)) {
                  this.tableMap.put(subTableAlias.toLowerCase(), fromContent.getAlias());
               }

               if (!first) {
                  this.parseWhere(query.getWhere());
               }
            } else {
               map.put(fromContent.getAlias(), fromContent.getAlias());
            }
         }
      }

      return this.tableMap;
   }

   private void parseHaving(SQLExpr having) throws SQLException {
      this.parseWhere(having);
   }

   public void parseUnionFrom(SQLUnionQuery union, List<SQLSelectQueryBlock> unionList) {
      List<SQLSelectQuery> queryList = union.getRelations();

      for(int i = 0; i < queryList.size(); ++i) {
         SQLSelectQuery selectQuery = (SQLSelectQuery)queryList.get(i);
         String className = selectQuery.getClass().getName();
         if (className.contains("SQLUnionQuery")) {
            SQLUnionQuery unQuery = (SQLUnionQuery)selectQuery;
            this.parseUnionFrom(unQuery, unionList);
         } else {
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
            unionList.add(query);
         }
      }

   }

   public void paresUnionFromSql(List<SQLSelectQueryBlock> unionList, String alias, boolean first) throws SQLException {
      for(int i = 0; i < unionList.size(); ++i) {
         this.unionTableMap.clear();
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)unionList.get(i);
         this.parseFrom(query.getFrom(), (Map)null, "", first);
         String sql = this.parseSelectStar(query);
         if (i == unionList.size() - 1) {
            SQLSelectQueryBlock queryNew6251 = this.aliParseSelect(this.dbType, sql, false);
            this.parseQueryColumns(queryNew6251, alias);
         }
      }

   }

   public String parseSelectStar(SQLSelectQueryBlock query) throws SQLException {
      String sql = query.toString();
      List<SQLSelectItem> fieldList = query.getSelectList();
      Iterator var4 = fieldList.iterator();

      while(true) {
         while(true) {
            while(var4.hasNext()) {
               SQLSelectItem field = (SQLSelectItem)var4.next();
               SQLExpr expr = field.getExpr();
               if (!(expr instanceof SQLAggregateExpr)) {
                  String[] columns = expr.toString().trim().split("\\.");
                  String alias = columns[0];
                  String column = columns.length == 1 ? columns[0] : columns[1];
                  Map<String, String> map = new HashMap();
                  this.parseFrom(query.getFrom(), map, "", true);
                  if ("*".equalsIgnoreCase(column)) {
                     sql = this.columnReplaceStar(sql, alias, map);
                  } else if (columns.length == 1) {
                     List<Column> sqlExprList = new ArrayList();
                     SQLExpr fieldExpr = field.getExpr();
                     this.parseSQLExpr(fieldExpr, fieldExpr, sqlExprList, false);
                     Iterator var13 = sqlExprList.iterator();

                     while(var13.hasNext()) {
                        Column col = (Column)var13.next();
                        this.columnAddTableAlias(col.getExpr(), map);
                     }

                     sql = query.toString();
                  }
               } else if (expr instanceof SQLAggregateExpr) {
                  SQLAggregateExpr aggregateExpr = (SQLAggregateExpr)expr;
                  SQLExpr owner = aggregateExpr.getOwner();
                  SQLObject var9 = aggregateExpr.getParent();
               }
            }

            return sql;
         }
      }
   }

   public void columnAddTableAlias(SQLExpr fieldExpr, Map<String, String> tableMap) throws SQLException {
      String column = fieldExpr.toString();
      if (!"*".equalsIgnoreCase(column)) {
         String url = (String)this.params.get("url");
         String schema = (String)this.params.get("schema");
         String ip_port = getIpPort(url);
         SQLIdentifierExpr expr = (SQLIdentifierExpr)fieldExpr;
         String sql = fieldExpr.toString();
         Iterator var9 = this.tableList.keySet().iterator();

         while(true) {
            String key;
            do {
               if (!var9.hasNext()) {
                  var9 = this.unionTableMap.keySet().iterator();

                  String[] split;
                  String columnName;
                  String schema_temp;
                  String schema_real;
                  List tableColumns;
                  Iterator var21;
                  Column tableColumn;
                  while(var9.hasNext()) {
                     key = (String)var9.next();
                     schema_temp = (String)this.schemaMap.get(this.unionTableMap.get(key));
                     schema_real = schema_temp == null ? schema : schema_temp;
                     tableColumns = JdbcUtil.getTableColumns(ip_port, schema_real, (String)this.unionTableMap.get(key), key, this.tableList);
                     var21 = tableColumns.iterator();

                     while(var21.hasNext()) {
                        tableColumn = (Column)var21.next();
                        split = tableColumn.getColumnName().split("\\.");
                        if (split.length >= 2) {
                           columnName = split[1];
                           if (columnName.equalsIgnoreCase(column.replaceAll("[\"`]", ""))) {
                              sql = sql.replaceAll(column, key + "." + column);
                              expr.setName(sql);
                              return;
                           }
                        }
                     }
                  }

                  var9 = tableMap.keySet().iterator();

                  while(var9.hasNext()) {
                     key = (String)var9.next();
                     schema_temp = (String)this.schemaMap.get(tableMap.get(key));
                     schema_real = schema_temp == null ? schema : schema_temp;
                     tableColumns = JdbcUtil.getTableColumns(ip_port, schema_real, (String)tableMap.get(key), key, this.tableList);
                     var21 = tableColumns.iterator();

                     while(var21.hasNext()) {
                        tableColumn = (Column)var21.next();
                        split = tableColumn.getColumnName().split("\\.");
                        if (split.length >= 2) {
                           columnName = split[1];
                           if (columnName.equalsIgnoreCase(column.replaceAll("[\"`]", ""))) {
                              sql = sql.replaceAll(column, key + "." + column);
                              expr.setName(sql);
                              return;
                           }
                        }
                     }
                  }

                  return;
               }

               key = (String)var9.next();
            } while(!tableMap.containsKey(key));

            List<Column> tableColumns = (List)this.tableList.get(key);
            Iterator var12 = tableColumns.iterator();

            while(var12.hasNext()) {
               Column tableColumn = (Column)var12.next();
               String[] split = tableColumn.getColumnName().split("\\.");
               if (split.length >= 2) {
                  String columnName = split[1];
                  if (columnName.equalsIgnoreCase(column.replaceAll("[\"`]", ""))) {
                     sql = sql.replaceAll(column, key + "." + column);
                     expr.setName(sql);
                     return;
                  }
               }
            }
         }
      }
   }

   public String columnReplaceStar(String sql, String alias, Map<String, String> tableMap) throws SQLException {
      String url = (String)this.params.get("url");
      String schema = (String)this.params.get("schema");
      String ip_port = getIpPort(url);
      List<String> columns = new ArrayList();
      if ("*".equalsIgnoreCase(alias)) {
         Set<String> keys = tableMap.keySet();
         Iterator var9 = keys.iterator();

         while(var9.hasNext()) {
            String key = (String)var9.next();
            String schema_temp = (String)this.schemaMap.get(tableMap.get(key));
            String schema_real = schema_temp == null ? schema : schema_temp;
            List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema_real, (String)tableMap.get(key), key, this.tableList);
            List<String> colList = new ArrayList();

            for(int i = 0; i < tableColumns.size(); ++i) {
               Column col = (Column)tableColumns.get(i);
               String column = "";
               if (col.getColumnAlisa() != null) {
                  column = key + "." + col.getColumnAlisa();
               } else {
                  String[] segs = col.getColumnName().split("\\.");
                  column = key + "." + (segs.length > 1 ? segs[1] : segs[0]);
               }

               colList.add(column);
            }

            columns.addAll(colList);
         }

         if (columns.size() > 0) {
            sql = sql.replaceFirst("\\*", StringJoin.join((Iterable)columns, ","));
         }
      } else if (tableMap.get(alias) != null) {
         String schema_temp = (String)this.schemaMap.get(tableMap.get(alias));
         String schema_real = schema_temp == null ? schema : schema_temp;
         List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema_real, (String)tableMap.get(alias), alias, this.tableList);

         for(int i = 0; i < tableColumns.size(); ++i) {
            Column col = (Column)tableColumns.get(i);
            String column = "";
            if (col.getColumnAlisa() != null) {
               column = alias + "." + col.getColumnAlisa();
            } else {
               column = alias + "." + col.getColumnName().split("\\.")[1];
            }

            columns.add(column);
         }

         if (columns.size() > 0) {
            sql = sql.replaceFirst(alias + "\\.\\*", StringJoin.join((Iterable)columns, ","));
         }
      }

      return sql;
   }

   public void parseQueryColumns(SQLSelectQueryBlock query, String alias) throws SQLException {
      List<SQLSelectItem> fieldList = query.getSelectList();
      boolean isSub = !"".equalsIgnoreCase(alias);
      List<Column> temp = new ArrayList();
      Iterator var6 = fieldList.iterator();

      while(true) {
         while(var6.hasNext()) {
            SQLSelectItem field = (SQLSelectItem)var6.next();
            SQLExpr fileExpr = field.getExpr();
            String className = fileExpr.getClass().toString();
            if (className.contains("SQLQueryExpr")) {
               String subQuery = this.parseSelect(this.dbType, field.getExpr().toString().replaceAll("\\(|\\)", ""));
               SQLSelectStatement stmt = (SQLSelectStatement)SQLUtils.parseStatements(subQuery, (String)this.params.get("dbType")).get(0);
               SQLSelect select = stmt.getSelect();
               SQLQueryExpr sqlQueryExpr = new SQLQueryExpr(select);
               field.setExpr(sqlQueryExpr);
            } else {
               List<Column> sqlExprList = new ArrayList();
               this.parseSQLExpr(fileExpr, fileExpr, sqlExprList, false);

               Column column;
               for(Iterator var11 = sqlExprList.iterator(); var11.hasNext(); temp.add(column)) {
                  Column col_obj = (Column)var11.next();
                  SQLExpr sqlExpr = col_obj.getExpr();
                  String columnName = sqlExpr.toString();
                  column = new Column(columnName, field.getAlias(), isSub, alias);
                  column.setMethod(col_obj.isMethod());
                  column.setFullName(col_obj.getFullName());
                  String[] columns = column.getColumnName().split("\\.");
                  String c1 = columns[0];
                  String c2 = columns.length > 1 ? columns[1] : columns[0];
                  List<Column> list = (List)this.tableList.get(c1);
                  String s;
                  String colName;
                  String realName;
                  String own;
                  if (list != null) {
                     Iterator var20 = list.iterator();

                     label76:
                     while(true) {
                        Column col;
                        do {
                           if (!var20.hasNext()) {
                              break label76;
                           }

                           col = (Column)var20.next();
                           s = col.getColumnName();
                        } while(!JdbcUtil.sqlRegex(s, c2) && !JdbcUtil.sqlRegex(col.getColumnAlisa(), c2));

                        if (!column.getFullName().trim().startsWith("count")) {
                           colName = column.getColumnName();
                           realName = "";
                           own = "";
                           String now = "";
                           if (s.split("\\.").length > 1) {
                              realName = s;
                              own = s.split("\\.")[0];
                              now = s.split("\\.")[0] + "." + colName.split("\\.")[1];
                           } else {
                              realName = s;
                              own = colName.split("\\.")[0];
                              now = colName;
                           }

                           column.setColumnName(realName);
                           column.setNowName(now);
                           column.setSubQuery(true);
                           column.setSubAlisa(c1);
                           String fieldClassName = sqlExpr.getClass().getName();
                           if (fieldClassName.contains("SQLPropertyExpr")) {
                              SQLPropertyExpr expr = (SQLPropertyExpr)sqlExpr;
                              SQLIdentifierExpr owner = (SQLIdentifierExpr)expr.getOwner();
                              owner.setName(own);
                           }
                           break;
                        }
                     }
                  }

                  if (columns.length > 1) {
                     String url = (String)this.params.get("url");
                     String schema = (String)this.params.get("schema");
                     s = (String)this.schemaMap.get(c1);
                     colName = s == null ? schema : s;
                     realName = getIpPort(url);
                     own = JdbcUtil.getColumnDataType(realName, colName, (String)this.tableMap.get(c1), c1, c2);
                     column.setDataType(own);
                  }

                  if (!isSub && !column.getFullName().trim().startsWith("count")) {
                     this.columnList.add(column);
                  }
               }
            }
         }

         if (isSub) {
            this.tableList.put(alias, temp);
         }

         return;
      }
   }

   public void parseSQLExpr(SQLExpr oldFileExpr, SQLExpr fileExpr, List<Column> sqlExprList, boolean isMethod) {
      String className = fileExpr.getClass().toString();
      if (!JdbcUtil.sqlRegex(className, "SQLPropertyExpr|SQLIdentifierExpr")) {
         List items;
         Iterator var8;
         SQLExpr sqlExpr;
         String name;
         if (className.contains("SQLAggregateExpr")) {
            SQLAggregateExpr expr = (SQLAggregateExpr)fileExpr;
            items = expr.getArguments();
            var8 = items.iterator();

            while(var8.hasNext()) {
               sqlExpr = (SQLExpr)var8.next();
               name = sqlExpr.getClass().getName();
               if (!name.contains("SQLCharExpr")) {
                  this.parseSQLExpr(oldFileExpr, sqlExpr, sqlExprList, true);
               }
            }
         } else if (className.contains("SQLMethodInvokeExpr")) {
            SQLMethodInvokeExpr expr = (SQLMethodInvokeExpr)fileExpr;
            items = expr.getArguments();
            var8 = items.iterator();

            while(var8.hasNext()) {
               sqlExpr = (SQLExpr)var8.next();
               name = sqlExpr.getClass().getName();
               if (!name.contains("SQLCharExpr")) {
                  this.parseSQLExpr(oldFileExpr, sqlExpr, sqlExprList, true);
               }
            }
         } else if (className.contains("SQLBinaryOpExpr")) {
            SQLBinaryOpExpr expr = (SQLBinaryOpExpr)fileExpr;
            SQLExpr left = expr.getLeft();
            SQLExpr right = expr.getRight();
            this.parseSQLExpr(oldFileExpr, left, sqlExprList, true);
            this.parseSQLExpr(oldFileExpr, right, sqlExprList, true);
         } else if (className.contains("SQLCaseExpr")) {
            SQLCaseExpr expr = (SQLCaseExpr)fileExpr;
            items = expr.getItems();
            var8 = items.iterator();

            while(var8.hasNext()) {
               SQLCaseExpr.Item item = (SQLCaseExpr.Item)var8.next();
               this.parseSQLExpr(oldFileExpr, item.getConditionExpr(), sqlExprList, true);
            }
         } else if (className.contains("SQLBetweenExpr")) {
            SQLBetweenExpr expr = (SQLBetweenExpr)fileExpr;
            this.parseSQLExpr(oldFileExpr, expr.getTestExpr(), sqlExprList, true);
         }
      } else {
         Column column = new Column(isMethod, fileExpr);
         column.setFullName(oldFileExpr.toString());
         sqlExprList.add(column);
      }

   }

   public SQLInsertStatement parseInsert(String dbType, String sql) throws SQLException {
      SQLInsertStatement insert = this.aliParseInsert(dbType, sql);
      this.parseInsertColumns(insert);
      return insert;
   }

   public SQLInsertStatement aliParseInsert(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLInsertStatement stmt = (SQLInsertStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseInsertColumns(SQLInsertStatement insert) throws SQLException {
      String url = (String)this.params.get("url");
      String schema = (String)this.params.get("schema");
      String tableName = insert.getTableName().getSimpleName();
      String className = insert.getTableName().getClass().getName();
      if (className.contains("SQLIdentifierExpr")) {
         SQLPropertyExpr expr = new SQLPropertyExpr();
         expr.setName(tableName);
         expr.setOwner(schema);
         insert.setTableName(expr);
      }

      List<SQLExpr> columns = insert.getColumns();
      String dbType;
      Column col;
      String parseSql;
      if (columns.size() == 0) {
         String ip_port = getIpPort(url);
         dbType = (String)this.schemaMap.get(tableName);
         String schema_real = dbType == null ? schema : dbType;
         List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema_real, tableName, "", this.tableList);
         Iterator var11 = tableColumns.iterator();

         while(var11.hasNext()) {
            Column tableColumn = (Column)var11.next();
            SQLIdentifierExpr sqlIdentifierExpr = new SQLIdentifierExpr();
            sqlIdentifierExpr.setName(tableColumn.getColumnName());
            columns.add(sqlIdentifierExpr);
            Column column = new Column();
            column.setColumnName(tableName + "." + tableColumn.getColumnName());
            this.columnList.add(column);
         }
      } else {
         for(Iterator var16 = columns.iterator(); var16.hasNext(); this.columnList.add(col)) {
            SQLExpr column = (SQLExpr)var16.next();
            col = new Column();
            parseSql = column.getClass().getName();
            String colname = "";
            if (parseSql.contains("SQLIdentifierExpr")) {
               col.setColumnName(tableName + "." + column.toString());
            } else {
               col.setColumnName(column.toString());
            }
         }
      }

      this.tableMap.put(tableName, tableName);
      List<SQLInsertStatement.ValuesClause> valuesList = insert.getValuesList();
      if (valuesList.size() == 0) {
         dbType = (String)this.params.get("dbType");
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)insert.getQuery().getQuery();
         parseSql = this.parseSelect(dbType, query.toString());
         SQLSelectQueryBlock sqlSelectQueryBlock = this.aliParseSelect(dbType, parseSql, true);
         insert.getQuery().setQuery(sqlSelectQueryBlock);
      }

      this.schemaMap.put(tableName, schema);
   }

   public SQLUpdateStatement parseUpdate(String dbType, String sql) throws SQLException {
      SQLUpdateStatement update = this.aliParseUpdate(dbType, sql);
      this.parseUpdateColumns(update);
      return update;
   }

   public SQLUpdateStatement aliParseUpdate(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLUpdateStatement stmt = (SQLUpdateStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseUpdateColumns(SQLUpdateStatement update) throws SQLException {
      String tableName = update.getTableName().getSimpleName();
      SQLExprTableSource tableExpr = (SQLExprTableSource)update.getTableSource();
      SQLExpr expr1 = tableExpr.getExpr();
      String schema = (String)this.params.get("schema");
      if (expr1 instanceof SQLIdentifierExpr) {
         SQLPropertyExpr expr = new SQLPropertyExpr();
         expr.setName(tableName);
         expr.setOwner(schema);
         tableExpr.setExpr((SQLExpr)expr);
      } else if (expr1 instanceof SQLPropertyExpr) {
         schema = ((SQLPropertyExpr)expr1).getOwnerName();
      }

      this.schemaMap.put(tableName, schema);
      String alias = update.getTableSource().getAlias();
      String name = alias == null ? tableName : alias;
      List<SQLUpdateSetItem> items = update.getItems();
      Iterator var9 = items.iterator();

      while(var9.hasNext()) {
         SQLUpdateSetItem item = (SQLUpdateSetItem)var9.next();
         String className = item.getColumn().getClass().getName();
         String colName = "";
         String colValue = "";
         if (className.contains("SQLPropertyExpr")) {
            SQLPropertyExpr column = (SQLPropertyExpr)item.getColumn();
            colName = column.getName();
            colValue = ((SQLUpdateSetItem)column.getParent()).getValue().toString();
         } else if (className.contains("SQLIdentifierExpr")) {
            SQLIdentifierExpr column = (SQLIdentifierExpr)item.getColumn();
            colName = column.getName();
            colValue = ((SQLUpdateSetItem)column.getParent()).getValue().toString();
         }

         Column col = new Column();
         col.setColumnName(name + "." + colName);
         col.setValue(colValue);
         this.columnList.add(col);
      }

      this.tableMap.put(name, tableName);
      this.parseWhere(update.getWhere());
   }

   public SQLDeleteStatement parseDelete(String dbType, String sql) throws SQLException {
      SQLDeleteStatement delete = this.aliParseDelete(dbType, sql);
      this.parseDeleteColumns(delete);
      return delete;
   }

   public SQLDeleteStatement aliParseDelete(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLDeleteStatement stmt = (SQLDeleteStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseDeleteColumns(SQLDeleteStatement delete) throws SQLException {
      String schema = (String)this.params.get("schema");
      String url = (String)this.params.get("url");
      String ip_port = getIpPort(url);
      String tableName = delete.getTableName().getSimpleName();
      SQLExprTableSource tableExpr = (SQLExprTableSource)delete.getTableSource();
      SQLExpr expr1 = tableExpr.getExpr();
      if (expr1 instanceof SQLIdentifierExpr) {
         SQLPropertyExpr expr = new SQLPropertyExpr();
         expr.setName(tableName);
         expr.setOwner(schema);
         tableExpr.setExpr((SQLExpr)expr);
      } else if (expr1 instanceof SQLPropertyExpr) {
         schema = ((SQLPropertyExpr)expr1).getOwnerName();
      }

      List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema, tableName, tableName, this.tableList);
      Iterator var9 = tableColumns.iterator();

      while(var9.hasNext()) {
         Column tableColumn = (Column)var9.next();
         Column column = new Column();
         this.tableMap.put(tableColumn.getTable(), tableColumn.getTable());
         this.schemaMap.put(tableColumn.getTable(), tableColumn.getSchema());
         column.setSchema(tableColumn.getSchema());
         column.setTable(tableColumn.getTable());
         column.setColumnName(tableColumn.getColumnName());
         this.columnList.add(column);
      }

      this.parseWhere(delete.getWhere());
   }

   public SQLTruncateStatement parseTruncate(String dbType, String sql) throws SQLException {
      SQLTruncateStatement truncate = this.aliParseTruncate(dbType, sql);
      this.parseTruncateColumns(truncate);
      return truncate;
   }

   public SQLTruncateStatement aliParseTruncate(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLTruncateStatement stmt = (SQLTruncateStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseTruncateColumns(SQLTruncateStatement truncate) {
      List<SQLExprTableSource> tableList = truncate.getTableSources();
      Iterator var3 = tableList.iterator();

      while(var3.hasNext()) {
         SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)var3.next();
         String tableName = sqlExprTableSource.getName().getSimpleName();
         this.tableMap.put(tableName, tableName);
      }

   }

   public SQLCreateStatement parseCreate(String dbType, String sql) throws SQLException {
      SQLCreateStatement create = this.aliParseCreate(dbType, sql);
      this.parseCreateColumns(create);
      return create;
   }

   public SQLCreateStatement aliParseCreate(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLCreateStatement stmt = (SQLCreateStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseCreateColumns(SQLCreateStatement create) throws SQLException {
      String schema = (String)this.params.get("schema");
      String name = create.getClass().getName();
      String tableName = "";
      String simpleName;
      if (name.contains("OracleCreateTableStatement")) {
         OracleCreateTableStatement createTable = (OracleCreateTableStatement)create;
         tableName = createTable.getTableName();
         simpleName = createTable.getTableSource().getName().getClass().getName();
         if (simpleName.contains("SQLIdentifierExpr")) {
            SQLPropertyExpr expr = new SQLPropertyExpr();
            expr.setName(tableName);
            expr.setOwner(schema);
            createTable.getTableSource().setExpr((SQLExpr)expr);
         }

         List<SQLTableElement> tableElementList = createTable.getTableElementList();
         if (tableElementList.size() == 0) {
            SQLSelect subQuery = createTable.getSelect();
            this.params.put("sql", subQuery.toString());
            HashMap<String, Object> map = new HashMap();
            this.parseSqlStructure(map);
            OracleSelectQueryBlock queryBlock = this.aliParseSelect(this.dbType, map.get("sql").toString(), true);
            subQuery.setQuery(queryBlock);
         } else {
            Iterator var8 = tableElementList.iterator();

            while(var8.hasNext()) {
               SQLTableElement sqlTableElement = (SQLTableElement)var8.next();
               String className = sqlTableElement.getClass().getName();
               if (className.contains("SQLColumnDefinition")) {
                  SQLColumnDefinition col = (SQLColumnDefinition)sqlTableElement;
                  String columnName = col.getColumnName();
                  Column column = new Column();
                  column.setColumnName(tableName + "." + columnName);
                  this.columnList.add(column);
               }
            }
         }

         this.tableMap.put(tableName, tableName);
      } else if (name.contains("SQLCreateViewStatement")) {
         SQLCreateViewStatement createView = (SQLCreateViewStatement)create;
         simpleName = createView.getName().getSimpleName();
         SQLSelect subQuery = createView.getSubQuery();
         this.params.put("sql", subQuery.toString());
         this.parseSqlStructure(new HashMap());
         this.tableMap.put(simpleName, simpleName);
      }

      this.schemaMap.put(tableName, schema);
   }

   public SQLAlterTableStatement parseAlter(String dbType, String sql) throws SQLException {
      SQLAlterTableStatement alter = this.aliParseAlter(dbType, sql);
      this.parseAlterColumns(alter);
      return alter;
   }

   public SQLAlterTableStatement aliParseAlter(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLAlterTableStatement stmt = (SQLAlterTableStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseAlterColumns(SQLAlterTableStatement alter) {
      String tableName = alter.getTableName();
      List<SQLAlterTableItem> items = alter.getItems();
      Iterator var4 = items.iterator();

      while(true) {
         while(var4.hasNext()) {
            SQLAlterTableItem item = (SQLAlterTableItem)var4.next();
            String className = item.getClass().getName();
            List columns;
            Iterator var9;
            String columnName;
            Column col;
            if (className.contains("SQLAlterTableAddColumn")) {
               SQLAlterTableAddColumn alterColumn = (SQLAlterTableAddColumn)item;
               columns = alterColumn.getColumns();
               var9 = columns.iterator();

               while(var9.hasNext()) {
                  SQLColumnDefinition column = (SQLColumnDefinition)var9.next();
                  columnName = column.getColumnName();
                  col = new Column();
                  col.setColumnName(tableName + "." + columnName);
                  this.columnList.add(col);
               }
            } else if (className.contains("SQLAlterTableDropColumnItem")) {
               SQLAlterTableDropColumnItem alterColumn = (SQLAlterTableDropColumnItem)item;
               columns = alterColumn.getColumns();
               var9 = columns.iterator();

               while(var9.hasNext()) {
                  SQLName column = (SQLName)var9.next();
                  columnName = column.getSimpleName();
                  col = new Column();
                  col.setColumnName(tableName + "." + columnName);
                  this.columnList.add(col);
               }
            }
         }

         this.tableMap.put(tableName, tableName);
         return;
      }
   }

   public String parseWithSelect(String dbType, String sql) throws SQLException {
      String result = "";
      Map<String, String> map = this.aliParseWithSelect(dbType, sql);
      String normal = (String)map.get("normal");
      String with = (String)map.get("with");
      String withSelect = JdbcUtil.sqlSplit(with);
      String sqlType = JdbcUtil.getSqlType(withSelect, dbType);
      if ("select".equals(sqlType)) {
         this.withSql = this.parseSelect(dbType, withSelect);
      } else if ("union".equals(sqlType)) {
         this.withSql = this.parseUnion(dbType, withSelect);
         List<SQLStatement> stmtList = SQLUtils.parseStatements(this.withSql, dbType);
         SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
         SQLSelect select = stmt.getSelect();
         SQLUnionQuery union = (SQLUnionQuery)select.getQuery();
         String withAlias = JdbcUtil.getWithTableName(with);
         List<SQLSelectQueryBlock> unionList = new ArrayList();
         this.parseUnionFrom(union, unionList);
         this.paresUnionFromSql(unionList, withAlias, true);
      }

      String normalSql = this.parseSelect(dbType, normal);
      result = result + with.replaceAll(withSelect.replaceAll("\t", ""), this.withSql);
      result = result + " " + normalSql;
      return result;
   }

   public Map<String, String> aliParseWithSelect(String dbType, String sql) throws SQLException {
      Map<String, String> result = new HashMap();
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
         SQLSelect select = stmt.getSelect();
         SQLSelectQueryBlock query_1 = (SQLSelectQueryBlock)select.getQuery();
         String sql_2 = select.toString().replace(query_1.toString(), "");
         result.put("with", sql_2.replaceAll("\t", ""));
         result.put("normal", query_1.toString());
         return result;
      }
   }

   public String parseUnion(String dbType, String sql) throws SQLException {
      StringBuilder result = new StringBuilder();
      SQLUnionQuery query = this.aliParseUnion(dbType, sql);
      this.dealUnion(query, result);
      return result.toString();
   }

   public SQLUnionQuery aliParseUnion(String dbType, String sql) throws SQLException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
         SQLSelect select = stmt.getSelect();
         SQLUnionQuery query = (SQLUnionQuery)select.getQuery();
         return query;
      }
   }

   public void dealUnion(SQLUnionQuery unionQuery, StringBuilder result) throws SQLException {
      List<SQLSelectQuery> queryList = unionQuery.getRelations();

      for(int i = 0; i < queryList.size(); ++i) {
         SQLSelectQuery selectQuery = (SQLSelectQuery)queryList.get(i);
         String sql = "";
         String className = selectQuery.getClass().getName();
         if (className.contains("SQLUnionQuery")) {
            SQLUnionQuery unQuery = (SQLUnionQuery)selectQuery;
            this.dealUnion(unQuery, result);
         } else {
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
            this.parseFrom(query.getFrom(), (Map)null, "", true);
            this.parseFrom(query.getFrom(), (Map)null, "", false);
            sql = this.parseSelectStar(query);
            SQLSelectQueryBlock queryNew6146 = this.aliParseSelect(this.dbType, sql, true);
            this.parseQueryColumns(queryNew6146, "");
            sql = this.parseSelectStar(queryNew6146);
            result.append(sql);
         }

         if (i == 0) {
            result.append("\n" + unionQuery.getOperator().toString() + "\n");
         }
      }

   }

   public SQLDropTableStatement parseDrop(String dbType, String sql) throws SQLException {
      SQLDropTableStatement drop = this.aliParseDrop(dbType, sql);
      this.parseDropColumns(drop);
      return drop;
   }

   public SQLDropTableStatement aliParseDrop(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLDropTableStatement stmt = (SQLDropTableStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseDropColumns(SQLDropTableStatement drop) {
      List<SQLExprTableSource> tableSources = drop.getTableSources();
      Iterator var3 = tableSources.iterator();

      while(var3.hasNext()) {
         SQLExprTableSource tableSource = (SQLExprTableSource)var3.next();
         String tableName = tableSource.getName().getSimpleName();
         this.tableMap.put(tableName, tableName);
      }

   }

   public SQLGrantStatement parseGrant(String dbType, String sql) throws SQLException {
      SQLGrantStatement grant = this.aliParseGrant(dbType, sql);
      this.parseGrantColumns(grant);
      return grant;
   }

   public SQLGrantStatement aliParseGrant(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLGrantStatement stmt = (SQLGrantStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseGrantColumns(SQLGrantStatement grant) {
      String url = (String)this.params.get("url");
      String ip_port = getIpPort(url);
      SQLExprTableSource resource = (SQLExprTableSource)grant.getResource();
      SQLPropertyExpr expr = (SQLPropertyExpr)resource.getExpr();
      String name = expr.getName();
      String owner = expr.getOwner().toString();
      Iterator var8;
      DataBase dataBase;
      List schemaList;
      Iterator var11;
      Schema schema;
      List tableList;
      Iterator var14;
      Table table;
      if ("*".equalsIgnoreCase(owner)) {
         var8 = JdbcUtil.dataBaseList.iterator();

         while(true) {
            do {
               if (!var8.hasNext()) {
                  return;
               }

               dataBase = (DataBase)var8.next();
            } while(!dataBase.getIp_port().equalsIgnoreCase(ip_port));

            schemaList = dataBase.getSchemaList();
            var11 = schemaList.iterator();

            while(var11.hasNext()) {
               schema = (Schema)var11.next();
               tableList = schema.getTableList();
               var14 = tableList.iterator();

               while(var14.hasNext()) {
                  table = (Table)var14.next();
                  this.schemaMap.put(table.getName(), schema.getName());
                  this.tableMap.put(table.getName(), table.getName());
               }
            }
         }
      } else if ("*".equalsIgnoreCase(name)) {
         var8 = JdbcUtil.dataBaseList.iterator();

         label55:
         while(true) {
            do {
               if (!var8.hasNext()) {
                  return;
               }

               dataBase = (DataBase)var8.next();
            } while(!dataBase.getIp_port().equalsIgnoreCase(ip_port));

            schemaList = dataBase.getSchemaList();
            var11 = schemaList.iterator();

            while(true) {
               do {
                  if (!var11.hasNext()) {
                     continue label55;
                  }

                  schema = (Schema)var11.next();
               } while(!schema.getName().equalsIgnoreCase(owner));

               tableList = schema.getTableList();
               var14 = tableList.iterator();

               while(var14.hasNext()) {
                  table = (Table)var14.next();
                  this.schemaMap.put(table.getName(), owner);
                  this.tableMap.put(table.getName(), table.getName());
               }
            }
         }
      } else {
         this.schemaMap.put(name, owner);
         this.tableMap.put(name, name);
      }
   }

   public SQLRevokeStatement parseRevoke(String dbType, String sql) throws SQLException {
      SQLRevokeStatement revoke = this.aliParseRevoke(dbType, sql);
      this.parseRevokeColumns(revoke);
      return revoke;
   }

   public SQLMergeStatement parseMerge(String dbType, String sql) throws SQLException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLMergeStatement stmt = (SQLMergeStatement)stmtList.get(0);
         return stmt;
      }
   }

   public SQLRevokeStatement aliParseRevoke(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLRevokeStatement stmt = (SQLRevokeStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseRevokeColumns(SQLRevokeStatement revoke) {
      String url = (String)this.params.get("url");
      String ip_port = getIpPort(url);
      SQLExprTableSource resource = (SQLExprTableSource)revoke.getResource();
      SQLPropertyExpr expr = (SQLPropertyExpr)resource.getExpr();
      String name = expr.getName();
      String owner = expr.getOwner().toString();
      Iterator var8;
      DataBase dataBase;
      List schemaList;
      Iterator var11;
      Schema schema;
      List tableList;
      Iterator var14;
      Table table;
      if ("*".equalsIgnoreCase(owner)) {
         var8 = JdbcUtil.dataBaseList.iterator();

         while(true) {
            do {
               if (!var8.hasNext()) {
                  return;
               }

               dataBase = (DataBase)var8.next();
            } while(!dataBase.getIp_port().equalsIgnoreCase(ip_port));

            schemaList = dataBase.getSchemaList();
            var11 = schemaList.iterator();

            while(var11.hasNext()) {
               schema = (Schema)var11.next();
               tableList = schema.getTableList();
               var14 = tableList.iterator();

               while(var14.hasNext()) {
                  table = (Table)var14.next();
                  this.schemaMap.put(table.getName(), schema.getName());
                  this.tableMap.put(table.getName(), table.getName());
               }
            }
         }
      } else if ("*".equalsIgnoreCase(name)) {
         var8 = JdbcUtil.dataBaseList.iterator();

         label55:
         while(true) {
            do {
               if (!var8.hasNext()) {
                  return;
               }

               dataBase = (DataBase)var8.next();
            } while(!dataBase.getIp_port().equalsIgnoreCase(ip_port));

            schemaList = dataBase.getSchemaList();
            var11 = schemaList.iterator();

            while(true) {
               do {
                  if (!var11.hasNext()) {
                     continue label55;
                  }

                  schema = (Schema)var11.next();
               } while(!schema.getName().equalsIgnoreCase(owner));

               tableList = schema.getTableList();
               var14 = tableList.iterator();

               while(var14.hasNext()) {
                  table = (Table)var14.next();
                  this.schemaMap.put(table.getName(), owner);
                  this.tableMap.put(table.getName(), table.getName());
               }
            }
         }
      } else {
         this.schemaMap.put(name, owner);
         this.tableMap.put(name, name);
      }
   }

   public List<String> parseWheres(String sql) {
      SQLParser parser = new SQLParser();
      return parser.where(sql);
   }

   public String formatSQL(String sql) {
      SQLParser parser = new SQLParser();
      return parser.format(sql);
   }

   public void parseSqlStructureXY(Map<String, Object> paramMap) throws SQLException {
      System.out.println("传入的参数：=========================================>" + this.params);
      String sql = (String)this.params.get("sql");
      List<SQLStatement> statements = SQLUtils.parseStatements(sql, "oracle");
      if (statements != null && statements.size() != 0) {
         String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
         if (!"insert_select".equals(sqlType) && !"select".equals(sqlType) && !"union".equals(sqlType) && !"merge".equals(sqlType)) {
            if ("truncate".equals(sqlType)) {
               SQLTruncateStatement truncate = this.parseTruncate(this.dbType, sql);
               paramMap.put("type", "truncate");
               paramMap.put("statement", truncate);
               paramMap.put("sql", truncate.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("create".equals(sqlType)) {
               SQLCreateStatement create = this.parseCreate(this.dbType, sql);
               paramMap.put("type", "create");
               paramMap.put("statement", create);
               paramMap.put("sql", create.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("alter".equals(sqlType)) {
               SQLAlterTableStatement alter = this.parseAlter(this.dbType, sql);
               paramMap.put("type", "alter");
               paramMap.put("statement", alter);
               paramMap.put("sql", alter.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("with_select".equals(sqlType)) {
               String parseSql = this.parseWithSelect(this.dbType, sql);
               paramMap.put("type", "with_select");
               paramMap.put("sql", parseSql);
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("drop".equals(sqlType)) {
               SQLDropTableStatement drop = this.parseDrop(this.dbType, sql);
               paramMap.put("type", "drop");
               paramMap.put("statement", drop);
               paramMap.put("sql", drop.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("grant".equals(sqlType)) {
               SQLGrantStatement grant = this.parseGrant(this.dbType, sql);
               paramMap.put("type", "grant");
               paramMap.put("statement", grant);
               paramMap.put("sql", grant.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            } else if ("revoke".equals(sqlType)) {
               SQLRevokeStatement revoke = this.parseRevoke(this.dbType, sql);
               paramMap.put("type", "revoke");
               paramMap.put("statement", revoke);
               paramMap.put("sql", revoke.toString());
               paramMap.put("whereList", this.flatWhereListValues());
            }
         } else {
            String url = (String)this.params.get("url");
            String schema = (String)this.params.get("schema");
            String ip_port = getIpPort(url);
            SQLParser sqlParser = new SQLParser();
            DataBase dataBase = new DataBase();
            Iterator var11 = JdbcUtil.dataBaseList.iterator();

            while(var11.hasNext()) {
               DataBase db = (DataBase)var11.next();
               if (ip_port.equalsIgnoreCase(db.getIp_port())) {
                  dataBase = db;
                  break;
               }
            }

            SQLResult parse = sqlParser.parse(sql, dataBase, schema);
            List<FieldInfo> columnlist = parse.outputs;
            OracleNameWrapper wrapper = new OracleNameWrapper(dataBase.simpleCache);
            Set<String> tabSet = new HashSet();
            Iterator var15 = columnlist.iterator();

            label158:
            while(true) {
               FieldInfo fieldInfo;
               Column raw;
               do {
                  do {
                     do {
                        if (!var15.hasNext()) {
                           var15 = parse.tables.iterator();

                           while(var15.hasNext()) {
                              TableInfo table = (TableInfo)var15.next();
                              TableMemo tb = table.getTable();
                              String schName = wrapper.unwrapSchema(tb.schema);
                              String tbName = wrapper.unwrapTable(schName, tb.name);
                              if (tabSet.contains(tbName)) {
                                 this.tableMap.put(tbName, tbName);
                                 this.schemaMap.put(tbName, schName);
                              }
                           }

                           paramMap.put("whereList", this.whereList);
                           paramMap.put("statement", parse.statement);
                           paramMap.put("type", parse.sqlType.name().toLowerCase());
                           paramMap.put("sql", parse.statement.toString());
                           wrapper.unwrapFullColumns(this.columnList);
                           var15 = this.columnList.iterator();

                           while(var15.hasNext()) {
                              Column column = (Column)var15.next();
                              wrapper.unwrapFullColumns(column.columns);
                           }
                           break label158;
                        }

                        fieldInfo = (FieldInfo)var15.next();
                        raw = new Column();
                        raw.setColumnName(fieldInfo.getName());
                        raw.setColumnAlisa(fieldInfo.getAlias());
                        raw.setSubQuery(false);
                        this.columnList.add(raw);
                     } while(fieldInfo.getAlias().equalsIgnoreCase("ROWID"));
                  } while(fieldInfo.getAlias().equalsIgnoreCase("ORA_ROWSCN"));
               } while(fieldInfo.getMemo() != null && fieldInfo.getMemo().isConstant);

               List<FieldInfo> fieldInfoList = new ArrayList();
               if (fieldInfo.getRelations().size() > 0) {
                  fieldInfoList = fieldInfo.getRelations();
               } else {
                  ((List)fieldInfoList).add(fieldInfo);
               }

               Iterator var19 = ((List)fieldInfoList).iterator();

               while(true) {
                  FieldInfo info;
                  String name;
                  do {
                     if (!var19.hasNext()) {
                        continue label158;
                     }

                     info = (FieldInfo)var19.next();
                     name = info.getName();
                  } while(StringUtils.isEmpty(name));

                  Map<String, TableInfo> tables = info.getTables();
                  String tableName = "";
                  String schemaName = "";
                  Iterator var25 = tables.keySet().iterator();

                  while(var25.hasNext()) {
                     String s = (String)var25.next();
                     String[] segment = s.split("\\.");
                     if (!StringUtils.isEmpty(segment[0]) && !StringUtils.isEmpty(segment[1])) {
                        schemaName = segment[0];
                        tableName = segment[1];
                        break;
                     }
                  }

                  if (tableName.length() == 0 && info.getTables().size() > 0) {
                     var25 = info.getTables().entrySet().iterator();

                     while(var25.hasNext()) {
                        Map.Entry<String, TableInfo> entry = (Map.Entry)var25.next();
                        TableInfo tbInfo = (TableInfo)entry.getValue();
                        if (tbInfo != null && tbInfo.getTable() != null && !StringUtils.isEmpty(tbInfo.getTable().schema) && !StringUtils.isEmpty(tbInfo.getTable().name)) {
                           tableName = tbInfo.getTable().name;
                           schemaName = tbInfo.getTable().schema;
                           break;
                        }
                     }
                  }

                  schemaName = wrapper.unwrapSchema(schemaName);
                  tableName = wrapper.unwrapTable(schemaName, tableName);
                  tabSet.add(tableName);
                  Column column = new Column();
                  column.setColumnName(tableName + "." + name);
                  column.setTable(tableName);
                  column.setSchema(schemaName);
                  column.setColumnAlisa(info.getAlias() != null && !"".equals(info.getAlias()) ? info.getAlias().replaceAll("\"", "") : "");
                  column.setSubQuery(false);
                  raw.columns.add(column);
                  if (!name.equalsIgnoreCase("ROWID") && name.equalsIgnoreCase("ORA_ROWSCN")) {
                  }
               }
            }
         }

         paramMap.put("tableMap", this.tableMap);
         paramMap.put("columnList", this.columnList);
         paramMap.put("schemaMap", this.schemaMap);
         paramMap.put("whereMap", this.whereMap);
      }
   }

   public Scope getScope(String ip_port, String schema, List<SQLStatement> statements) {
      Context context = new Context();
      DataBase dataBase = new DataBase();
      Iterator var6 = JdbcUtil.dataBaseList.iterator();

      while(var6.hasNext()) {
         DataBase db = (DataBase)var6.next();
         if (ip_port.equalsIgnoreCase(db.getIp_port())) {
            dataBase = db;
            break;
         }
      }

      context.initialize(dataBase, schema, this.dbType);
      Scope scope = new Scope();
      scope.dialector = new OracleScopeDialector(scope);
      scope.context = context;
      scope.isCheckIsolated = true;
      ScopeVisitor scopeVisitor = new ScopeVisitor(scope);
      scopeVisitor.perform(statements);
      FieldVisitor fieldVisitor = new FieldVisitor(scope);
      fieldVisitor.perform(statements);
      return scope;
   }
}
