package util.sqlparse;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLLimit;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.expr.SQLAggregateExpr;
import com.chenyang.druid.sql.ast.expr.SQLBetweenExpr;
import com.chenyang.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.chenyang.druid.sql.ast.expr.SQLBinaryOperator;
import com.chenyang.druid.sql.ast.expr.SQLCaseExpr;
import com.chenyang.druid.sql.ast.expr.SQLCharExpr;
import com.chenyang.druid.sql.ast.expr.SQLExistsExpr;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLInListExpr;
import com.chenyang.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.chenyang.druid.sql.ast.expr.SQLIntegerExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.ast.expr.SQLPropertyExpr;
import com.chenyang.druid.sql.ast.expr.SQLQueryExpr;
import com.chenyang.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.chenyang.druid.sql.ast.expr.SQLVariantRefExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLColumnDefinition;
import com.chenyang.druid.sql.ast.statement.SQLCreateStatement;
import com.chenyang.druid.sql.ast.statement.SQLCreateTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLCreateViewStatement;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLDropTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLGrantStatement;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLJoinTableSource;
import com.chenyang.druid.sql.ast.statement.SQLRevokeStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.chenyang.druid.sql.ast.statement.SQLSelectItem;
import com.chenyang.druid.sql.ast.statement.SQLSelectQuery;
import com.chenyang.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.chenyang.druid.sql.ast.statement.SQLSelectStatement;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLTableElement;
import com.chenyang.druid.sql.ast.statement.SQLTableSource;
import com.chenyang.druid.sql.ast.statement.SQLTruncateStatement;
import com.chenyang.druid.sql.ast.statement.SQLUnionQuery;
import com.chenyang.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUpdateSetItem;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGAlterSchemaStatement;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGAlterViewStatement;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGDropSchemaStatement;
import com.chenyang.druid.util.StringUtils;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import util.JdbcUtil;
import util.StringJoin;
import util.getdata.DatabaseCache;
import util.sqlparse.visitor.common.Context;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.postgresql.PostgresqlNameWrapper;
import util.sqlparse.visitor.postgresql.SQLParser;
import util.sqlparse.visitor.postgresql.visitor.Desensitization;
import util.sqlparse.visitor.postgresql.visitor.FieldVisitor;
import util.sqlparse.visitor.postgresql.visitor.PostgresqlScopeDialector;
import util.sqlparse.visitor.postgresql.visitor.ScopeVisitor;

public class PostgreSqlParse {
   public HashMap<String, List<Column>> tableList = new HashMap();
   public List<Column> columnList = new ArrayList();
   public Map<String, Object> whereMap = new HashMap();
   public List<Map<String, Object>> whereValueList = new ArrayList();
   private List<SQLObject> parsedCache = new ArrayList();
   private List<SQLExpr> parsedWhereExprs = new ArrayList();
   public Map<String, String> tableMap = new HashMap();
   public Map<String, String> unionTableMap = new HashMap();
   public Map<String, String> schemaMap = new HashMap();
   public Map<String, String> params;
   public List<Map<String, Object>> whereList = new ArrayList();
   public String dbType = "postgresql";

   public static String getIpPort(String url) {
      String[] urlSplit = url.split("/");
      String ip_port = urlSplit[2];
      return ip_port;
   }

   public PostgreSqlParse(Map<String, String> params) {
      this.params = params;
   }

   public PostgreSqlParse() {
   }

   public String rowVisitControl(Map<String, Object> param) throws SQLException {
      Desensitization desensitization = new Desensitization();
      Map map = desensitization.parseRowVisit(param);
      return (String)map.get("newSql");
   }

   public String addWhereCondition(Map<String, Object> param) throws SQLException {
      String sql = (String)param.get("sql");
      String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
      if ("select".equals(sqlType)) {
         SQLSelectQueryBlock query = this.aliParseSelect(this.dbType, sql, false);
         this.parseFromAndAddWhereCondition(query.getFrom(), param);
         sql = query.toString();
      } else if ("update".equals(sqlType)) {
         SQLUpdateStatement update = this.aliParseUpdate(this.dbType, sql);
         this.parseUpdateAndAddWhereCondition(update, param);
         sql = update.toString();
      } else if ("delete".equals(sqlType)) {
         SQLDeleteStatement delete = this.aliParseDelete(this.dbType, sql);
         this.parseDeleteAndAddWhereCondition(delete, param);
         sql = delete.toString();
      }

      return sql;
   }

   public void parseFromAndAddWhereCondition(SQLTableSource from, Map<String, Object> param) {
      if (from instanceof SQLExprTableSource) {
         Map<String, List<String>> modifyTable = (Map)param.get("modifyTable");
         Map<String, String> tableKeyWord = (Map)param.get("tableKeyWord");
         SQLExprTableSource fromContent = (SQLExprTableSource)from;
         String[] split = fromContent.getExpr().toString().split("\\.");
         String tableName = "";
         if (split.length > 1) {
            tableName = split[1];
         } else {
            tableName = split[0];
         }

         tableName = tableName.replaceAll("`", "");
         String tableAlisa = fromContent.getAlias();
         tableAlisa = tableAlisa == null ? tableName : tableAlisa;

         SQLObject parent;
         for(parent = fromContent.getParent(); !(parent instanceof SQLSelectQueryBlock) && !(parent instanceof SQLDeleteStatement); parent = parent.getParent()) {
         }

         Iterator i$;
         String key;
         String id;
         String condition;
         if (parent instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock p = (SQLSelectQueryBlock)parent;
            i$ = modifyTable.keySet().iterator();

            while(i$.hasNext()) {
               key = (String)i$.next();
               if (key.equalsIgnoreCase(tableName)) {
                  id = (String)tableKeyWord.get(tableName);
                  condition = "(" + tableAlisa + "." + id + " not in ('";
                  condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
                  condition = condition + " or " + tableAlisa + "." + id + " is null)";
                  p.addCondition(condition);
               }
            }
         } else if (parent instanceof SQLDeleteStatement) {
            SQLDeleteStatement p = (SQLDeleteStatement)parent;
            i$ = modifyTable.keySet().iterator();

            while(i$.hasNext()) {
               key = (String)i$.next();
               if (key.equalsIgnoreCase(tableName)) {
                  id = (String)tableKeyWord.get(tableName);
                  condition = tableAlisa + "." + id + " not in ('";
                  condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
                  p.addCondition(condition);
               }
            }
         }
      } else if (from instanceof SQLJoinTableSource) {
         SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
         SQLTableSource left = fromContent.getLeft();
         this.parseFromAndAddWhereCondition(left, param);
         SQLTableSource right = fromContent.getRight();
         this.parseFromAndAddWhereCondition(right, param);
      } else if (from instanceof SQLUnionQueryTableSource) {
         SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
         String alias = fromContent.getAlias();
         SQLUnionQuery union = fromContent.getUnion();
         List<SQLSelectQueryBlock> unionList = new ArrayList();
         this.parseUnionFrom(union, unionList);
      } else if (from instanceof SQLSubqueryTableSource) {
         SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
         SQLSelect select = fromContent.getSelect();
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
         this.parseFromAndAddWhereCondition(query.getFrom(), param);
      }

   }

   public void parseUpdateAndAddWhereCondition(SQLUpdateStatement update, Map<String, Object> param) {
      Map<String, List<String>> modifyTable = (Map)param.get("modifyTable");
      Map<String, String> tableKeyWord = (Map)param.get("tableKeyWord");
      SQLName table = update.getTableName();
      String tableName = table.getSimpleName();
      String tableAlisa = tableName;
      String[] tableInfo = tableName.split("\\.");
      if (tableInfo.length > 1) {
         tableName = tableInfo[1];
         tableAlisa = tableInfo[0];
      }

      tableName = tableName;
      Iterator i$ = modifyTable.keySet().iterator();

      while(i$.hasNext()) {
         String key = (String)i$.next();
         if (key.equalsIgnoreCase(tableName)) {
            String id = (String)tableKeyWord.get(tableName);
            String condition = "(" + tableAlisa + "." + id + " not in ('";
            condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
            condition = condition + " or " + tableAlisa + "." + id + " is null)";
            update.addCondition(condition);
         }
      }

   }

   public void parseDeleteAndAddWhereCondition(SQLDeleteStatement delete, Map<String, Object> param) {
      Map<String, List<String>> modifyTable = (Map)param.get("modifyTable");
      Map<String, String> tableKeyWord = (Map)param.get("tableKeyWord");
      SQLName table = delete.getTableName();
      String tableName = table.getSimpleName();
      String tableAlisa = tableName;
      String[] tableInfo = tableName.split("\\.");
      if (tableInfo.length > 1) {
         tableName = tableInfo[1];
         tableAlisa = tableInfo[0];
      }

      tableName = tableName;
      Iterator i$ = modifyTable.keySet().iterator();

      while(i$.hasNext()) {
         String key = (String)i$.next();
         if (key.equalsIgnoreCase(tableName)) {
            String id = (String)tableKeyWord.get(tableName);
            String condition = "(" + tableAlisa + "." + id + " not in ('";
            condition = condition + StringJoin.join((Iterable)modifyTable.get(tableName), "','") + "')";
            condition = condition + " or " + tableAlisa + "." + id + " is null)";
            delete.addCondition(condition);
         }
      }

   }

   public String parseSql() {
      Desensitization desensitization = new Desensitization();
      Map map = desensitization.parseData(this.params);
      return (String)map.get("newSql");
   }

   public String parseSql_column() {
      Desensitization desensitization = new Desensitization();
      Map map = desensitization.parseColumn(this.params);
      return (String)map.get("newSql");
   }

   private void parseCols(String schema) {
      String url = (String)this.params.get("url");
      String ip_port = url.split("/")[2];
      DataBase dataBase = null;
      Iterator i$ = JdbcUtil.dataBaseList.iterator();

      while(i$.hasNext()) {
         DataBase db = (DataBase)i$.next();
         if (ip_port.equalsIgnoreCase(db.getIp_port())) {
            dataBase = db;
            break;
         }
      }

      if (this.schemaMap.size() > 0) {
         schema = (String)this.schemaMap.values().iterator().next();
      }

      DatabaseCache simpleCache = dataBase.simpleCache;
      Set<String> columns = simpleCache.getColumns();
      if (this.columnList != null && this.columnList.size() > 0) {
         Iterator i$1 = this.columnList.iterator();

         while(true) {
            while(true) {
               Column column;
               String columnName;
               do {
                  if (!i$1.hasNext()) {
                     return;
                  }

                  column = (Column)i$1.next();
                  columnName = column.getColumnName();
               } while(columnName.equalsIgnoreCase(column.getRawName()));

               String[] split = columnName.split("\\.");
               String table = split.length == 2 ? split[0] : (split.length == 3 ? split[1] : "");
               String col = split.length == 1 ? split[0] : (split.length == 2 ? split[1] : split[2]);
               schema = schema.replace("\"", "");
               table = table.replace("\"", "");
               col = col.replace("\"", "");
               String id = schema + "." + table + "." + col;
               boolean contains = columns.contains(id);
               if (!contains) {
                  column.setColumnName(column.getColumnName().replace("\"", ""));
               } else {
                  StringBuilder s = new StringBuilder();

                  for(int i = 0; i < split.length; ++i) {
                     if (i == split.length - 1) {
                        s.append(split[i]);
                     } else {
                        String name = split[i];
                        if (name == null || name.length() == 0) {
                           continue;
                        }

                        if (name.contains("\"")) {
                           s.append(name);
                        } else {
                           s.append("\"" + name + "\"");
                        }
                     }

                     s.append(".");
                  }

                  s.deleteCharAt(s.length() - 1);
                  column.setColumnName(s.toString());
               }
            }
         }
      }
   }

   public String parseSql_table() {
      try {
         Desensitization desensitization = new Desensitization();
         desensitization.parseTable(this.params);
      } catch (Exception var2) {
         Exception throwables = var2;
         throwables.printStackTrace();
      }

      return (String)this.params.get("newSql");
   }

   public String parseSql_data() {
      Desensitization desensitization = new Desensitization();
      Map map = desensitization.parseData(this.params);
      return (String)map.get("newSql");
   }

   public void parseSqlStructureAndReplace(Map<String, Object> paramMap, Map<String, String> repalceMap) throws SQLException {
      String sql = (String)this.params.get("sql");
      String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
      String parseSql;
      if ("select".equals(sqlType)) {
         parseSql = this.parseSelectAndReplace(this.dbType, sql, repalceMap);
         paramMap.put("type", "select");
         paramMap.put("sql", parseSql);
      } else if ("union".equals(sqlType)) {
         parseSql = this.parseUnion(this.dbType, sql);
         paramMap.put("type", "union");
         paramMap.put("sql", parseSql);
      }

      paramMap.put("tableMap", this.tableMap);
      paramMap.put("columnList", this.columnList);
      paramMap.put("schemaMap", this.schemaMap);
      paramMap.put("whereMap", this.whereMap);
      paramMap.put("whereList", this.flatWhereListValues());
   }

   private List<Map<String, Object>> flatWhereListValues() {
      if (this.whereValueList != null && this.whereValueList.size() != 0) {
         List<Map<String, Object>> flats = new ArrayList();
         Iterator i$ = this.whereValueList.iterator();

         while(true) {
            while(true) {
               while(i$.hasNext()) {
                  Map<String, Object> column = (Map)i$.next();
                  Object columnValue = column.get("columnValue");
                  if (columnValue instanceof List) {
                     List values = (List)columnValue;
                     if (values != null && values.size() != 0) {
                        Iterator i$2 = values.iterator();

                        while(i$2.hasNext()) {
                           Object value = i$2.next();
                           Map<String, Object> columnMap = new HashMap(column);
                           columnMap.put("columnValue", value);
                           flats.add(columnMap);
                        }
                     } else {
                        column.put("columnValue", "");
                        flats.add(column);
                     }
                  } else {
                     flats.add(column);
                  }
               }

               return flats;
            }
         }
      } else {
         return this.whereValueList;
      }
   }

   public void parseSqlStructure(Map<String, Object> paramMap) throws SQLException {
      String sql = (String)this.params.get("sql");
      boolean isEncryption = this.params.containsKey("encryption");
      List<SQLStatement> statements = SQLUtils.parseStatements(sql, "postgresql");
      if (statements != null && statements.size() != 0) {
         String sqlType = JdbcUtil.getSqlType(sql, this.dbType);
         if (!"union".equals(sqlType) && !"select".equals(sqlType) && !"with_select".equals(sqlType) && !"insert".equals(sqlType) && !"update".equals(sqlType) && !"delete".equals(sqlType) && !"create".equals(sqlType) && !"alter".equals(sqlType) && !"insert_select".equals(sqlType)) {
            if ("truncate".equals(sqlType)) {
               SQLTruncateStatement stmt = (SQLTruncateStatement)statements.get(0);
               this.parseTruncateColumnsPG(stmt);
               paramMap.put("tableMap", this.tableMap);
               paramMap.put("columnList", this.columnList);
               paramMap.put("schemaMap", this.schemaMap);
               paramMap.put("whereMap", this.whereMap);
               paramMap.put("sql", stmt.toString());
               paramMap.put("whereList", new ArrayList());
               paramMap.put("type", sqlType);
               return;
            }

            if ("drop".equals(sqlType)) {
               SQLDropTableStatement drop = (SQLDropTableStatement)statements.get(0);
               this.parseDropTable(drop);
               paramMap.put("sql", drop.toString());
               paramMap.put("whereList", new ArrayList());
               paramMap.put("type", sqlType);
            } else if ("grant".equals(sqlType)) {
               SQLGrantStatement grant = this.parseGrant(this.dbType, sql);
               paramMap.put("type", "grant");
               paramMap.put("statement", grant);
               paramMap.put("sql", grant.toString());
            } else if ("revoke".equals(sqlType)) {
               SQLRevokeStatement revoke = this.parseRevoke(this.dbType, sql);
               paramMap.put("type", "revoke");
               paramMap.put("statement", revoke);
               paramMap.put("sql", revoke.toString());
            } else if ("drop schema".equals(sqlType)) {
               PGDropSchemaStatement dropSchema = (PGDropSchemaStatement)statements.get(0);
               this.parseDropSchema(dropSchema);
               paramMap.put("sql", dropSchema.toString());
               paramMap.put("whereList", new ArrayList());
               paramMap.put("type", sqlType);
            } else if ("alter schema".equals(sqlType)) {
               PGAlterSchemaStatement alterSchemaStatement = (PGAlterSchemaStatement)statements.get(0);
               this.parseAlterSchema(alterSchemaStatement);
               paramMap.put("sql", alterSchemaStatement.toString());
               paramMap.put("whereList", new ArrayList());
               paramMap.put("type", sqlType);
            } else if ("alter view".equals(sqlType)) {
               PGAlterViewStatement alterViewStatement = (PGAlterViewStatement)statements.get(0);
               this.parseAlterView(alterViewStatement);
               paramMap.put("sql", alterViewStatement.toString());
               paramMap.put("whereList", new ArrayList());
               paramMap.put("type", sqlType);
            }
         } else {
            String permission = (String)this.params.get("permission");
            String url = (String)this.params.get("url");
            String schema = (String)this.params.get("schema");
            String ip_port = getIpPort(url);
            SQLParser sqlParser = new SQLParser();
            DataBase dataBase = new DataBase();
            Iterator i$ = JdbcUtil.dataBaseList.iterator();

            while(i$.hasNext()) {
               DataBase db = (DataBase)i$.next();
               if (ip_port.equalsIgnoreCase(db.getIp_port())) {
                  dataBase = db;
                  break;
               }
            }

            SQLResult parse = sqlParser.parse(sql, dataBase, schema);
            if ("alter".equals(sqlType)) {
               parse.outputs = parse.fields;
            }

            List columnlist;
            if ("masking".equalsIgnoreCase(permission)) {
               columnlist = parse.outputs;
            } else if ("full".equalsIgnoreCase(permission)) {
               columnlist = parse.fields;
            } else if (isEncryption) {
               if (!"insert".equalsIgnoreCase(sqlType) && !"update".equalsIgnoreCase(sqlType)) {
                  columnlist = parse.outputs;
               } else {
                  columnlist = parse.fields;
               }
            } else {
               columnlist = parse.outputs;
            }

            PostgresqlNameWrapper wrapper = new PostgresqlNameWrapper(dataBase.simpleCache);
            Set<String> tabSet = new HashSet();
            Iterator i$4 = columnlist.iterator();

            label201:
            while(i$4.hasNext()) {
               FieldInfo fieldInfo = (FieldInfo)i$4.next();
               List<FieldInfo> fieldInfoList = new ArrayList();
               if (fieldInfo.getRelations().size() > 0) {
                  fieldInfoList = fieldInfo.getRelations();
               } else {
                  ((List)fieldInfoList).add(fieldInfo);
               }

               Iterator i$5 = ((List)fieldInfoList).iterator();

               while(true) {
                  String name;
                  String tableName;
                  String schemaName;
                  do {
                     do {
                        FieldInfo info;
                        do {
                           if (!i$5.hasNext()) {
                              continue label201;
                           }

                           info = (FieldInfo)i$5.next();
                           name = info.getName();
                        } while(StringUtils.isEmpty(name));

                        Map<String, TableInfo> tables = info.getTables();
                        tableName = "";
                        schemaName = "";
                        Iterator i$6 = tables.keySet().iterator();

                        while(i$6.hasNext()) {
                           String s = (String)i$6.next();
                           String[] segment = s.split("\\.");
                           if (!StringUtils.isEmpty(segment[0]) && !StringUtils.isEmpty(segment[1])) {
                              schemaName = segment[0];
                              tableName = segment[1];
                              break;
                           }
                        }

                        if (tableName.length() == 0 && info.getTables().size() > 0) {
                           i$6 = info.getTables().entrySet().iterator();

                           while(i$6.hasNext()) {
                              Map.Entry<String, TableInfo> entry = (Map.Entry)i$6.next();
                              TableInfo tbInfo = (TableInfo)entry.getValue();
                              if (tbInfo != null && tbInfo.getTable() != null && !StringUtils.isEmpty(tbInfo.getTable().schema) && !StringUtils.isEmpty(tbInfo.getTable().name)) {
                                 tableName = tbInfo.getTable().name;
                                 schemaName = tbInfo.getTable().schema;
                                 break;
                              }
                           }
                        }

                        schemaName = wrapper.unwrapSchema(schemaName);
                        tableName = wrapper.unwrapTable(schemaName, tableName);
                        tabSet.add(tableName);
                     } while(name.equalsIgnoreCase("ROWID"));
                  } while(name.equalsIgnoreCase("ORA_ROWSCN"));

                  Column column = new Column();
                  column.setColumnName(tableName + "." + name);
                  column.setTable(tableName);
                  column.setSchema(schemaName);
                  column.setColumnAlisa(fieldInfo.getAlias() != null && !"".equals(fieldInfo.getAlias()) ? fieldInfo.getAlias().replaceAll("\"", "") : "");
                  if ((null == fieldInfo.getAlias() || fieldInfo.getAlias().length() == 0) && null != fieldInfo.getAlias() && !"".equals(fieldInfo.getAlias()) && !fieldInfo.getAlias().equals(column.getColumnAlisa()) && null != this.columnList && this.columnList.size() > 0) {
                     ListIterator<Column> listIterator = this.columnList.listIterator();

                     while(listIterator.hasNext()) {
                        Column element = (Column)listIterator.next();
                        if (element.getSchema().equals(column.getSchema()) && element.getTable().equals(column.getTable()) && element.getColumnAlisa().equals(column.getColumnAlisa()) && element.getRawName().equals(column.getRawName()) && element.getColumnName().equals(column.getColumnName())) {
                           column.setColumnAlisa(fieldInfo.getAlias());
                           break;
                        }
                     }
                  }

                  column.setSubQuery(false);
                  column.setSeq(fieldInfo.getSeq());
                  column.setFieldIds(fieldInfo.getFieldIds());
                  this.columnList.add(column);
               }
            }

            i$4 = parse.tables.iterator();

            while(i$4.hasNext()) {
               TableInfo table = (TableInfo)i$4.next();
               TableMemo tb = table.getTable();
               String schName = wrapper.unwrapSchema(tb.schema);
               String tbName = wrapper.unwrapTable(schName, tb.name);
               this.tableMap.put(tbName, tbName);
               this.schemaMap.put(tbName, schName);
            }

            i$4 = parse.values.iterator();

            while(i$4.hasNext()) {
               ValueInfo value = (ValueInfo)i$4.next();
               FieldMemo field = value.field;
               this.whereMap.put(field.name, value.value.toString());
               Map<String, Object> map = new HashMap();
               map.put("column", value.getValueNames());
               map.put("columnValue", value.value.toString());
               map.put("type", value.operator);
               this.whereList.add(map);
            }

            paramMap.put("whereList", this.whereList);
            paramMap.put("statement", parse.statement);
            paramMap.put("type", parse.sqlType.name().toLowerCase());
            paramMap.put("sql", parse.statement.toString());
            wrapper.unwrapFullColumns(this.columnList);
         }

         paramMap.put("whereMap", this.whereMap);
         paramMap.put("tableMap", this.tableMap);
         paramMap.put("columnList", this.columnList);
         paramMap.put("schemaMap", this.schemaMap);
      }
   }

   public void parseTruncateColumnsPG(SQLTruncateStatement truncate) throws SQLException {
      List<SQLExprTableSource> tableSources = truncate.getTableSources();
      this.parseTableSourceList(tableSources);
   }

   private void parseAlterView(PGAlterViewStatement alterViewStatement) {
      String url = (String)this.params.get("url");
      String ip_port = getIpPort(url);
      DataBase dataBase = new DataBase();
      Iterator i$ = JdbcUtil.dataBaseList.iterator();

      while(i$.hasNext()) {
         DataBase db = (DataBase)i$.next();
         if (ip_port.equalsIgnoreCase(db.getIp_port())) {
            dataBase = db;
            break;
         }
      }

      String schema = (String)this.params.get("schema");
      Context context = new Context();
      context.initialize(dataBase, schema, "postgresql");
      SQLExpr newSchema = alterViewStatement.getNewSchema();
      if (newSchema != null) {
         SQLIdentifierExpr parseschema = (SQLIdentifierExpr)newSchema;
         ArrayList<SQLIdentifierExpr> list = new ArrayList();
         list.add(parseschema);
         this.parseSchema(list);
      }

   }

   private void parseAlterSchema(PGAlterSchemaStatement stmt) {
      SQLIdentifierExpr schema = stmt.getSchemaName();
      ArrayList<SQLIdentifierExpr> list = new ArrayList();
      list.add(schema);
      this.parseSchema(list);
   }

   public void parseDropSchema(PGDropSchemaStatement drop) {
      this.parseSchema(drop.getSchemaList());
   }

   private void parseSchema(ArrayList<SQLIdentifierExpr> schemaList) {
      String url = (String)this.params.get("url");
      String ip_port = getIpPort(url);
      DataBase dataBase = new DataBase();
      Iterator i$ = JdbcUtil.dataBaseList.iterator();

      while(i$.hasNext()) {
         DataBase db = (DataBase)i$.next();
         if (ip_port.equalsIgnoreCase(db.getIp_port())) {
            dataBase = db;
            break;
         }
      }

      List<Schema> dbSchemaList = dataBase.getSchemaList();
      Iterator i$7 = schemaList.iterator();

      while(true) {
         Schema dbSchema;
         do {
            if (!i$7.hasNext()) {
               return;
            }

            SQLIdentifierExpr expr = (SQLIdentifierExpr)i$7.next();
            String schema = expr.getName();
            dbSchema = null;
            Iterator i$8 = dbSchemaList.iterator();

            while(i$8.hasNext()) {
               Schema schema1 = (Schema)i$8.next();
               if (schema.equals(schema1.getName())) {
                  dbSchema = schema1;
               }
            }
         } while(dbSchema == null);

         List<Table> tableList = dbSchema.getTableList();
         Iterator i$9 = tableList.iterator();

         while(i$9.hasNext()) {
            Table table = (Table)i$9.next();
            String tableName = table.getName();
            this.tableMap.put(tableName, tableName);
            this.schemaMap.put(tableName, dbSchema.getName());
         }
      }
   }

   private void parseTableSourceList(List<SQLExprTableSource> tableSources) throws SQLException {
      String url = (String)this.params.get("url");
      String ip_port = url.split("/")[2];
      Iterator i$ = tableSources.iterator();

      while(i$.hasNext()) {
         SQLExprTableSource tableSource = (SQLExprTableSource)i$.next();
         String schema = (String)this.params.get("schema");
         String tableName = tableSource.getTableName();
         SQLExpr expr1 = tableSource.getExpr();
         if (expr1 instanceof SQLIdentifierExpr) {
            SQLPropertyExpr expr = new SQLPropertyExpr();
            expr.setName(tableName);
            expr.setOwner(schema);
            tableSource.setExpr(expr);
         } else if (expr1 instanceof SQLPropertyExpr) {
            schema = ((SQLPropertyExpr)expr1).getOwnerName();
         }

         this.tableMap.put(tableName, tableName);
         this.schemaMap.put(tableName, schema);
         List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema, tableName, tableName, this.tableList);
         Iterator i$10 = tableColumns.iterator();

         while(i$10.hasNext()) {
            Column tableColumn = (Column)i$10.next();
            Column column = new Column();
            column.setColumnName(tableColumn.getColumnName());
            this.columnList.add(column);
         }
      }

   }

   public void parseDropTable(SQLDropTableStatement stmt) throws SQLException {
      List<SQLExprTableSource> tableSources = stmt.getTableSources();
      this.parseTableSourceList(tableSources);
   }

   public String parseSelect(String dbType, String sql) throws SQLException {
      SQLSelectQueryBlock query = this.aliParseSelect(dbType, sql, true);
      this.parseFrom(query.getFrom(), (Map)null, "", true);
      this.parseFrom(query.getFrom(), (Map)null, "", false);
      this.parseWhere(query.getWhere());
      this.parseLimit(query.getLimit());
      sql = this.parseSelectStar(query);
      query = this.aliParseSelect(dbType, sql, false);
      this.parseQueryColumns(query, "");
      sql = this.parseSelectStar(query);
      return sql;
   }

   private void parseSelect(SQLSelect select) throws SQLException {
      SQLSelectQuery selectQuery = select.getQueryBlock();
      if (selectQuery instanceof SQLUnionQuery) {
         StringBuilder result = new StringBuilder();
         SQLUnionQuery query = (SQLUnionQuery)selectQuery;
         this.dealUnion(query, result);
      } else {
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
         this.parseFrom(query.getFrom(), (Map)null, "", true);
         this.parseFrom(query.getFrom(), (Map)null, "", false);
         this.parseWhere(query.getWhere());
         this.parseLimit(query.getLimit());
         String sql = this.parseSelectStar(query);
         query = this.aliParseSelect(this.dbType, sql, false);
         this.parseQueryColumns(query, "");
         this.parseSelectStar(query);
      }

   }

   public String parseSelectAndReplace(String dbType, String sql, Map<String, String> replaceMap) throws SQLException {
      SQLSelectQueryBlock query = this.aliParseSelectAndRepalce(dbType, sql, true, replaceMap);
      return query.toString();
   }

   public SQLSelectQueryBlock aliParseSelectAndRepalce(String dbType, String sql, boolean first, Map<String, String> replaceMap) throws SQLException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
         SQLSelect select = stmt.getSelect();
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
         if (first) {
            query = JdbcUtil.doPareAndRepalce(query, this.params, this.tableList, replaceMap);
         }

         return query;
      }
   }

   public SQLSelectQueryBlock aliParseSelect(String dbType, String sql, boolean first) throws SQLException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
         SQLSelect select = stmt.getSelect();
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
         if (first) {
            query = JdbcUtil.postgreJudgeViewAndModify(query, this.params, this.tableList);
         }

         return query;
      }
   }

   public Map<String, String> parseFromAndReplace(SQLTableSource from, Map<String, String> map, String subTableAlias, Map<String, String> replaceMap) throws SQLException {
      String className = from.getClass().getName();
      String tableName;
      String sql;
      if (className.contains("SQLExprTableSource")) {
         SQLExprTableSource fromContent = (SQLExprTableSource)from;
         tableName = fromContent.getExpr().toString();
         String tableAlisa = fromContent.getAlias();
         sql = fromContent.getExpr().getClass().getName();
         String name;
         String realTable;
         if (sql.contains("SQLPropertyExpr")) {
            SQLPropertyExpr expr = (SQLPropertyExpr)fromContent.getExpr();
            tableName = expr.getName();
            name = expr.getOwner().toString();
            this.schemaMap.put(tableName, name);
         } else {
            realTable = (String)this.params.get("schema");
            SQLIdentifierExpr expr = (SQLIdentifierExpr)fromContent.getExpr();
            SQLPropertyExpr pExpr = new SQLPropertyExpr();
            pExpr.setName(expr.getName());
            pExpr.setOwner(realTable);
            fromContent.setExpr(pExpr);
            this.schemaMap.put(tableName, realTable);
         }

         tableAlisa = tableAlisa == null ? tableName : tableAlisa;
         if (map == null) {
            this.tableMap.put(tableAlisa, tableName);
            realTable = (String)this.tableMap.get(subTableAlias);
            if (realTable == null) {
               this.tableMap.put(subTableAlias, tableName);
            } else if (!realTable.equalsIgnoreCase(subTableAlias)) {
               this.tableMap.put(subTableAlias, realTable + "." + tableName);
            }

            name = fromContent.getParent().getClass().getName().toLowerCase();
            if (name.contains("SQLSelectQueryBlock".toLowerCase())) {
               this.parseWhereAndReplace(((SQLSelectQueryBlock)from.getParent()).getWhere(), replaceMap);
               SQLSelectGroupByClause groupBy = ((SQLSelectQueryBlock)from.getParent()).getGroupBy();
               if (groupBy != null) {
                  this.parseHavingAndReplace(((SQLSelectQueryBlock)from.getParent()).getGroupBy().getHaving(), replaceMap);
               }
            } else if (name.contains("SQLJoinTableSource".toLowerCase())) {
               this.parseWhereAndReplace(((SQLJoinTableSource)from.getParent()).getCondition(), replaceMap);
            }
         } else {
            map.put(tableAlisa, tableName);
         }
      } else if (className.contains("SQLJoinTableSource")) {
         SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
         SQLTableSource left = fromContent.getLeft();
         this.parseFromAndReplace(left, map, "", replaceMap);
         SQLTableSource right = fromContent.getRight();
         this.parseFromAndReplace(right, map, "", replaceMap);
         if (from.getParent().getClass().equals(SQLSelectQueryBlock.class)) {
            SQLSelectQueryBlock block = (SQLSelectQueryBlock)from.getParent();
            if (block.getWhere() != null) {
               this.parseWhereAndReplace(block.getWhere(), replaceMap);
               if (block.getGroupBy() != null) {
                  this.parseHavingAndReplace(block.getGroupBy().getHaving(), replaceMap);
               }
            }
         }
      } else if (className.contains("SQLUnionQueryTableSource")) {
         SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
         tableName = fromContent.getAlias();
         SQLUnionQuery union = fromContent.getUnion();
         List<SQLSelectQueryBlock> unionList = new ArrayList();
         this.parseUnionFrom(union, unionList);
         this.paresUnionFromSqlAndReplace(unionList, tableName, replaceMap);
         if (map == null) {
            this.tableMap.put(tableName, tableName);
         } else {
            map.put(tableName, tableName);
         }
      } else if (className.contains("SQLSubqueryTableSource")) {
         SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
         SQLSelect select = fromContent.getSelect();
         if (map == null) {
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
            this.parseFromAndReplace(query.getFrom(), map, fromContent.getAlias(), replaceMap);
            sql = this.parseSelectStar(query);
            SQLSelectQueryBlock subQuery = this.aliParseSelect(this.dbType, sql, false);
            this.parseQueryColumns(subQuery, fromContent.getAlias());
            if (!"".equalsIgnoreCase(subTableAlias)) {
               this.tableMap.put(subTableAlias, fromContent.getAlias());
            }

            this.parseWhereAndReplace(query.getWhere(), replaceMap);
            if (from.getParent() instanceof SQLJoinTableSource) {
               this.parseWhereAndReplace(((SQLJoinTableSource)from.getParent()).getCondition(), replaceMap);
            }
         } else {
            map.put(fromContent.getAlias(), fromContent.getAlias());
         }
      }

      return this.tableMap;
   }

   public Map<String, String> parseFrom(SQLTableSource from, Map<String, String> map, String subTableAlias, boolean first) throws SQLException {
      String className = from.getClass().getName();
      String tableName;
      String sql;
      if (className.contains("SQLExprTableSource")) {
         SQLExprTableSource fromContent = (SQLExprTableSource)from;
         tableName = fromContent.getExpr().toString();
         String tableAlisa = fromContent.getAlias();
         sql = fromContent.getExpr().getClass().getName();
         String name;
         String realTable;
         if (sql.contains("SQLPropertyExpr")) {
            SQLPropertyExpr expr = (SQLPropertyExpr)fromContent.getExpr();
            tableName = expr.getName();
            name = expr.getOwner().toString();
            this.schemaMap.put(tableName, name);
         } else {
            realTable = (String)this.params.get("schema");
            SQLIdentifierExpr expr = (SQLIdentifierExpr)fromContent.getExpr();
            SQLPropertyExpr pExpr = new SQLPropertyExpr();
            pExpr.setName(expr.getName());
            pExpr.setOwner(realTable);
            fromContent.setExpr(pExpr);
            this.schemaMap.put(tableName, realTable);
         }

         tableAlisa = tableAlisa == null ? tableName : tableAlisa;
         if (map == null) {
            this.tableMap.put(tableAlisa.toLowerCase(), tableName);
            realTable = (String)this.tableMap.get(subTableAlias);
            if (realTable == null) {
               this.tableMap.put(subTableAlias, tableName);
            } else if (!realTable.equalsIgnoreCase(subTableAlias)) {
               this.tableMap.put(subTableAlias, realTable + "." + tableName);
            }

            name = fromContent.getParent().getClass().getName().toLowerCase();
            if (name.contains("SQLSelectQueryBlock".toLowerCase()) && !first) {
               this.parseWhere(((SQLSelectQueryBlock)from.getParent()).getWhere());
               SQLSelectGroupByClause groupBy = ((SQLSelectQueryBlock)from.getParent()).getGroupBy();
               if (groupBy != null && !first) {
                  this.parseHaving(((SQLSelectQueryBlock)from.getParent()).getGroupBy().getHaving());
               }
            } else if (name.contains("SQLJoinTableSource".toLowerCase()) && !first) {
               this.parseWhere(((SQLJoinTableSource)from.getParent()).getCondition());
            }
         } else {
            map.put(tableAlisa, tableName);
         }
      } else if (className.contains("SQLJoinTableSource")) {
         SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
         SQLTableSource left = fromContent.getLeft();
         this.parseFrom(left, map, "", first);
         SQLTableSource right = fromContent.getRight();
         this.parseFrom(right, map, "", first);
         if (fromContent.getCondition() != null && map == null && !first) {
            this.parseWhere(fromContent.getCondition());
         }

         if (from.getParent().getClass().equals(SQLSelectQueryBlock.class)) {
            SQLSelectQueryBlock block = (SQLSelectQueryBlock)from.getParent();
            if (block.getWhere() != null && map == null && !first) {
               this.parseWhere(block.getWhere());
               if (block.getGroupBy() != null && !first) {
                  this.parseHaving(block.getGroupBy().getHaving());
               }
            }
         }
      } else if (className.contains("SQLUnionQueryTableSource")) {
         SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
         tableName = fromContent.getAlias();
         SQLUnionQuery union = fromContent.getUnion();
         List<SQLSelectQueryBlock> unionList = new ArrayList();
         this.parseUnionFrom(union, unionList);
         this.paresUnionFromSql(unionList, tableName, first);
         if (map == null) {
            this.tableMap.put(tableName.toLowerCase(), tableName);
         } else {
            map.put(tableName, tableName);
         }
      } else if (className.contains("SQLSubqueryTableSource")) {
         SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
         SQLSelect select = fromContent.getSelect();
         if (map == null) {
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
            this.parseFrom(query.getFrom(), map, fromContent.getAlias(), first);
            sql = this.parseSelectStar(query);
            SQLSelectQueryBlock subQuery = this.aliParseSelect(this.dbType, sql, false);
            this.parseQueryColumns(subQuery, fromContent.getAlias());
            if (!"".equalsIgnoreCase(subTableAlias)) {
               this.tableMap.put(subTableAlias.toLowerCase(), fromContent.getAlias());
            }

            if (!first) {
               this.parseWhere(query.getWhere());
            }
         } else {
            map.put(fromContent.getAlias(), fromContent.getAlias());
         }
      }

      return this.tableMap;
   }

   private void parseHaving(SQLExpr having) throws SQLException {
      this.parseWhere(having);
   }

   private void parseHavingAndReplace(SQLExpr having, Map<String, String> replaceMap) {
      this.parseWhereAndReplace(having, replaceMap);
   }

   public void parseUnionFrom(SQLUnionQuery union, List<SQLSelectQueryBlock> unionList) {
      List<SQLSelectQuery> queryList = union.getRelations();

      for(int i = 0; i < queryList.size(); ++i) {
         SQLSelectQuery selectQuery = (SQLSelectQuery)queryList.get(i);
         String className = selectQuery.getClass().getName();
         if (className.contains("SQLUnionQuery")) {
            SQLUnionQuery unQuery = (SQLUnionQuery)selectQuery;
            this.parseUnionFrom(unQuery, unionList);
         } else {
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
            unionList.add(query);
         }
      }

   }

   public void paresUnionFromSql(List<SQLSelectQueryBlock> unionList, String alias, boolean first) throws SQLException {
      for(int i = 0; i < unionList.size(); ++i) {
         this.unionTableMap.clear();
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)unionList.get(i);
         this.parseFrom(query.getFrom(), (Map)null, "", first);
         String sql = this.parseSelectStar(query);
         if (i == unionList.size() - 1) {
            query = this.aliParseSelect(this.dbType, sql, false);
            this.parseQueryColumns(query, alias);
         }
      }

   }

   public void paresUnionFromSqlAndReplace(List<SQLSelectQueryBlock> unionList, String alias, Map<String, String> replaceMap) throws SQLException {
      for(int i = 0; i < unionList.size(); ++i) {
         this.unionTableMap.clear();
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)unionList.get(i);
         this.parseFromAndReplace(query.getFrom(), (Map)null, "", replaceMap);
         String sql = this.parseSelectStar(query);
         if (i == unionList.size() - 1) {
            query = this.aliParseSelect(this.dbType, sql, false);
            this.parseQueryColumns(query, alias);
         }
      }

   }

   public boolean isHaveOwner(SQLInListExpr sqlInListExpr) {
      boolean isHave = true;

      try {
         SQLPropertyExpr expr = (SQLPropertyExpr)sqlInListExpr.getExpr();
         SQLIdentifierExpr var4 = (SQLIdentifierExpr)expr.getOwner();
      } catch (Exception var5) {
         isHave = false;
      }

      return isHave;
   }

   private void putInWhereParams(SQLExpr expr, String key, Object value) {
      Iterator i$ = this.parsedWhereExprs.iterator();

      while(i$.hasNext()) {
         SQLExpr parsedExpr = (SQLExpr)i$.next();
         if (expr == parsedExpr) {
            return;
         }
      }

      HashMap<String, Object> map = new HashMap();
      String type = SQLBinaryOperator.Equality.toString();
      SQLObject curr = expr;
      SQLObject op = null;
      int MAX_STEP = 10;

      for(int i = 0; i < MAX_STEP; ++i) {
         if (curr instanceof SQLBinaryOpExpr) {
            op = curr;
            break;
         }

         if (curr instanceof SQLInListExpr) {
            op = curr;
            break;
         }

         if (((SQLObject)curr).getParent() == null) {
            break;
         }

         curr = ((SQLObject)curr).getParent();
      }

      if (op != null) {
         if (op instanceof SQLBinaryOpExpr) {
            type = ((SQLBinaryOpExpr)op).getOperator().toString();
         }

         if (op instanceof SQLInListExpr) {
            type = "IN";
         }
      }

      map.put("column", key);
      map.put("columnValue", value);
      map.put("type", type);
      this.whereValueList.add(map);
      this.parsedWhereExprs.add(expr);
   }

   public void parseWhereAndReplace(SQLExpr where, Map<String, String> replaceMap) {
      if (where != null) {
         String tableName;
         String colName;
         String schema;
         String fieldValue;
         if (where instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr sqlExpr = (SQLBinaryOpExpr)where;
            SQLBinaryOperator operator = sqlExpr.getOperator();
            if (operator.toString().equalsIgnoreCase("BooleanAnd")) {
               this.parseWhereAndReplace(sqlExpr.getLeft(), replaceMap);
               this.parseWhereAndReplace(sqlExpr.getRight(), replaceMap);
            } else if (operator.toString().equalsIgnoreCase("BooleanOr")) {
               this.parseWhereAndReplace(sqlExpr.getLeft(), replaceMap);
               this.parseWhereAndReplace(sqlExpr.getRight(), replaceMap);
            } else {
               SQLExpr left;
               SQLExpr right;
               Iterator i$;
               String key;
               SQLExpr owner;
               String replaceValue;
               if (operator.toString().equalsIgnoreCase("like")) {
                  tableName = "";
                  colName = "";
                  schema = "";
                  left = sqlExpr.getLeft();
                  right = sqlExpr.getRight();
                  if (!this.parseMethodInvokeAndReplaceExpr(left, right, replaceMap)) {
                     if (!(left instanceof SQLIdentifierExpr)) {
                        if (left instanceof SQLPropertyExpr) {
                           owner = ((SQLPropertyExpr)left).getOwner();
                           key = ((SQLIdentifierExpr)owner).getName();
                           colName = ((SQLPropertyExpr)left).getName();
                           tableName = (String)this.tableMap.get(key);
                           schema = (String)this.schemaMap.get(tableName);
                        }
                     } else {
                        colName = ((SQLIdentifierExpr)left).getName();
                        i$ = this.tableMap.keySet().iterator();

                        while(i$.hasNext()) {
                           key = (String)i$.next();
                           if (!key.isEmpty()) {
                              tableName = (String)this.tableMap.get(key);
                           }
                        }

                        schema = (String)this.schemaMap.get(tableName);
                     }

                     replaceValue = (String)replaceMap.get(schema + "." + tableName + "." + colName);
                     if (right instanceof SQLCharExpr && replaceValue != null && !replaceValue.isEmpty()) {
                        ((SQLCharExpr)right).setText(replaceValue);
                     }
                  }
               } else if (operator.toString().equalsIgnoreCase("equality")) {
                  tableName = "";
                  colName = "";
                  schema = "";
                  left = sqlExpr.getLeft();
                  right = sqlExpr.getRight();
                  if (!this.parseMethodInvokeAndReplaceExpr(left, right, replaceMap)) {
                     if (!(left instanceof SQLIdentifierExpr)) {
                        if (left instanceof SQLPropertyExpr) {
                           owner = ((SQLPropertyExpr)left).getOwner();
                           key = ((SQLIdentifierExpr)owner).getName();
                           colName = ((SQLPropertyExpr)left).getName();
                           tableName = (String)this.tableMap.get(key);
                           schema = (String)this.schemaMap.get(tableName);
                        }
                     } else {
                        colName = ((SQLIdentifierExpr)left).getName();
                        i$ = this.tableMap.keySet().iterator();

                        while(i$.hasNext()) {
                           key = (String)i$.next();
                           if (!key.isEmpty()) {
                              tableName = (String)this.tableMap.get(key);
                           }
                        }

                        schema = (String)this.schemaMap.get(tableName);
                     }

                     if (right instanceof SQLTextLiteralExpr) {
                        replaceValue = (String)replaceMap.get(schema + "." + tableName + "." + colName);
                        if (replaceValue != null && !replaceValue.isEmpty()) {
                           ((SQLCharExpr)right).setText(replaceValue);
                        }
                     } else if (right instanceof SQLQueryExpr) {
                        SQLTableSource subFrom = ((SQLQueryExpr)right).getSubQuery().getQueryBlock().getFrom();

                        try {
                           this.parseFromAndReplace(subFrom, (Map)null, "", replaceMap);
                        } catch (SQLException var17) {
                           var17.printStackTrace();
                        }
                     }
                  }
               } else {
                  left = sqlExpr.getLeft();
                  right = sqlExpr.getRight();
                  schema = left.toString();
                  fieldValue = right.toString();
                  if (!this.parseMethodInvokeAndReplaceExpr(left, right, replaceMap)) {
                     try {
                        if (left.getClass().getName().contains("SQLIdentifierExpr") && left.toString().split("\\.").length == 1) {
                           Map<String, String> localMap = new HashMap();
                           this.parseFrom(((SQLSelectQueryBlock)where.getParent()).getFrom(), localMap, "", true);
                           this.columnAddTableAlias(left, localMap);
                        }
                     } catch (SQLException var16) {
                        var16.printStackTrace();
                     }

                     String value = (String)this.whereMap.get(schema);
                     if (value == null) {
                        this.whereMap.put(schema, fieldValue);
                        this.putInWhereParams(left, schema, fieldValue);
                     } else if (!value.equalsIgnoreCase(fieldValue)) {
                        this.whereMap.put(schema, value + "," + fieldValue);
                        this.putInWhereParams(left, schema, value + "," + fieldValue);
                     }
                  }
               }
            }
         } else if (where instanceof SQLExistsExpr) {
            SQLExistsExpr existsExpr = (SQLExistsExpr)where;
            SQLSelect sqlSelect = existsExpr.subQuery;
            SQLBinaryOpExpr curWhere = (SQLBinaryOpExpr)((SQLSelectQueryBlock)sqlSelect.getQuery()).getWhere();
            SQLSelectQueryBlock subQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();

            try {
               this.parseFromAndReplace(subQuery.getFrom(), (Map)null, "", replaceMap);
            } catch (SQLException var15) {
               var15.printStackTrace();
            }

            this.parseWhereAndReplace(curWhere, replaceMap);
         } else if (where instanceof SQLInListExpr) {
            SQLInListExpr sqlInListExpr = (SQLInListExpr)where;
            tableName = "";
            String columnWithTable = "";
            if (this.isHaveOwner(sqlInListExpr)) {
               SQLPropertyExpr expr = (SQLPropertyExpr)sqlInListExpr.getExpr();
               SQLIdentifierExpr owner = (SQLIdentifierExpr)expr.getOwner();
               fieldValue = owner.getName();
               tableName = (String)this.tableMap.get(fieldValue);
               columnWithTable = tableName + "." + expr.getName();
            } else {
               SQLObject parent;
               for(parent = sqlInListExpr.getParent(); !(parent instanceof SQLSelectQueryBlock); parent = parent.getParent()) {
               }

               tableName = ((SQLPropertyExpr)((SQLExprTableSource)((SQLSelectQueryBlock)parent).getFrom()).getExpr()).getName();
               columnWithTable = tableName + "." + ((SQLIdentifierExpr)sqlInListExpr.getExpr()).getName();
            }

            colName = (String)this.schemaMap.get(tableName);
            schema = (String)replaceMap.get(colName + "." + columnWithTable);
            if (schema != null && !schema.isEmpty()) {
               List<SQLExpr> list = new ArrayList();
               String[] split = schema.split(",");
               String[] arr$ = split;
               int len$ = split.length;

               for(int i$ = 0; i$ < len$; ++i$) {
                  String s = arr$[i$];
                  SQLCharExpr expr = new SQLCharExpr(s);
                  list.add(expr);
               }

               sqlInListExpr.setTargetList(list);
            }
         }

      }
   }

   private boolean parseMethodInvokeAndReplaceExpr(SQLExpr expr, SQLExpr right, Map<String, String> replaceMap) {
      if (!(expr instanceof SQLMethodInvokeExpr)) {
         return false;
      } else {
         String colValue = right.toString();
         List<SQLExpr> params = ((SQLMethodInvokeExpr)expr).getParameters();
         if (params != null) {
            Iterator i$ = params.iterator();

            while(i$.hasNext()) {
               SQLExpr param = (SQLExpr)i$.next();
               String colName = "";
               String tableName = "";
               String schema = "";
               String key;
               if (!(param instanceof SQLIdentifierExpr)) {
                  if (param instanceof SQLPropertyExpr) {
                     SQLExpr owner = ((SQLPropertyExpr)param).getOwner();
                     key = ((SQLIdentifierExpr)owner).getName();
                     colName = ((SQLPropertyExpr)param).getName();
                     tableName = (String)this.tableMap.get(key);
                     schema = (String)this.schemaMap.get(tableName);
                  }
               } else {
                  colName = ((SQLIdentifierExpr)param).getName();
                  Iterator i$9 = this.tableMap.keySet().iterator();

                  while(i$9.hasNext()) {
                     key = (String)i$9.next();
                     if (!key.isEmpty()) {
                        tableName = (String)this.tableMap.get(key);
                     }
                  }

                  schema = (String)this.schemaMap.get(tableName);
               }

               String replaceValue = (String)replaceMap.get(schema + "." + tableName + "." + colName);
               if (right instanceof SQLCharExpr && replaceValue != null && !replaceValue.isEmpty()) {
                  ((SQLCharExpr)right).setText(replaceValue);
               }

               this.whereMap.put(schema + "." + tableName + "." + colName, colValue);
               this.putInWhereParams(param, schema + "." + tableName + "." + colName, colValue);
            }
         }

         return true;
      }
   }

   public void parseWhere(SQLExpr where) throws SQLException {
      if (where != null) {
         boolean exists = false;
         Iterator i$ = this.parsedCache.iterator();

         while(i$.hasNext()) {
            SQLObject sqlObject = (SQLObject)i$.next();
            if (sqlObject == where) {
               exists = true;
            }
         }

         if (!exists) {
            this.parsedCache.add(where);
            String tableAlias = null;
            String tableName;
            String schema;
            String colValue;
            String value;
            if (where instanceof SQLBinaryOpExpr) {
               SQLBinaryOpExpr sqlExpr = (SQLBinaryOpExpr)where;
               SQLBinaryOperator operator = sqlExpr.getOperator();
               if (operator.toString().equalsIgnoreCase("BooleanAnd")) {
                  this.parseWhere(sqlExpr.getLeft());
                  this.parseWhere(sqlExpr.getRight());
               } else if (operator.toString().equalsIgnoreCase("BooleanOr")) {
                  this.parseWhere(sqlExpr.getLeft());
                  this.parseWhere(sqlExpr.getRight());
               } else {
                  String colName;
                  SQLExpr left;
                  SQLExpr right;
                  Iterator i$10;
                  String finalColName;
                  SQLExpr owner;
                  if (operator.toString().equalsIgnoreCase("like")) {
                     tableName = "";
                     colName = "";
                     Object colValue1 = "";
                     schema = "";
                     left = sqlExpr.getLeft();
                     right = sqlExpr.getRight();
                     if (right instanceof SQLCharExpr) {
                        colValue1 = ((SQLCharExpr)right).getText().replaceAll("%", "").replaceAll("_", "");
                     } else if (right instanceof SQLVariantRefExpr) {
                        colValue1 = right.toString().replaceAll("%", "").replaceAll("_", "");
                     } else if (right instanceof SQLMethodInvokeExpr) {
                        colValue1 = ((SQLMethodInvokeExpr)right).getArguments();
                     }

                     if (!this.parseMethodInvokeExpr(left, right)) {
                        if (!(left instanceof SQLIdentifierExpr)) {
                           if (left instanceof SQLPropertyExpr) {
                              owner = ((SQLPropertyExpr)left).getOwner();
                              finalColName = ((SQLIdentifierExpr)owner).getName();
                              colName = ((SQLPropertyExpr)left).getName();
                              tableName = (String)this.tableMap.get(finalColName);
                              schema = (String)this.schemaMap.get(tableName);
                           }
                        } else {
                           colName = ((SQLIdentifierExpr)left).getName();
                           i$10 = this.tableMap.keySet().iterator();

                           while(i$10.hasNext()) {
                              finalColName = (String)i$10.next();
                              if (!finalColName.isEmpty()) {
                                 tableName = (String)this.tableMap.get(finalColName);
                              }
                           }

                           schema = (String)this.schemaMap.get(tableName);
                        }

                        this.whereMap.put(schema + "." + tableName + "." + colName, colValue1);
                        this.putInWhereParams(left, schema + "." + tableName + "." + colName, colValue1);
                     }
                  } else if (!operator.toString().equalsIgnoreCase("equality") && !operator.toString().equalsIgnoreCase("LessThanOrGreater") && !operator.toString().equalsIgnoreCase("NotEqual") && !operator.toString().equalsIgnoreCase(SQLBinaryOperator.LessThan.toString()) && !operator.toString().equalsIgnoreCase(SQLBinaryOperator.LessThanOrEqual.toString()) && !operator.toString().equalsIgnoreCase(SQLBinaryOperator.GreaterThan.toString()) && !operator.toString().equalsIgnoreCase(SQLBinaryOperator.GreaterThanOrEqual.toString())) {
                     if (!operator.toString().equalsIgnoreCase(SQLBinaryOperator.Is.toString()) && !operator.toString().equalsIgnoreCase(SQLBinaryOperator.IsNot.toString())) {
                        left = sqlExpr.getLeft();
                        right = sqlExpr.getRight();
                        if (!this.parseMethodInvokeExpr(left, right)) {
                           try {
                              if (left.getClass().getName().contains("SQLIdentifierExpr") && left.toString().split("\\.").length == 1) {
                                 Map<String, String> localMap = new HashMap();
                                 this.parseFrom(((SQLSelectQueryBlock)where.getParent()).getFrom(), localMap, "", true);
                                 this.columnAddTableAlias(left, localMap);
                              }
                           } catch (SQLException var17) {
                              SQLException throwables = var17;
                              throwables.printStackTrace();
                           }

                           colValue = left.toString();
                           schema = right.toString();
                           value = (String)this.whereMap.get(colValue);
                           if (value == null) {
                              this.whereMap.put(colValue, schema);
                              this.putInWhereParams(left, colValue, schema);
                           } else if (!value.equalsIgnoreCase(schema)) {
                              this.whereMap.put(colValue, value + "," + schema);
                              this.putInWhereParams(left, colValue, value + "," + schema);
                           }
                        }
                     }
                  } else {
                     tableName = "";
                     colName = "";
                     colValue = "";
                     schema = "";
                     left = sqlExpr.getLeft();
                     right = sqlExpr.getRight();
                     if (!(left instanceof SQLIntegerExpr) && !(left instanceof SQLCharExpr) && !this.parseMethodInvokeExpr(left, right)) {
                        if (!(left instanceof SQLIdentifierExpr)) {
                           if (left instanceof SQLPropertyExpr) {
                              owner = ((SQLPropertyExpr)left).getOwner();
                              finalColName = ((SQLIdentifierExpr)owner).getName();
                              colName = ((SQLPropertyExpr)left).getName();
                              tableAlias = finalColName.toLowerCase();
                              tableName = (String)this.tableMap.get(finalColName.toLowerCase());
                              schema = (String)this.schemaMap.get(tableName);
                           }
                        } else {
                           colName = ((SQLIdentifierExpr)left).getName();
                           i$10 = this.tableMap.keySet().iterator();

                           while(i$10.hasNext()) {
                              finalColName = (String)i$10.next();
                              if (!finalColName.isEmpty()) {
                                 tableName = (String)this.tableMap.get(finalColName);
                              }
                           }

                           schema = (String)this.schemaMap.get(tableName);
                        }

                        if (right instanceof SQLCharExpr) {
                           colValue = ((SQLCharExpr)right).getText();
                        } else if (right instanceof SQLVariantRefExpr) {
                           colValue = right.toString();
                        } else if (right instanceof SQLIntegerExpr) {
                           colValue = right.toString();
                        }

                        if (tableName == null && tableAlias != null && this.tableList.containsKey(tableAlias)) {
                           List<Column> columns = (List)this.tableList.get(tableAlias);
                           finalColName = colName;
                           Column column = null;
                           Iterator i$12 = columns.iterator();

                           while(i$12.hasNext()) {
                              Column x = (Column)i$12.next();
                              if (x.getColumnName().equalsIgnoreCase(finalColName) || x.getColumnName().contains("." + finalColName)) {
                                 column = x;
                                 break;
                              }
                           }

                           if (column != null) {
                              String[] arr = column.getColumnName().split("\\.");
                              String alias = "";
                              if (arr.length == 2) {
                                 alias = arr[0];
                              } else if (arr.length == 3) {
                                 alias = arr[1];
                              }

                              if (alias != "") {
                                 tableName = (String)this.tableMap.get(alias.toLowerCase());
                                 schema = (String)this.schemaMap.get(tableName);
                              }
                           }
                        }

                        this.whereMap.put(schema + "." + tableName + "." + colName, colValue);
                        this.putInWhereParams(left, schema + "." + tableName + "." + colName, colValue);
                     }
                  }
               }
            } else if (where instanceof SQLExistsExpr) {
               SQLExistsExpr existsExpr = (SQLExistsExpr)where;
               SQLSelect sqlSelect = existsExpr.subQuery;
               SQLBinaryOpExpr curWhere = (SQLBinaryOpExpr)((SQLSelectQueryBlock)sqlSelect.getQuery()).getWhere();
               this.parseWhere(curWhere);
            } else if (where instanceof SQLInListExpr) {
               SQLInListExpr sqlInListExpr = (SQLInListExpr)where;
               tableName = "";
               String columnWithTable = "";
               if (this.isHaveOwner(sqlInListExpr)) {
                  SQLPropertyExpr expr = (SQLPropertyExpr)sqlInListExpr.getExpr();
                  SQLIdentifierExpr owner = (SQLIdentifierExpr)expr.getOwner();
                  schema = owner.getName();
                  tableName = (String)this.tableMap.get(schema);
                  value = (String)this.schemaMap.get(tableName);
                  columnWithTable = value + "." + tableName + "." + expr.getName();
               } else {
                  SQLObject parent;
                  for(parent = sqlInListExpr.getParent(); !(parent instanceof SQLSelectQueryBlock); parent = parent.getParent()) {
                  }

                  tableName = ((SQLPropertyExpr)((SQLExprTableSource)((SQLSelectQueryBlock)parent).getFrom()).getExpr()).getName();
                  colValue = (String)this.schemaMap.get(tableName);
                  tableName = colValue + "." + tableName;
                  columnWithTable = tableName + "." + ((SQLIdentifierExpr)sqlInListExpr.getExpr()).getName();
               }

               this.whereMap.put(columnWithTable, sqlInListExpr.getTargetList());
               this.putInWhereParams(sqlInListExpr, columnWithTable, sqlInListExpr.getTargetList());
            } else if (where instanceof SQLInSubQueryExpr) {
               SQLInSubQueryExpr subInQuery = (SQLInSubQueryExpr)where;
               this.parseSelect(subInQuery.getSubQuery());
            }

         }
      }
   }

   public void parseLimit(SQLLimit limit) {
      if (limit != null) {
         SQLExpr offset = limit.getOffset();
         SQLExpr rowCount = limit.getRowCount();
         if (offset != null) {
            this.putInWhereParams(offset, "a.b.limit1", offset.toString());
         }

         if (rowCount != null) {
            this.putInWhereParams(rowCount, "a.b.limit2", rowCount.toString());
         }

      }
   }

   private boolean parseMethodInvokeExpr(SQLExpr expr, SQLExpr right) {
      if (!(expr instanceof SQLMethodInvokeExpr)) {
         return false;
      } else {
         List<SQLExpr> params = ((SQLMethodInvokeExpr)expr).getParameters();
         String colValue = right.toString();
         if (params != null) {
            Iterator i$ = params.iterator();

            while(true) {
               SQLExpr param;
               String colName;
               String tableName;
               String schema;
               while(true) {
                  if (!i$.hasNext()) {
                     return true;
                  }

                  param = (SQLExpr)i$.next();
                  colName = "";
                  tableName = "";
                  schema = "";
                  String key;
                  if (!(param instanceof SQLIdentifierExpr)) {
                     if (param instanceof SQLPropertyExpr) {
                        SQLExpr owner = ((SQLPropertyExpr)param).getOwner();
                        key = ((SQLIdentifierExpr)owner).getName();
                        colName = ((SQLPropertyExpr)param).getName();
                        tableName = (String)this.tableMap.get(key);
                        schema = (String)this.schemaMap.get(tableName);
                        break;
                     }

                     if (param instanceof SQLCharExpr) {
                        continue;
                     }
                     break;
                  }

                  colName = ((SQLIdentifierExpr)param).getName();
                  Iterator i$13 = this.tableMap.keySet().iterator();

                  while(i$13.hasNext()) {
                     key = (String)i$13.next();
                     if (!key.isEmpty()) {
                        tableName = (String)this.tableMap.get(key);
                     }
                  }

                  schema = (String)this.schemaMap.get(tableName);
                  break;
               }

               this.whereMap.put(schema + "." + tableName + "." + colName, colValue);
               this.putInWhereParams(param, schema + "." + tableName + "." + colName, colValue);
            }
         } else {
            return true;
         }
      }
   }

   public String parseSelectStar(SQLSelectQueryBlock query) throws SQLException {
      String sql = query.toString();
      List<SQLSelectItem> fieldList = query.getSelectList();
      Iterator i$ = fieldList.iterator();

      while(true) {
         while(i$.hasNext()) {
            SQLSelectItem field = (SQLSelectItem)i$.next();
            String[] columns = field.getExpr().toString().trim().split("\\.");
            String alias = columns[0];
            String column = columns.length == 1 ? columns[0] : columns[1];
            Map<String, String> map = new HashMap();
            this.parseFrom(query.getFrom(), map, "", true);
            if ("*".equalsIgnoreCase(column)) {
               sql = this.columnReplaceStar(sql, alias, map);
            } else if (columns.length == 1) {
               List<Column> sqlExprList = new ArrayList();
               SQLExpr fieldExpr = field.getExpr();
               this.parseSQLExpr(fieldExpr, fieldExpr, sqlExprList, false);
               Iterator i$14 = sqlExprList.iterator();

               while(i$14.hasNext()) {
                  Column col = (Column)i$14.next();
                  this.columnAddTableAlias(col.getExpr(), map);
               }

               sql = query.toString();
            }
         }

         return sql;
      }
   }

   public void columnAddTableAlias(SQLExpr fieldExpr, Map<String, String> tableMap) throws SQLException {
      String column = fieldExpr.toString();
      if (!"*".equalsIgnoreCase(column)) {
         String url = (String)this.params.get("url");
         String schema = (String)this.params.get("schema");
         String ip_port = url.split("/")[2];
         SQLIdentifierExpr expr = (SQLIdentifierExpr)fieldExpr;
         String sql = fieldExpr.toString();
         Iterator i$ = this.tableList.keySet().iterator();

         while(true) {
            String key;
            do {
               if (!i$.hasNext()) {
                  i$ = this.unionTableMap.keySet().iterator();

                  String[] split;
                  String columnName;
                  String schema_temp;
                  String schema_real;
                  List tableColumns;
                  Column tableColumn;
                  while(i$.hasNext()) {
                     key = (String)i$.next();
                     schema_temp = (String)this.schemaMap.get(this.unionTableMap.get(key));
                     schema_real = schema_temp == null ? schema : schema_temp;
                     tableColumns = JdbcUtil.getTableColumns(ip_port, schema_real, (String)this.unionTableMap.get(key), key, this.tableList);
                     i$ = tableColumns.iterator();

                     while(i$.hasNext()) {
                        tableColumn = (Column)i$.next();
                        split = tableColumn.getColumnName().split("\\.");
                        if (split.length >= 2) {
                           columnName = split[1];
                           if (columnName.equalsIgnoreCase(column.replaceAll("[\"`]", ""))) {
                              sql = sql.replaceAll(column, key + "." + column);
                              expr.setName(sql);
                              return;
                           }
                        }
                     }
                  }

                  i$ = tableMap.keySet().iterator();

                  while(i$.hasNext()) {
                     key = (String)i$.next();
                     schema_temp = (String)this.schemaMap.get(tableMap.get(key));
                     schema_real = schema_temp == null ? schema : schema_temp;
                     tableColumns = JdbcUtil.getTableColumns(ip_port, schema_real, (String)tableMap.get(key), key, this.tableList);
                     i$ = tableColumns.iterator();

                     while(i$.hasNext()) {
                        tableColumn = (Column)i$.next();
                        split = tableColumn.getColumnName().split("\\.");
                        if (split.length >= 2) {
                           columnName = split[1];
                           if (columnName.equalsIgnoreCase(column.replaceAll("[\"`]", ""))) {
                              sql = sql.replaceAll(column, key + "." + column);
                              expr.setName(sql);
                              return;
                           }
                        }
                     }
                  }

                  return;
               }

               key = (String)i$.next();
            } while(!tableMap.containsKey(key));

            List<Column> tableColumns = (List)this.tableList.get(key);
            Iterator i$16 = tableColumns.iterator();

            while(i$16.hasNext()) {
               Column tableColumn = (Column)i$16.next();
               String[] split = tableColumn.getColumnName().split("\\.");
               if (split.length >= 2) {
                  String columnName = split[1];
                  if (columnName.equalsIgnoreCase(column.replaceAll("[\"`]", ""))) {
                     sql = sql.replaceAll(column, key + "." + column);
                     expr.setName(sql);
                     return;
                  }
               }
            }
         }
      }
   }

   public String columnReplaceStar(String sql, String alias, Map<String, String> tableMap) throws SQLException {
      String url = (String)this.params.get("url");
      String schema = (String)this.params.get("schema");
      String ip_port = url.split("/")[2];
      List<String> columns = new ArrayList();
      String column;
      if ("*".equalsIgnoreCase(alias)) {
         Set<String> keys = tableMap.keySet();
         Iterator i$ = keys.iterator();

         while(i$.hasNext()) {
            String key = (String)i$.next();
            column = (String)this.schemaMap.get(tableMap.get(key));
            String schema_real = column == null ? schema : column;
            List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema_real, (String)tableMap.get(key), key, this.tableList);
            List<String> colList = new ArrayList();

            for(int i = 0; i < tableColumns.size(); ++i) {
               Column col = (Column)tableColumns.get(i);
               String column2 = "";
               if (col.getColumnAlisa() != null) {
                  column2 = key + "." + col.getColumnAlisa();
               } else {
                  column2 = key + "." + col.getColumnName().split("\\.")[1];
               }

               colList.add(column2);
            }

            columns.addAll(colList);
         }

         if (columns.size() > 0) {
            sql = sql.replaceFirst("\\*", StringJoin.join(columns, ","));
         }
      } else if (tableMap.get(alias) != null) {
         List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema, (String)tableMap.get(alias), alias, this.tableList);

         for(int i = 0; i < tableColumns.size(); ++i) {
            Column col = (Column)tableColumns.get(i);
            column = "";
            if (col.getColumnAlisa() != null) {
               column = alias + "." + col.getColumnAlisa();
            } else {
               column = alias + "." + col.getColumnName().split("\\.")[1];
            }

            columns.add(column);
         }

         if (columns.size() > 0) {
            sql = sql.replaceFirst(alias + "\\.\\*", StringJoin.join(columns, ","));
         }
      }

      return sql;
   }

   public void parseQueryColumns(SQLSelectQueryBlock query, String alias) throws SQLException {
      List<SQLSelectItem> fieldList = query.getSelectList();
      boolean isSub = !"".equalsIgnoreCase(alias);
      List<Column> temp = new ArrayList();
      Iterator i$ = fieldList.iterator();

      while(true) {
         while(i$.hasNext()) {
            SQLSelectItem field = (SQLSelectItem)i$.next();
            SQLExpr fileExpr = field.getExpr();
            String className = fileExpr.getClass().toString();
            if (className.contains("SQLQueryExpr")) {
               String subQuery = this.parseSelect(this.dbType, field.getExpr().toString().replaceAll("\\(|\\)", ""));
               SQLSelectStatement stmt = (SQLSelectStatement)SQLUtils.parseStatements(subQuery, (String)this.params.get("dbType")).get(0);
               SQLSelect select = stmt.getSelect();
               SQLQueryExpr sqlQueryExpr = new SQLQueryExpr(select);
               field.setExpr(sqlQueryExpr);
            } else {
               List<Column> sqlExprList = new ArrayList();
               this.parseSQLExpr(fileExpr, fileExpr, sqlExprList, false);

               Column column;
               for(Iterator i$17 = sqlExprList.iterator(); i$17.hasNext(); temp.add(column)) {
                  Column col_obj = (Column)i$17.next();
                  SQLExpr sqlExpr = col_obj.getExpr();
                  String columnName = sqlExpr.toString();
                  column = new Column(columnName, field.getAlias(), isSub, alias);
                  column.setMethod(col_obj.isMethod());
                  column.setFullName(col_obj.getFullName());
                  String[] columns = column.getColumnName().split("\\.");
                  String c1 = columns[0];
                  String c2 = columns.length > 1 ? columns[1] : columns[0];
                  List<Column> list = (List)this.tableList.get(c1);
                  String s;
                  String colName;
                  String realName;
                  String own;
                  if (list != null) {
                     Iterator i$18 = list.iterator();

                     label76:
                     while(true) {
                        Column col;
                        do {
                           if (!i$18.hasNext()) {
                              break label76;
                           }

                           col = (Column)i$18.next();
                           s = col.getColumnName();
                        } while(!JdbcUtil.sqlRegex(s, c2) && !JdbcUtil.sqlRegex(col.getColumnAlisa(), c2));

                        if (!column.getFullName().trim().startsWith("count")) {
                           colName = column.getColumnName();
                           realName = "";
                           own = "";
                           String now = "";
                           if (s.split("\\.").length > 1) {
                              realName = s;
                              own = s.split("\\.")[0];
                              now = s.split("\\.")[0] + "." + colName.split("\\.")[1];
                           } else {
                              realName = s;
                              own = colName.split("\\.")[0];
                              now = colName;
                           }

                           column.setColumnName(realName);
                           column.setNowName(now);
                           column.setSubQuery(true);
                           column.setSubAlisa(c1);
                           String fieldClassName = sqlExpr.getClass().getName();
                           if (fieldClassName.contains("SQLPropertyExpr")) {
                              SQLPropertyExpr expr = (SQLPropertyExpr)sqlExpr;
                              SQLIdentifierExpr owner = (SQLIdentifierExpr)expr.getOwner();
                              owner.setName(own);
                           }
                           break;
                        }
                     }
                  }

                  if (columns.length > 1) {
                     String url = (String)this.params.get("url");
                     String schema = (String)this.params.get("schema");
                     s = (String)this.schemaMap.get(c1);
                     colName = s == null ? schema : s;
                     realName = url.split("/")[2];
                     own = JdbcUtil.getColumnDataType(realName, colName, (String)this.tableMap.get(c1), c1, c2);
                     column.setDataType(own);
                  }

                  if (!isSub && !column.getFullName().trim().startsWith("count")) {
                     this.columnList.add(column);
                  }
               }
            }
         }

         if (isSub) {
            this.tableList.put(alias, temp);
         }

         return;
      }
   }

   public void parseSQLExpr(SQLExpr oldFileExpr, SQLExpr fileExpr, List<Column> sqlExprList, boolean isMethod) {
      String className = fileExpr.getClass().toString();
      if (!JdbcUtil.sqlRegex(className, "SQLPropertyExpr|SQLIdentifierExpr")) {
         List items;
         Iterator i$;
         SQLExpr sqlExpr;
         String name;
         if (className.contains("SQLAggregateExpr")) {
            SQLAggregateExpr expr = (SQLAggregateExpr)fileExpr;
            items = expr.getArguments();
            i$ = items.iterator();

            while(i$.hasNext()) {
               sqlExpr = (SQLExpr)i$.next();
               name = sqlExpr.getClass().getName();
               if (!name.contains("SQLCharExpr")) {
                  this.parseSQLExpr(oldFileExpr, sqlExpr, sqlExprList, true);
               }
            }
         } else if (className.contains("SQLMethodInvokeExpr")) {
            SQLMethodInvokeExpr expr = (SQLMethodInvokeExpr)fileExpr;
            items = expr.getArguments();
            i$ = items.iterator();

            while(i$.hasNext()) {
               sqlExpr = (SQLExpr)i$.next();
               name = sqlExpr.getClass().getName();
               if (!name.contains("SQLCharExpr")) {
                  this.parseSQLExpr(oldFileExpr, sqlExpr, sqlExprList, true);
               }
            }
         } else if (className.contains("SQLBinaryOpExpr")) {
            SQLBinaryOpExpr expr = (SQLBinaryOpExpr)fileExpr;
            SQLExpr left = expr.getLeft();
            SQLExpr right = expr.getRight();
            this.parseSQLExpr(oldFileExpr, left, sqlExprList, true);
            this.parseSQLExpr(oldFileExpr, right, sqlExprList, true);
         } else if (className.contains("SQLCaseExpr")) {
            SQLCaseExpr expr = (SQLCaseExpr)fileExpr;
            items = expr.getItems();
            i$ = items.iterator();

            while(i$.hasNext()) {
               SQLCaseExpr.Item item = (SQLCaseExpr.Item)i$.next();
               this.parseSQLExpr(oldFileExpr, item.getConditionExpr(), sqlExprList, true);
            }
         } else if (className.contains("SQLBetweenExpr")) {
            SQLBetweenExpr expr = (SQLBetweenExpr)fileExpr;
            this.parseSQLExpr(oldFileExpr, expr.getTestExpr(), sqlExprList, true);
         }
      } else {
         Column column = new Column(isMethod, fileExpr);
         column.setFullName(oldFileExpr.toString());
         sqlExprList.add(column);
      }

   }

   public SQLInsertStatement parseInsert(String dbType, String sql) throws SQLException {
      SQLInsertStatement insert = this.aliParseInsert(dbType, sql);
      this.parseInsertColumns(insert);
      return insert;
   }

   public SQLInsertStatement aliParseInsert(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLInsertStatement stmt = (SQLInsertStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseInsertColumns(SQLInsertStatement insert) throws SQLException {
      String url = (String)this.params.get("url");
      String schema = (String)this.params.get("schema");
      SQLName tableExpr = insert.getTableName();
      if (tableExpr instanceof SQLPropertyExpr) {
         SQLPropertyExpr propExpr = (SQLPropertyExpr)tableExpr;
         schema = propExpr.getOwnerName();
      }

      String tableName = insert.getTableName().getSimpleName();
      String className = insert.getTableName().getClass().getName();
      if (className.contains("SQLIdentifierExpr")) {
         SQLPropertyExpr expr = new SQLPropertyExpr();
         expr.setName(tableName);
         expr.setOwner(schema);
         insert.setTableName(expr);
      }

      List<SQLExpr> columns = insert.getColumns();
      String parseSql;
      Column col;
      if (columns.size() == 0) {
         String schema_temp = (String)this.schemaMap.get(tableName);
         String schema_real = schema_temp == null ? schema : schema_temp;
         parseSql = url.split("/")[2];
         List<Column> tableColumns = JdbcUtil.getTableColumns(parseSql, schema_real, tableName, "", this.tableList);
         Iterator i$ = tableColumns.iterator();

         while(i$.hasNext()) {
            Column tableColumn = (Column)i$.next();
            SQLIdentifierExpr sqlIdentifierExpr = new SQLIdentifierExpr();
            sqlIdentifierExpr.setName(tableColumn.getColumnName());
            columns.add(sqlIdentifierExpr);
            Column column = new Column();
            column.setColumnName(tableName + "." + tableColumn.getColumnName());
            this.columnList.add(column);
         }
      } else {
         for(Iterator i$ = columns.iterator(); i$.hasNext(); this.columnList.add(col)) {
            SQLExpr column = (SQLExpr)i$.next();
            col = new Column();
            String name = column.getClass().getName();
            String colname = "";
            if (name.contains("SQLIdentifierExpr")) {
               col.setColumnName(tableName + "." + column.toString());
            } else if (column instanceof SQLPropertyExpr) {
               SQLPropertyExpr prop = (SQLPropertyExpr)column;
               tableName = prop.getOwnerName();
               col.setColumnName(column.toString());
            } else {
               col.setColumnName(column.toString());
            }
         }
      }

      this.tableMap.put(tableName, tableName);
      List<SQLInsertStatement.ValuesClause> valuesList = insert.getValuesList();
      if (valuesList.size() == 0) {
         SQLSelectQueryBlock query = (SQLSelectQueryBlock)insert.getQuery().getQuery();
         parseSql = this.parseSelect(this.dbType, query.toString());
         SQLSelectQueryBlock sqlSelectQueryBlock = this.aliParseSelect(this.dbType, parseSql, true);
         insert.getQuery().setQuery(sqlSelectQueryBlock);
      }

      this.schemaMap.put(tableName, schema);
   }

   public SQLUpdateStatement parseUpdate(String dbType, String sql) throws SQLException {
      SQLUpdateStatement update = this.aliParseUpdate(dbType, sql);
      this.parseUpdateColumns(update);
      return update;
   }

   public SQLUpdateStatement aliParseUpdate(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLUpdateStatement stmt = (SQLUpdateStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseUpdateColumns(SQLUpdateStatement update) throws SQLException {
      String tableName = update.getTableName().getSimpleName();
      SQLExprTableSource tableExpr = (SQLExprTableSource)update.getTableSource();
      SQLExpr expr1 = tableExpr.getExpr();
      String schema = (String)this.params.get("schema");
      if (expr1 instanceof SQLIdentifierExpr) {
         SQLPropertyExpr expr = new SQLPropertyExpr();
         expr.setName(tableName);
         expr.setOwner(schema);
         tableExpr.setExpr(expr);
      } else if (expr1 instanceof SQLPropertyExpr) {
         schema = ((SQLPropertyExpr)expr1).getOwnerName();
      }

      this.schemaMap.put(tableName, schema);
      String alias = update.getTableSource().getAlias();
      String name = alias == null ? tableName : alias;
      List<SQLUpdateSetItem> items = update.getItems();
      Iterator i$ = items.iterator();

      while(i$.hasNext()) {
         SQLUpdateSetItem item = (SQLUpdateSetItem)i$.next();
         String className = item.getColumn().getClass().getName();
         String colName = "";
         String colValue = "";
         if (className.contains("SQLPropertyExpr")) {
            SQLPropertyExpr column = (SQLPropertyExpr)item.getColumn();
            colName = column.getName();
            colValue = ((SQLUpdateSetItem)column.getParent()).getValue().toString();
         } else if (className.contains("SQLIdentifierExpr")) {
            SQLIdentifierExpr column = (SQLIdentifierExpr)item.getColumn();
            colName = column.getName();
            colValue = ((SQLUpdateSetItem)column.getParent()).getValue().toString();
         }

         Column col = new Column();
         col.setColumnName(name + "." + colName);
         col.setValue(colValue);
         this.columnList.add(col);
      }

      this.tableMap.put(name, tableName);
      this.parseWhere(update.getWhere());
   }

   public SQLDeleteStatement parseDelete(String dbType, String sql) throws SQLException {
      SQLDeleteStatement delete = this.aliParseDelete(dbType, sql);
      this.parseDeleteColumns(delete);
      return delete;
   }

   public SQLDeleteStatement aliParseDelete(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLDeleteStatement stmt = (SQLDeleteStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseDeleteColumns(SQLDeleteStatement delete) throws SQLException {
      String schema = (String)this.params.get("schema");
      String url = (String)this.params.get("url");
      String ip_port = url.split("/")[2];
      String tableName = delete.getTableName().getSimpleName();
      SQLExprTableSource tableExpr = (SQLExprTableSource)delete.getTableSource();
      SQLExpr expr1 = tableExpr.getExpr();
      if (expr1 instanceof SQLIdentifierExpr) {
         SQLPropertyExpr expr = new SQLPropertyExpr();
         expr.setName(tableName);
         expr.setOwner(schema);
         tableExpr.setExpr(expr);
      } else if (expr1 instanceof SQLPropertyExpr) {
         schema = ((SQLPropertyExpr)expr1).getOwnerName();
      }

      this.tableMap.put(tableName, tableName);
      this.schemaMap.put(tableName, schema);
      List<Column> tableColumns = JdbcUtil.getTableColumns(ip_port, schema, tableName, tableName, this.tableList);
      Iterator i$ = tableColumns.iterator();

      while(i$.hasNext()) {
         Column tableColumn = (Column)i$.next();
         Column column = new Column();
         column.setColumnName(tableColumn.getColumnName());
         this.columnList.add(column);
      }

      this.parseWhere(delete.getWhere());
   }

   public SQLTruncateStatement parseTruncate(String dbType, String sql) throws SQLException {
      SQLTruncateStatement truncate = this.aliParseTruncate(dbType, sql);
      this.parseTruncateColumns(truncate);
      return truncate;
   }

   public SQLTruncateStatement aliParseTruncate(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLTruncateStatement stmt = (SQLTruncateStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseTruncateColumns(SQLTruncateStatement truncate) {
      List<SQLExprTableSource> tableList = truncate.getTableSources();
      Iterator i$ = tableList.iterator();

      while(i$.hasNext()) {
         SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)i$.next();
         String tableName = sqlExprTableSource.getName().getSimpleName();
         this.tableMap.put(tableName, tableName);
      }

   }

   public SQLCreateStatement parseCreate(String dbType, String sql) throws SQLException {
      SQLCreateStatement create = this.aliParseCreate(dbType, sql);
      this.parseCreateColumns(create);
      return create;
   }

   public SQLCreateStatement aliParseCreate(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLCreateStatement stmt = (SQLCreateStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseCreateColumns(SQLCreateStatement create) throws SQLException {
      String schema = (String)this.params.get("schema");
      String name = create.getClass().getName();
      String tableName = "";
      String simpleName;
      if (name.contains("SQLCreateTableStatement")) {
         SQLCreateTableStatement createTable = (SQLCreateTableStatement)create;
         tableName = createTable.getTableName();
         simpleName = createTable.getTableSource().getName().getClass().getName();
         if (simpleName.contains("SQLIdentifierExpr")) {
            SQLPropertyExpr expr = new SQLPropertyExpr();
            expr.setName(tableName);
            expr.setOwner(schema);
            createTable.getTableSource().setExpr(expr);
         }

         List<SQLTableElement> tableElementList = createTable.getTableElementList();
         if (tableElementList.size() == 0) {
            SQLSelect subQuery = createTable.getSelect();
            this.params.put("sql", subQuery.toString());
            this.parseSqlStructure(new HashMap());
         } else {
            Iterator i$ = tableElementList.iterator();

            while(i$.hasNext()) {
               SQLTableElement sqlTableElement = (SQLTableElement)i$.next();
               String className = sqlTableElement.getClass().getName();
               if (className.contains("SQLColumnDefinition")) {
                  SQLColumnDefinition col = (SQLColumnDefinition)sqlTableElement;
                  String columnName = col.getColumnName();
                  Column column = new Column();
                  column.setColumnName(tableName + "." + columnName);
                  this.columnList.add(column);
               }
            }
         }

         this.tableMap.put(tableName, tableName);
      } else if (name.contains("SQLCreateViewStatement")) {
         SQLCreateViewStatement createView = (SQLCreateViewStatement)create;
         simpleName = createView.getName().getSimpleName();
         SQLSelect subQuery = createView.getSubQuery();
         this.params.put("sql", subQuery.toString());
         this.parseSqlStructure(new HashMap());
         this.tableMap.put(simpleName, simpleName);
      }

      this.schemaMap.put(tableName, schema);
   }

   public SQLAlterTableStatement parseAlter(String dbType, String sql) throws SQLException {
      SQLAlterTableStatement alter = this.aliParseAlter(dbType, sql);
      this.parseAlterColumns(alter);
      return alter;
   }

   public SQLAlterTableStatement aliParseAlter(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLAlterTableStatement stmt = (SQLAlterTableStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseAlterColumns(SQLAlterTableStatement alter) {
      String tableName = alter.getTableName();
      List<SQLAlterTableItem> items = alter.getItems();
      Iterator i$ = items.iterator();

      while(true) {
         while(i$.hasNext()) {
            SQLAlterTableItem item = (SQLAlterTableItem)i$.next();
            String className = item.getClass().getName();
            List columns;
            Iterator i$19;
            String columnName;
            Column col;
            if (className.contains("SQLAlterTableAddColumn")) {
               SQLAlterTableAddColumn alterColumn = (SQLAlterTableAddColumn)item;
               columns = alterColumn.getColumns();
               i$19 = columns.iterator();

               while(i$19.hasNext()) {
                  SQLColumnDefinition column = (SQLColumnDefinition)i$19.next();
                  columnName = column.getColumnName();
                  col = new Column();
                  col.setColumnName(tableName + "." + columnName);
                  this.columnList.add(col);
               }
            } else if (className.contains("SQLAlterTableDropColumnItem")) {
               SQLAlterTableDropColumnItem alterColumn = (SQLAlterTableDropColumnItem)item;
               columns = alterColumn.getColumns();
               i$19 = columns.iterator();

               while(i$19.hasNext()) {
                  SQLName column = (SQLName)i$19.next();
                  columnName = column.getSimpleName();
                  col = new Column();
                  col.setColumnName(tableName + "." + columnName);
                  this.columnList.add(col);
               }
            }
         }

         this.tableMap.put(tableName, tableName);
         return;
      }
   }

   public String parseUnion(String dbType, String sql) throws SQLException {
      StringBuilder result = new StringBuilder();
      SQLUnionQuery query = this.aliParseUnion(dbType, sql);
      this.dealUnion(query, result);
      return result.toString();
   }

   public SQLUnionQuery aliParseUnion(String dbType, String sql) throws SQLException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
         SQLSelect select = stmt.getSelect();
         SQLUnionQuery query = (SQLUnionQuery)select.getQuery();
         return query;
      }
   }

   public void dealUnion(SQLUnionQuery unionQuery, StringBuilder result) throws SQLException {
      List<SQLSelectQuery> queryList = unionQuery.getRelations();

      for(int i = 0; i < queryList.size(); ++i) {
         SQLSelectQuery selectQuery = (SQLSelectQuery)queryList.get(i);
         String sql = "";
         String className = selectQuery.getClass().getName();
         if (className.contains("SQLUnionQuery")) {
            SQLUnionQuery unQuery = (SQLUnionQuery)selectQuery;
            this.dealUnion(unQuery, result);
         } else {
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
            this.parseFrom(query.getFrom(), (Map)null, "", true);
            this.parseFrom(query.getFrom(), (Map)null, "", false);
            sql = this.parseSelectStar(query);
            query = this.aliParseSelect(this.dbType, sql, true);
            this.parseQueryColumns(query, "");
            sql = this.parseSelectStar(query);
            result.append(sql);
         }

         if (i == 0) {
            result.append("\n" + unionQuery.getOperator().toString() + "\n");
         }
      }

   }

   public SQLDropTableStatement parseDrop(String dbType, String sql) throws SQLException {
      SQLDropTableStatement drop = this.aliParseDrop(dbType, sql);
      this.parseDropColumns(drop);
      return drop;
   }

   public SQLDropTableStatement aliParseDrop(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLDropTableStatement stmt = (SQLDropTableStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseDropColumns(SQLDropTableStatement drop) {
      List<SQLExprTableSource> tableSources = drop.getTableSources();
      Iterator i$ = tableSources.iterator();

      while(i$.hasNext()) {
         SQLExprTableSource tableSource = (SQLExprTableSource)i$.next();
         String tableName = tableSource.getName().getSimpleName();
         this.tableMap.put(tableName, tableName);
      }

   }

   public SQLGrantStatement parseGrant(String dbType, String sql) throws SQLException {
      SQLGrantStatement grant = this.aliParseGrant(dbType, sql);
      this.parseGrantColumns(grant);
      return grant;
   }

   public SQLGrantStatement aliParseGrant(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLGrantStatement stmt = (SQLGrantStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseGrantColumns(SQLGrantStatement grant) {
      String url = (String)this.params.get("url");
      String ip_port = url.split("/")[2];
      SQLExprTableSource resource = (SQLExprTableSource)grant.getResource();
      SQLPropertyExpr expr = (SQLPropertyExpr)resource.getExpr();
      String name = expr.getName();
      String owner = expr.getOwner().toString();
      Iterator i$;
      DataBase dataBase;
      List schemaList;

      Schema schema;
      List tableList;

      Table table;
      if ("*".equalsIgnoreCase(owner)) {
         i$ = JdbcUtil.dataBaseList.iterator();

         while(true) {
            do {
               if (!i$.hasNext()) {
                  return;
               }

               dataBase = (DataBase)i$.next();
            } while(!dataBase.getIp_port().equalsIgnoreCase(ip_port));

            schemaList = dataBase.getSchemaList();
            i$ = schemaList.iterator();

            while(i$.hasNext()) {
               schema = (Schema)i$.next();
               tableList = schema.getTableList();
               i$ = tableList.iterator();

               while(i$.hasNext()) {
                  table = (Table)i$.next();
                  this.schemaMap.put(table.getName(), schema.getName());
                  this.tableMap.put(table.getName(), table.getName());
               }
            }
         }
      } else if ("*".equalsIgnoreCase(name)) {
         i$ = JdbcUtil.dataBaseList.iterator();

         label55:
         while(true) {
            do {
               if (!i$.hasNext()) {
                  return;
               }

               dataBase = (DataBase)i$.next();
            } while(!dataBase.getIp_port().equalsIgnoreCase(ip_port));

            schemaList = dataBase.getSchemaList();
            i$ = schemaList.iterator();

            while(true) {
               do {
                  if (!i$.hasNext()) {
                     continue label55;
                  }

                  schema = (Schema)i$.next();
               } while(!schema.getName().equalsIgnoreCase(owner));

               tableList = schema.getTableList();
               i$ = tableList.iterator();

               while(i$.hasNext()) {
                  table = (Table)i$.next();
                  this.schemaMap.put(table.getName(), owner);
                  this.tableMap.put(table.getName(), table.getName());
               }
            }
         }
      } else {
         this.schemaMap.put(name, owner);
         this.tableMap.put(name, name);
      }
   }

   public SQLRevokeStatement parseRevoke(String dbType, String sql) throws SQLException {
      SQLRevokeStatement revoke = this.aliParseRevoke(dbType, sql);
      this.parseRevokeColumns(revoke);
      return revoke;
   }

   public SQLRevokeStatement aliParseRevoke(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLRevokeStatement stmt = (SQLRevokeStatement)stmtList.get(0);
         return stmt;
      }
   }

   public void parseRevokeColumns(SQLRevokeStatement revoke) {
      String url = (String)this.params.get("url");
      String ip_port = url.split("/")[2];
      SQLExprTableSource resource = (SQLExprTableSource)revoke.getResource();
      SQLPropertyExpr expr = (SQLPropertyExpr)resource.getExpr();
      String name = expr.getName();
      String owner = expr.getOwner().toString();

      DataBase dataBase;
      List schemaList;

      Schema schema;
      List tableList;
      Iterator i$;
      Table table;
      if ("*".equalsIgnoreCase(owner)) {
         i$ = JdbcUtil.dataBaseList.iterator();

         while(true) {
            do {
               if (!i$.hasNext()) {
                  return;
               }

               dataBase = (DataBase)i$.next();
            } while(!dataBase.getIp_port().equalsIgnoreCase(ip_port));

            schemaList = dataBase.getSchemaList();
            i$ = schemaList.iterator();

            while(i$.hasNext()) {
               schema = (Schema)i$.next();
               tableList = schema.getTableList();
               i$ = tableList.iterator();

               while(i$.hasNext()) {
                  table = (Table)i$.next();
                  this.schemaMap.put(table.getName(), schema.getName());
                  this.tableMap.put(table.getName(), table.getName());
               }
            }
         }
      } else if ("*".equalsIgnoreCase(name)) {
         i$ = JdbcUtil.dataBaseList.iterator();

         label55:
         while(true) {
            do {
               if (!i$.hasNext()) {
                  return;
               }

               dataBase = (DataBase)i$.next();
            } while(!dataBase.getIp_port().equalsIgnoreCase(ip_port));

            schemaList = dataBase.getSchemaList();
            i$ = schemaList.iterator();

            while(true) {
               do {
                  if (!i$.hasNext()) {
                     continue label55;
                  }

                  schema = (Schema)i$.next();
               } while(!schema.getName().equalsIgnoreCase(owner));

               tableList = schema.getTableList();
               i$ = tableList.iterator();

               while(i$.hasNext()) {
                  table = (Table)i$.next();
                  this.schemaMap.put(table.getName(), owner);
                  this.tableMap.put(table.getName(), table.getName());
               }
            }
         }
      } else {
         this.schemaMap.put(name, owner);
         this.tableMap.put(name, name);
      }
   }

   public Map<String, String> pareAndReplace(SQLTableSource from, Map<String, String> map, String subTableAlias, Map repalceMap) throws SQLException {
      String className = from.getClass().getName();
      String tableName;
      String sql;
      if (className.contains("SQLExprTableSource")) {
         SQLExprTableSource fromContent = (SQLExprTableSource)from;
         tableName = fromContent.getExpr().toString();
         String tableAlisa = fromContent.getAlias();
         sql = fromContent.getExpr().getClass().getName();
         String name;
         String realTable;
         if (sql.contains("SQLPropertyExpr")) {
            SQLPropertyExpr expr = (SQLPropertyExpr)fromContent.getExpr();
            tableName = expr.getName();
            name = expr.getOwner().toString();
            this.schemaMap.put(tableName, name);
         } else {
            realTable = (String)this.params.get("schema");
            SQLIdentifierExpr expr = (SQLIdentifierExpr)fromContent.getExpr();
            SQLPropertyExpr pExpr = new SQLPropertyExpr();
            pExpr.setName(expr.getName());
            pExpr.setOwner(realTable);
            fromContent.setExpr(pExpr);
            this.schemaMap.put(tableName, realTable);
         }

         tableAlisa = tableAlisa == null ? tableName : tableAlisa;
         if (map == null) {
            this.tableMap.put(tableAlisa, tableName);
            realTable = (String)this.tableMap.get(subTableAlias);
            if (realTable == null) {
               this.tableMap.put(subTableAlias, tableName);
            } else if (!realTable.equalsIgnoreCase(subTableAlias)) {
               this.tableMap.put(subTableAlias, realTable + "." + tableName);
            }

            name = fromContent.getParent().getClass().getName().toLowerCase();
            if (name.contains("SQLSelectQueryBlock".toLowerCase())) {
               this.parseWhere(((SQLSelectQueryBlock)from.getParent()).getWhere());
               SQLSelectGroupByClause groupBy = ((SQLSelectQueryBlock)from.getParent()).getGroupBy();
               if (groupBy != null) {
                  this.parseHaving(((SQLSelectQueryBlock)from.getParent()).getGroupBy().getHaving());
               }
            } else if (name.contains("SQLJoinTableSource".toLowerCase())) {
               this.parseWhere(((SQLJoinTableSource)from.getParent()).getCondition());
            }
         } else {
            map.put(tableAlisa, tableName);
         }
      } else if (className.contains("SQLJoinTableSource")) {
         SQLJoinTableSource fromContent = (SQLJoinTableSource)from;
         SQLTableSource left = fromContent.getLeft();
         this.pareAndReplace(left, map, "", repalceMap);
         SQLTableSource right = fromContent.getRight();
         this.pareAndReplace(right, map, "", repalceMap);
      } else if (className.contains("SQLUnionQueryTableSource")) {
         SQLUnionQueryTableSource fromContent = (SQLUnionQueryTableSource)from;
         tableName = fromContent.getAlias();
         SQLUnionQuery union = fromContent.getUnion();
         List<SQLSelectQueryBlock> unionList = new ArrayList();
         this.parseUnionFrom(union, unionList);
         this.paresUnionFromSql(unionList, tableName, false);
         if (map == null) {
            this.tableMap.put(tableName, tableName);
         } else {
            map.put(tableName, tableName);
         }
      } else if (className.contains("SQLSubqueryTableSource")) {
         SQLSubqueryTableSource fromContent = (SQLSubqueryTableSource)from;
         SQLSelect select = fromContent.getSelect();
         if (map == null) {
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)select.getQuery();
            this.parseFrom(query.getFrom(), map, fromContent.getAlias(), true);
            sql = this.parseSelectStar(query);
            SQLSelectQueryBlock subQuery = this.aliParseSelect(this.dbType, sql, false);
            this.parseQueryColumns(subQuery, fromContent.getAlias());
            if (!"".equalsIgnoreCase(subTableAlias)) {
               this.tableMap.put(subTableAlias, fromContent.getAlias());
            }

            this.parseWhere(query.getWhere());
         } else {
            map.put(fromContent.getAlias(), fromContent.getAlias());
         }
      }

      return this.tableMap;
   }

   public void parseSqlStructureAndReplace2(Map<String, Object> paramMap, List<Map> repalceMap) throws SQLException {
      String sql = (String)this.params.get("sql");
      String dbType = (String)this.params.get("dbType");
      String sqlType = JdbcUtil.getSqlType(sql, dbType);
      if ("with_select".equals(sqlType) || "select".equals(sqlType) || "union".equals(sqlType) || "update".equals(sqlType) || "insert".equals(sqlType) || "insert_select".equals(sqlType) || "delete".equals(sqlType)) {
         String permission = (String)this.params.get("permission");
         String url = (String)this.params.get("url");
         String schema = (String)this.params.get("schema");
         String ip_port = url.split("/")[2];
         SQLParser sqlParser = new SQLParser();
         DataBase dataBase = new DataBase();
         Iterator i$ = JdbcUtil.dataBaseList.iterator();

         while(i$.hasNext()) {
            DataBase db = (DataBase)i$.next();
            if (ip_port.equalsIgnoreCase(db.getIp_port())) {
               dataBase = db;
               break;
            }
         }

         SQLResult parse = sqlParser.parse(sql, dataBase, schema);
         List<FieldInfo> columnlist = new ArrayList();
         if ("masking".equalsIgnoreCase(permission)) {
            columnlist = parse.outputs;
         } else if ("full".equalsIgnoreCase(permission)) {
            columnlist = parse.fields;
         } else if (!"insert".equalsIgnoreCase(sqlType) && !"update".equalsIgnoreCase(sqlType)) {
            columnlist = parse.outputs;
         }

         Iterator i$20 = ((List)columnlist).iterator();

         while(i$20.hasNext()) {
            FieldInfo fieldInfo = (FieldInfo)i$20.next();
            List<FieldInfo> fieldInfoList = new ArrayList();
            if (fieldInfo.getRelations().size() > 1) {
               fieldInfoList = fieldInfo.getRelations();
            } else {
               ((List)fieldInfoList).add(fieldInfo);
            }

            Iterator i$21 = ((List)fieldInfoList).iterator();

            while(i$21.hasNext()) {
               FieldInfo info = (FieldInfo)i$21.next();
               String name = info.getName();
               Map<String, TableInfo> tables = info.getTables();
               String tableName = "";

               String s;
               for(Iterator i$23 = tables.keySet().iterator(); i$23.hasNext(); tableName = s.split("\\.")[1]) {
                  s = (String)i$23.next();
               }

               Column column = new Column();
               column.setColumnName(tableName + "." + name);
               column.setColumnAlisa(info.getAlias() != null && !"".equals(info.getAlias()) ? info.getAlias().replaceAll("\"", "") : "");
               column.setSubQuery(false);
               this.columnList.add(column);
            }
         }

         i$20 = parse.tables.iterator();

         while(i$20.hasNext()) {
            TableInfo table = (TableInfo)i$20.next();
            TableMemo tb = table.getTable();
            this.tableMap.put(tb.name, tb.name);
            this.schemaMap.put(tb.name, tb.schema);
         }

         i$20 = parse.values.iterator();

         while(i$20.hasNext()) {
            ValueInfo value = (ValueInfo)i$20.next();
            FieldMemo field = value.field;
            this.whereMap.put(field.name, value.value.toString());
            Map<String, Object> map = new HashMap();
            map.put("column", field.getAtomName());
            map.put("columnValue", value.value.toString());
            map.put("type", value.operator);
            this.whereList.add(map);
         }

         sqlParser.replace(parse.values, repalceMap);
         paramMap.put("whereList", this.whereList);
         paramMap.put("statement", parse.statement);
         paramMap.put("type", parse.sqlType.name().toLowerCase());
         paramMap.put("sql", parse.statement.toString());
      }

      paramMap.put("whereMap", this.whereMap);
      paramMap.put("tableMap", this.tableMap);
      paramMap.put("columnList", this.columnList);
      paramMap.put("schemaMap", this.schemaMap);
      paramMap.put("whereMap", this.whereMap);
      paramMap.put("whereList", this.whereList);
   }

   public List<String> parseWheres(String sql) {
      SQLParser parser = new SQLParser();
      return parser.where(sql);
   }

   public String formatSQL(String sql) {
      SQLParser parser = new SQLParser();
      return parser.format(sql);
   }

   public Scope getScope(String ip_port, String schema, List<SQLStatement> statements) {
      Context context = new Context();
      DataBase dataBase = new DataBase();
      Iterator i$ = JdbcUtil.dataBaseList.iterator();

      while(i$.hasNext()) {
         DataBase db = (DataBase)i$.next();
         if (ip_port.equalsIgnoreCase(db.getIp_port())) {
            dataBase = db;
            break;
         }
      }

      context.initialize(dataBase, schema, this.dbType);
      Scope scope = new Scope();
      scope.dialector = new PostgresqlScopeDialector(scope);
      scope.context = context;
      scope.isCheckIsolated = true;
      ScopeVisitor scopeVisitor = new ScopeVisitor(scope);
      scopeVisitor.perform(statements);
      FieldVisitor fieldVisitor = new FieldVisitor(scope);
      fieldVisitor.perform(statements);
      return scope;
   }
}