package util.sqlparse.visitor.common.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import util.StringJoin;
import util.sqlparse.visitor.common.ScopeDialector;
import util.sqlparse.visitor.common.memo.FieldMemo;

public class FieldInfo {
   private Map<String, TableInfo> tables = new HashMap();
   private List<FieldInfo> relations = new ArrayList();
   private String name;
   private String alias;
   private FieldMemo memo;
   private String fullName;
   private List<FieldMemo> memos = new ArrayList();
   public int seq = -1;
   private Set<Integer> fieldIds = new HashSet();

   public Map<String, TableInfo> getTables() {
      return this.tables;
   }

   public void setTables(Map<String, TableInfo> table) {
      this.tables = table;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public Set<String> getAtomName() {
      Set<String> set = new HashSet();

      for(Map.Entry<String, TableInfo> e : this.tables.entrySet()) {
         TableInfo table = (TableInfo)e.getValue();
         set.add(table.getAtomName() + "." + this.name);
      }

      return set;
   }

   public String fullPathName(ScopeDialector dialector) {
      String tNames = "";
      List<String> pathList = new ArrayList();
      List<TableInfo> values = (List)this.tables.values();

      for(int i = 0; i < values.size(); ++i) {
         TableInfo tableInfo = (TableInfo)values.get(i);
         if (tableInfo != null) {
            pathList.add(tableInfo.fullPath(dialector));
         }
      }

      Collections.sort(pathList, Collections.reverseOrder());
      tNames = StringJoin.join(pathList, ":");
      return tNames + "." + dialector.wrap(this.name);
   }

   public String getAlias() {
      return this.alias;
   }

   public void setAlias(String alias) {
      this.alias = alias;
   }

   public String getFullName() {
      return this.fullName;
   }

   public void setFullName(String fullName) {
      this.fullName = fullName;
   }

   public List<FieldInfo> getRelations() {
      return this.relations;
   }

   public void setRelations(List<FieldInfo> relations) {
      this.relations = relations;
   }

   public FieldMemo getMemo() {
      return this.memo;
   }

   public void setMemo(FieldMemo memo) {
      this.memo = memo;
   }

   public List<FieldMemo> getMemos() {
      return this.memos;
   }

   public void addMemo(FieldMemo memo) {
      if (memo != null) {
         if (this.memos == null) {
            this.memos = new ArrayList();
            this.memos.add(memo);
         } else {
            this.memos.add(memo);
         }
      }
   }

   public int getSeq() {
      return this.seq;
   }

   public void setSeq(int seq) {
      this.seq = seq;
   }

   public Set<Integer> getFieldIds() {
      return this.fieldIds;
   }

   public void setFieldIds(Set<Integer> fieldIds) {
      this.fieldIds = fieldIds;
   }
}
