package util.sqlparse.visitor.common.scope;

import com.chenyang.druid.DbType;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLParseUtils {
    public SQLParseUtils() {
    }

    public static void getAtomTables(DbType dbType, FieldMemo field, List<TableMemo> tables, Map<String, TableInfo> tableMap, Map<String, TableInfo> atomTableMap) {
        if (tables != null && tables.size() != 0) {
            boolean common = false;
            switch (dbType) {
                default:
                    common = true;
                    if (common) {
                        Iterator i$ = tables.iterator();

                        while(i$.hasNext()) {
                            TableMemo table = (TableMemo)i$.next();
                            if (table.getChildren().size() == 0) {
                                TableInfo tableInfo = (TableInfo)tableMap.get(table.getAtomName());
                                if (tableInfo != null) {
                                    atomTableMap.put(tableInfo.getAtomName(), tableInfo);
                                }
                            }
                        }

                        getTables(field, field.scope, tableMap, atomTableMap);
                    }

            }
        }
    }

    static void getTables(FieldMemo field, Scope scope, Map<String, TableInfo> tableMap, Map<String, TableInfo> atomTableMap) {
        String name = field.name;
        Iterator i$ = scope.getChildren().iterator();

        while(true) {
            Scope child;
            label55:
            while(true) {
                if (!i$.hasNext()) {
                    return;
                }

                child = (Scope)i$.next();
                List<FieldMemo> childFieldMap = child.getFieldMap().orderValues();
                if (childFieldMap.isEmpty()) {
                    break;
                }

                FieldMemo fieldMemo = null;
                Iterator i$3 = childFieldMap.iterator();

                while(i$3.hasNext()) {
                    FieldMemo item = (FieldMemo)i$3.next();
                    if (item.name != null && item.alias != null && item.alias.equalsIgnoreCase(name)) {
                        fieldMemo = item;
                        break;
                    }
                }

                if (fieldMemo != null && !fieldMemo.tables.isEmpty() && fieldMemo.isSelectItem) {
                    i$3 = fieldMemo.tables.iterator();

                    while(true) {
                        if (!i$3.hasNext()) {
                            break label55;
                        }

                        TableMemo table = (TableMemo)i$3.next();
                        TableInfo tableInfo = (TableInfo)tableMap.get(table.getAtomName());
                        if (tableInfo != null) {
                            atomTableMap.put(tableInfo.getAtomName(), tableInfo);
                        }
                    }
                }
            }

            getTables(field, child, tableMap, atomTableMap);
        }
    }

    public static void getFieldInfos(FieldMemo fieldMemo, Map<String, FieldInfo> fields, Map<String, FieldInfo> output) {
        getFieldInfosInternal(fieldMemo, fields, false, output);
    }

    public static void getSelectFieldInfos(FieldMemo fieldMemo, Map<String, FieldInfo> fields, Map<String, FieldInfo> output) {
        getFieldInfosInternal(fieldMemo, fields, true, output);
    }

    static void getFieldInfosInternal(FieldMemo fieldMemo, Map<String, FieldInfo> fields, boolean onlySelectItem, Map<String, FieldInfo> output) {
        if (fieldMemo.children != null && fieldMemo.children.size() != 0) {
            Iterator i$ = fieldMemo.children.iterator();

            while(i$.hasNext()) {
                FieldMemo child = (FieldMemo)i$.next();
                if (onlySelectItem) {
                    if (fieldMemo.scope == child.scope) {
                        getFieldInfosInternal(child, fields, onlySelectItem, output);
                    } else if (child.isSelectItem) {
                        getFieldInfosInternal(child, fields, onlySelectItem, output);
                    }
                } else {
                    getFieldInfosInternal(child, fields, onlySelectItem, output);
                }
            }
        } else {
            String name = fieldMemo.getAtomName();
            if (fields.containsKey(name)) {
                FieldInfo fieldInfo = (FieldInfo)fields.get(name);
                fieldInfo.getMemos().add(fieldMemo);
                output.put(name, fieldInfo);
            }
        }

    }
}

