package util.sqlparse.visitor.db2;

import bean.Column;
import bean.Schema;
import bean.Table;
import bean.View;
import com.chenyang.druid.util.StringUtils;
import java.util.Map;
import util.getdata.DatabaseCache;
import util.sqlparse.visitor.common.names.NameWrapper;

public class DB2NameWrapper extends NameWrapper {
   public static final String PLACE_HOLDER = "\"";
   private String defschema;

   public String getDefschema() {
      return this.defschema;
   }

   public void setDefschema(String defschema) {
      this.defschema = defschema;
   }

   public DB2NameWrapper(DatabaseCache cache) {
      super(cache);
      String[] split = cache.getDataBase().getUrl().split("/");
      this.defschema = split[split.length - 1];
   }

   public String unwrapSchema(String schema) {
      if (schema != null && schema.length() != 0) {
         if (schema.startsWith("\"")) {
            return this.unwrapName(schema);
         } else {
            schema = schema.toUpperCase();
            Schema sch = this.getSchema(schema);
            return sch != null ? sch.getName() : this.unwrapName(schema);
         }
      } else {
         return schema;
      }
   }

   public String unwrapTable(String schema, String table) {
      if (schema != null && schema.length() != 0) {
         if (table != null && table.length() != 0) {
            if (table.startsWith("\"")) {
               return this.unwrapName(table);
            } else {
               Table tb = this.getTable(schema, table);
               return tb != null ? tb.getName() : this.unwrapName(table);
            }
         } else {
            return table;
         }
      } else {
         return this.unwrapName(table);
      }
   }

   public String unwrapFullColumn(Column c) {
      if (c == null) {
         return null;
      } else {
         String column = c.getColumnName();
         if (column != null && column.length() != 0) {
            ColInfo colInfo = this.getColumnInfo(c);
            if (colInfo.schema == null) {
               colInfo.schema = this.defschema;
            }

            this.unwrapColumn(colInfo);
            return colInfo.unwrap("\"");
         } else {
            return column;
         }
      }
   }

   private Schema getSchema(String schema) {
      if (schema != null && schema.length() != 0) {
         if (this.cache.getDataBase().isRedis()) {
            return this.getSchemaFromRedis(schema, schema.startsWith("\""));
         } else {
            Map<String, Schema> schemas = this.cache.getSchemas();
            if (schema.startsWith("\"")) {
               schema = this.unwrapName(schema);
               return (Schema)schemas.get(schema);
            } else {
               schema = schema.trim();
               Schema sch = (Schema)schemas.get(schema);
               if (sch != null) {
                  return sch;
               } else {
                  for(Map.Entry<String, Schema> pair : schemas.entrySet()) {
                     if (((String)pair.getKey()).equalsIgnoreCase(schema)) {
                        return (Schema)pair.getValue();
                     }
                  }

                  return null;
               }
            }
         }
      } else {
         return null;
      }
   }

   public Table getTable(String schema, String table) {
      Schema sch = this.getSchema(schema);
      return sch == null ? null : this.getTable(sch, table);
   }

   private Table getTable(Schema sch, String table) {
      if (sch == null) {
         return null;
      } else if (this.cache.getDataBase().isRedis()) {
         return this.getTableFromRedis(sch, table, table.startsWith("\""));
      } else {
         table = table.trim();
         Map<String, Table> tables = this.cache.getTables();
         if (table.startsWith("\"")) {
            table = this.unwrapName(table);
            String id = this.cache.getSchemaTableId(sch.getName(), table);
            return (Table)tables.get(id);
         } else {
            table = this.unwrapName(table);
            table = table.toUpperCase();
            String id = this.cache.getSchemaTableId(sch.getName(), table);
            Table tb = (Table)tables.get(id);
            if (tb != null) {
               return tb;
            } else {
               for(Map.Entry<String, Table> pair : tables.entrySet()) {
                  if (((String)pair.getKey()).equalsIgnoreCase(id)) {
                     return (Table)pair.getValue();
                  }
               }

               return null;
            }
         }
      }
   }

   public View getView(String schema, String viewName) {
      Schema sch = this.getSchema(schema);
      return sch == null ? null : this.getView(sch, viewName);
   }

   public View getView(Schema sch, String viewName) {
      if (sch == null) {
         return null;
      } else {
         return this.cache.getDataBase().isRedis() ? this.getViewFromRedis(sch, viewName, viewName.startsWith("\"")) : null;
      }
   }

   public void unwrapColumn(ColInfo colInfo) {
      String schema = colInfo.schema;
      String table = colInfo.table;
      String col = colInfo.column;
      if (colInfo.isValid()) {
         Schema sch = this.getSchema(schema);
         if (sch != null) {
            colInfo.schema = sch.getName();
         }

         Table tb = this.getTable(sch, table);
         if (tb != null) {
            colInfo.table = tb.getName();
         }

         if (tb != null && tb.getColumnList() != null && tb.getColumnList().size() > 0) {
            col = col.trim();
            boolean isCase = col.startsWith("\"");
            col = this.unwrapName(col);

            for(Column column : tb.getColumnList()) {
               if (isCase) {
                  if (column.getColumnName().equals(col)) {
                     colInfo.column = column.getColumnName();
                     break;
                  }
               } else if (column.getColumnName().equalsIgnoreCase(col)) {
                  colInfo.column = column.getColumnName();
                  break;
               }
            }
         }

      }
   }

   private String wrapName(String name) {
      return name != null && name.length() != 0 ? "\"" + name + "\"" : name;
   }

   protected String unwrapName(String name) {
      return name != null && name.length() != 0 ? name.replaceAll("\"", "") : name;
   }

   public String wrapTable(String schema, String table) {
      if (schema != null && schema.length() != 0) {
         if (table != null && table.length() != 0) {
            return this.isCaseSensitive && !table.startsWith("\"") ? this.wrapName(table) : table;
         } else {
            return table;
         }
      } else {
         return table;
      }
   }

   public String wrapColumn(String Column) {
      if (Column != null && Column.length() != 0) {
         return this.isCaseSensitive && !Column.startsWith("\"") ? this.wrapName(Column) : Column;
      } else {
         return Column;
      }
   }

   public static String normalize(String str) {
      if (StringUtils.isEmpty(str)) {
         return str;
      } else {
         return str.startsWith("\"") ? str.replaceAll("\"", "").trim() : str.toUpperCase().trim();
      }
   }
}
