package util.sqlparse.visitor.es.dense;

import bean.DataBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.sqlparse.visitor.es.memo.ApiResult;

public class ParamContext extends HashMap {
   public ParamContext(Map params) {
      if (params != null) {
         this.putAll(params);
      }

   }

   public String dbType() {
      return (String)this.get("dbType");
   }

   public String url() {
      return (String)this.get("url");
   }

   public String uri() {
      return (String)this.get("uri");
   }

   public String body() {
      return (String)this.get("sql");
   }

   public String method() {
      return (String)this.get("method");
   }

   public String ipPort() {
      return (String)this.get("ip_port");
   }

   public DataBase database() {
      return (DataBase)this.get("_es_database");
   }

   public ApiResult getApi() {
      return (ApiResult)this.get("apiResult");
   }

   public String response() {
      return (String)this.get("esResponseBytes");
   }

   public void setResponse(String data) {
      this.put("esResponseBytes", data);
   }

   public static class TableDenseContext extends ParamContext {
      public TableDenseContext(Map params) {
         super(params);
      }

      public String replaceNewTable() {
         return (String)this.get("replaceNewTable");
      }

      public String replaceTable() {
         return (String)this.get("replaceTable");
      }
   }

   public static class DenseAllContext extends ParamContext {
      public DenseAllContext(Map params) {
         super(params);
      }

      public String replaceSchema() {
         return (String)this.get("replaceSchema");
      }

      public String replaceTable() {
         return (String)this.get("replaceTable");
      }

      public String replaceColumn() {
         return (String)this.get("replaceColumn");
      }

      public String expression() {
         return (String)this.get("expression");
      }
   }

   public static class ColumnDenseContext extends ParamContext {
      public ColumnDenseContext(Map params) {
         super(params);
      }

      public String replaceSchema() {
         return (String)this.get("replaceSchema");
      }

      public String replaceTable() {
         return (String)this.get("replaceTable");
      }

      public String replaceColumn() {
         return (String)this.get("replaceColumn");
      }

      public String expression() {
         return (String)this.get("expression");
      }
   }

   public static class RowDenseContext extends ParamContext {
      public RowDenseContext(Map params) {
         super(params);
      }

      public Map<String, List<String>> modifyTable() {
         return (Map)this.get("modifyTable");
      }

      public Map<String, String> tableKeyWord() {
         return (Map)this.get("tableKeyWord");
      }

      public String operateType() {
         return (String)this.get("operateType");
      }

      public String limit() {
         return (String)this.get("limit");
      }
   }
}
