package util.sqlparse.visitor.es.dense.data.delete;

import com.chenyang.druid.sql.dialect.es.ast.EsParser;
import com.chenyang.druid.sql.dialect.es.ast.EsParserContextBase;
import java.util.List;
import util.sqlparse.visitor.es.dense.Denseable;
import util.sqlparse.visitor.es.dense.EsBuilder;
import util.sqlparse.visitor.es.dense.ParamContext;
import util.sqlparse.visitor.es.memo.ApiResult;
import util.sqlparse.visitor.es.memo.FlowType;
import util.sqlparse.visitor.es.memo.MappingMemo;

public class DeleteDataDense extends Denseable {
   @FlowType(FlowType.FlowTypeValue.up)
   public void denseTable(ParamContext.TableDenseContext params) {
      ApiResult api = params.getApi();
      EsParser.StatementContext statement = (EsParser.StatementContext)api.getStatement();
      EsParser.DeleteDataStatementContext delete = statement.deleteDataStatement();
      if (delete != null) {
         EsParser.DeleteDataByQueryStatementContext byQuery = delete.deleteDataByQueryStatement();
         if (byQuery != null) {
            super.denseTable(params);
         } else {
            EsParser.DeleteDataByIdStatementContext byId = delete.deleteDataByIdStatement();
            if (byId != null) {
               List<MappingMemo> tables = api.getTables();
               EsBuilder builder = EsBuilder.builder();
               EsParserContextBase uriMapping = this.buildEntityUri(builder, tables);
               builder.enter(byId).enter(byId.mappingName).replaceMe(uriMapping);
               super.denseTable(params);
            }

         }
      }
   }

   @FlowType(FlowType.FlowTypeValue.none)
   public void denseColumn(ParamContext.ColumnDenseContext params) {
   }

   @FlowType(FlowType.FlowTypeValue.none)
   public void denseData(ParamContext.DenseAllContext params) {
   }

   @FlowType(FlowType.FlowTypeValue.up)
   public void denseRow(ParamContext.RowDenseContext params) {
      ApiResult api = params.getApi();
      EsParser.StatementContext statement = (EsParser.StatementContext)api.getStatement();
      EsParser.DeleteDataStatementContext delete = statement.deleteDataStatement();
      if (delete != null) {
         EsParser.DeleteDataByQueryStatementContext byQuery = delete.deleteDataByQueryStatement();
         if (byQuery != null) {
            this.denseRowByQuery(params, byQuery);
         } else {
            EsParser.DeleteDataByIdStatementContext byId = delete.deleteDataByIdStatement();
            if (byId != null) {
               this.denseRowById(params, byId);
            }

         }
      }
   }

   private void denseRowByQuery(ParamContext.RowDenseContext params, EsParser.DeleteDataByQueryStatementContext byQuery) {
      EsParser.QueryBodyContext queryBody = byQuery.queryBody();
      EsBuilder builder = EsBuilder.builder();
      if (queryBody == null) {
         builder.enter(byQuery).rear().queryBody();
      }

      String operateType = params.operateType();
      if (operateType == "delete") {
         String painless = this.buildPainless(params);
         if (painless != null && painless.length() != 0) {
            builder.reset();
            this.maskQueryBody(painless, builder, queryBody);
         }
      }
   }

   private void denseRowById(ParamContext.RowDenseContext params, EsParser.DeleteDataByIdStatementContext byId) {
      if (byId != null) {
         ;
      }
   }
}
