package util.sqlparse.visitor.es.dense.data.query;

import com.chenyang.druid.sql.dialect.es.ast.EsParser;
import util.sqlparse.visitor.es.dense.Denseable;
import util.sqlparse.visitor.es.dense.EsBuilder;
import util.sqlparse.visitor.es.dense.ParamContext;
import util.sqlparse.visitor.es.memo.ApiResult;
import util.sqlparse.visitor.es.memo.FlowType;

public class QueryDataCountDense extends Denseable {
   @FlowType(FlowType.FlowTypeValue.up)
   public void denseTable(ParamContext.TableDenseContext params) {
      ApiResult api = params.getApi();
      EsParser.StatementContext statement = (EsParser.StatementContext)api.getStatement();
      EsParser.QueryDataStatementContext stmt = statement.queryDataStatement();
      if (stmt != null) {
         EsParser.QueryDataStatementCountContext count = stmt.queryDataStatementCount();
         if (count != null) {
            super.denseTable(params);
         }
      }
   }

   @FlowType(FlowType.FlowTypeValue.down)
   public void denseColumn(ParamContext.ColumnDenseContext params) {
   }

   @FlowType(FlowType.FlowTypeValue.down)
   public void denseData(ParamContext.DenseAllContext params) {
   }

   @FlowType(FlowType.FlowTypeValue.up)
   public void denseRow(ParamContext.RowDenseContext params) {
      ApiResult api = params.getApi();
      EsParser.StatementContext statement = (EsParser.StatementContext)api.getStatement();
      EsParser.QueryDataStatementContext stmt = statement.queryDataStatement();
      if (stmt != null) {
         EsParser.QueryDataStatementCountContext count = stmt.queryDataStatementCount();
         if (count != null) {
            EsBuilder builder = EsBuilder.builder();
            EsParser.QueryDataStatementCountBodyContext query = count.queryDataStatementCountBody();
            if (query == null) {
               query = (EsParser.QueryDataStatementCountBodyContext)builder.enter(count).queryDataStatementCountBody().current();
               builder.reset();
            }

            EsParser.QueryBodyContext body = query.queryBody();
            if (body == null) {
               body = (EsParser.QueryBodyContext)builder.enter(query).queryBody().current();
            }

            String painless = this.buildPainless(params);
            if (painless != null && painless.length() != 0) {
               builder.reset();
               this.maskQueryBody(painless, builder, body);
            }
         }
      }
   }
}
