package util.sqlparse.visitor.gauss.test;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.expr.SQLAllColumnExpr;
import com.chenyang.druid.sql.ast.expr.SQLExistsExpr;
import com.chenyang.druid.sql.ast.expr.SQLInListExpr;
import com.chenyang.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.chenyang.druid.sql.ast.expr.SQLVariantRefExpr;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLJoinTableSource;
import com.chenyang.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.chenyang.druid.sql.ast.statement.SQLSelectItem;
import com.chenyang.druid.sql.ast.statement.SQLSelectStatement;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUnionQuery;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.ast.statement.SQLValuesQuery;
import com.chenyang.druid.sql.dialect.mysql.ast.clause.MySqlSelectIntoStatement;
import com.chenyang.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.chenyang.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.chenyang.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.chenyang.druid.sql.dialect.mysql.visitor.DefaultMySqlASTVisitor;
import java.util.List;

public class TestVisitor extends DefaultMySqlASTVisitor {
   public void visit(String sql) {
      List<SQLStatement> statements = SQLUtils.parseStatements(sql, "mysql");
      ((SQLStatement)statements.get(0)).accept(new TestVisitor());
   }

   public boolean visit(SQLSelectItem x) {
      System.out.println("SQLSelectItem:" + x.toString());
      return true;
   }

   public boolean visit(SQLSubqueryTableSource x) {
      System.out.println("SQLSubqueryTableSource:" + x.getAlias());
      return true;
   }

   public boolean visit(SQLLateralViewTableSource x) {
      System.out.println("SQLLateralViewTableSource");
      return true;
   }

   public boolean visit(SQLExprTableSource x) {
      System.out.println("SQLExprTableSource:" + x.toString());
      return true;
   }

   public boolean visit(SQLSelectStatement x) {
      System.out.println("SQLSelectStatement");
      return true;
   }

   public boolean visit(MySqlSelectIntoStatement x) {
      System.out.println("MySqlSelectIntoStatement");
      return true;
   }

   public boolean visit(MySqlUpdateStatement x) {
      System.out.println("MySqlUpdateStatement");
      return true;
   }

   public boolean visit(MySqlDeleteStatement x) {
      System.out.println("MySqlDeleteStatement");
      return true;
   }

   public boolean visit(SQLDeleteStatement x) {
      System.out.println("SQLDeleteStatement");
      return true;
   }

   public boolean visit(SQLUpdateStatement x) {
      System.out.println("SQLUpdateStatement");
      return true;
   }

   public boolean visit(SQLUnionQuery x) {
      System.out.println("SQLUnionQuery");
      return true;
   }

   public boolean visit(SQLInListExpr x) {
      System.out.println("SQLInListExpr");
      return true;
   }

   public boolean visit(SQLInSubQueryExpr x) {
      System.out.println("SQLInSubQueryExpr");
      return true;
   }

   public boolean visit(SQLExistsExpr x) {
      System.out.println("SQLExistsExpr");
      return true;
   }

   public boolean visit(SQLAllColumnExpr x) {
      System.out.println("SQLAllColumnExpr:" + x);
      return true;
   }

   public boolean visit(SQLJoinTableSource x) {
      System.out.println("beginVisit SQLJoinTableSource:" + x.getAlias2());
      return true;
   }

   public void endVisit(SQLJoinTableSource x) {
      System.out.println("endVisit SQLJoinTableSource:" + x.getAlias2());
   }

   public boolean visit(SQLValuesQuery x) {
      System.out.println("SQLValuesQuery");
      return true;
   }

   public boolean visit(MySqlSelectQueryBlock x) {
      System.out.println("MySqlSelectQueryBlock");
      return true;
   }

   public boolean visit(SQLVariantRefExpr x) {
      System.out.println("SQLVariantRefExpr" + x.getName());
      return true;
   }

   public static void main(String[] args) {
      String sql1 = "create view vtest  as with a as (select * from sys_dept) select * from a\n";
      List<SQLStatement> sts = SQLUtils.parseStatements(sql1, "mysql");
      String sql = "update a set x=? where c=?";
      TestVisitor test = new TestVisitor();
      test.visit(sql);
   }
}
