package util.sqlparse.visitor.hivetdh;

import org.apache.commons.jexl2.introspection.JexlMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JexlMethodImpl implements JexlMethod {
   private final Method m;

   JexlMethodImpl(Method m) {
      this.m = m;
   }

   public Object invoke(Object obj, Object[] params) throws Exception {
      return this.m.invoke(obj, params);
   }

   public Object tryInvoke(String name, Object obj, Object[] params) {
      try {
         return this.m.invoke(obj, params);
      } catch (IllegalAccessException e) {
         e.printStackTrace();
         return null;
      } catch (InvocationTargetException e) {
         e.printStackTrace();
         return null;
      }
   }

   public boolean tryFailed(Object rval) {
      return false;
   }

   public boolean isCacheable() {
      return false;
   }

   public Class<?> getReturnType() {
      return this.m.getReturnType();
   }
}
