package util.sqlparse.visitor.kingbase.visitor;

import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLJoinTableSource;
import com.chenyang.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.chenyang.druid.sql.ast.statement.SQLSelectStatement;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUnionQuery;
import com.chenyang.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.chenyang.druid.sql.dialect.kingbase.ast.clause.KingbaseWithSubqueryEntry;
import com.chenyang.druid.sql.dialect.kingbase.ast.statement.KingbaseDeleteStatement;
import com.chenyang.druid.sql.dialect.kingbase.ast.statement.KingbaseInsertStatement;
import com.chenyang.druid.sql.dialect.kingbase.ast.statement.KingbaseSelectQueryBlock;
import com.chenyang.druid.sql.dialect.kingbase.ast.statement.KingbaseUpdateStatement;
import com.chenyang.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitorAdapter;
import java.util.List;
import util.sqlparse.visitor.common.scope.Scope;

public abstract class ParseVisitor extends KingbaseASTVisitorAdapter {
   private boolean debug = false;
   protected Scope scope;

   public ParseVisitor(Scope scope) {
      this.scope = scope;
   }

   public void perform(List<SQLStatement> statements) {
      if (statements != null && statements.size() != 0) {
         for(SQLStatement statement : statements) {
            statement.accept(this);
         }

         this.scope.reset();
      }
   }

   public boolean visit(SQLSelectStatement x) {
      if (this.debug) {
         System.out.println("enter SQLSelectStatement" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLSelectStatement x) {
      if (this.debug) {
         System.out.println("exit SQLSelectStatement" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLInsertStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLInsertStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(KingbaseInsertStatement x) {
      return this.visit((SQLInsertStatement)x);
   }

   public void endVisit(KingbaseInsertStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLUpdateStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLUpdateStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLDeleteStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLDeleteStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(KingbaseDeleteStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(KingbaseDeleteStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(KingbaseUpdateStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(KingbaseUpdateStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLWithSubqueryClause x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLWithSubqueryClause x) {
      if (this.debug) {
         System.out.println("exit SQLWithSubqueryClause" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLWithSubqueryClause.Entry x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause.Entry" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public boolean visit(KingbaseWithSubqueryEntry x) {
      this.visit((SQLWithSubqueryClause.Entry)x);
      return true;
   }

   public void endVisit(SQLWithSubqueryClause.Entry x) {
      if (this.debug) {
         System.out.println("exit SQLWithSubqueryClause.Entry" + x.toString());
      }

      this.scope.exitScope();
   }

   public void endVisit(KingbaseWithSubqueryEntry x) {
      this.endVisit((SQLWithSubqueryClause.Entry)x);
   }

   public boolean visit(KingbaseSelectQueryBlock x) {
      if (this.debug) {
         System.out.println("enter KingbaseSelectQueryBlock " + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(KingbaseSelectQueryBlock x) {
      if (this.debug) {
         System.out.println("exit KingbaseSelectQueryBlock " + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLUnionQuery x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLUnionQuery x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLLateralViewTableSource x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLLateralViewTableSource x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLSubqueryTableSource" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("exit SQLSubqueryTableSource" + x.toString());
      }

      for(Scope s : this.scope.getCurrent().getChildren()) {
         s.isolated = false;
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLJoinTableSource x) {
      return true;
   }

   public boolean visit(SQLUnionQueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLUnionQueryTableSource" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLUnionQueryTableSource x) {
      if (this.debug) {
         System.out.println("exit SQLUnionQueryTableSource" + x.toString());
      }

      for(Scope s1 : this.scope.getChildren()) {
         s1.isolated = false;
      }

      this.scope.exitScope();
   }

   public void endVisit(SQLJoinTableSource x) {
   }

   public boolean visit(SQLExprTableSource x) {
      return true;
   }

   public void endVisit(SQLExprTableSource x) {
   }

   protected void visitChild(SQLObject x) {
      if (x != null) {
         x.accept(this);
      }
   }

   protected void visitChild(List<? extends SQLObject> x) {
      if (x != null && x.size() != 0) {
         for(SQLObject sqlObject : x) {
            this.visitChild(sqlObject);
         }

      }
   }

   protected boolean isEqual(String name1, String name2) {
      return this.scope.dialector.isEqual(name1, name2);
   }
}
