package util.sqlparse.visitor.mongo;

import java.util.UUID;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDocument;

public class MongoTools {
   public static BsonDocument generateIdDoc() {
      UUID uuid4 = UUID.randomUUID();
      byte[] bytes2 = new byte[16];
      writeLongToArrayLittleEndian(bytes2, 0, uuid4.getMostSignificantBits());
      writeLongToArrayLittleEndian(bytes2, 8, uuid4.getLeastSignificantBits());
      BsonDocument id = new BsonDocument();
      id.append("id", new BsonBinary(BsonBinarySubType.UUID_STANDARD, bytes2));
      return id;
   }

   public static void writeLongToArrayLittleEndian(byte[] bytes, int offset, long x) {
      bytes[offset + 7] = (byte)((int)(255L & x));
      bytes[offset + 6] = (byte)((int)(255L & x >> 8));
      bytes[offset + 5] = (byte)((int)(255L & x >> 16));
      bytes[offset + 4] = (byte)((int)(255L & x >> 24));
      bytes[offset + 3] = (byte)((int)(255L & x >> 32));
      bytes[offset + 2] = (byte)((int)(255L & x >> 40));
      bytes[offset + 1] = (byte)((int)(255L & x >> 48));
      bytes[offset + 0] = (byte)((int)(255L & x >> 56));
   }
}
