package util.sqlparse.visitor.postgresql.visitor;

import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLPropertyExpr;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLJoinTableSource;
import com.chenyang.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.chenyang.druid.sql.ast.statement.SQLRevokeStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.chenyang.druid.sql.ast.statement.SQLSelectStatement;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUnionQuery;
import com.chenyang.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.chenyang.druid.sql.dialect.postgresql.ast.expr.tablesource.PGExprTableSource;
import com.chenyang.druid.sql.dialect.postgresql.ast.expr.tablesource.PGSubqueryTableSource;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGGrantStatement;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.chenyang.druid.sql.dialect.postgresql.visitor.DefaultPGASTVisitor;
import java.util.Iterator;
import java.util.List;
import util.sqlparse.visitor.common.scope.Scope;

public abstract class ParseVisitor extends DefaultPGASTVisitor {
   private boolean debug = false;
   protected Scope scope;

   public ParseVisitor(Scope scope) {
      this.scope = scope;
   }

   public void perform(List<SQLStatement> statements) {
      if (statements != null && statements.size() != 0) {
         Iterator i$ = statements.iterator();

         while(i$.hasNext()) {
            SQLStatement statement = (SQLStatement)i$.next();
            statement.accept(this);
         }

         this.scope.reset();
      }
   }

   public boolean visit(SQLSelectStatement x) {
      if (this.debug) {
         System.out.println("enter SQLSelectStatement" + x.toString());
      }

      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLSelectStatement x) {
      if (this.debug) {
         System.out.println("exit SQLSelectStatement" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLInsertStatement x) {
      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLInsertStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(PGInsertStatement x) {
      return this.visit((SQLInsertStatement)x);
   }

   public void endVisit(PGInsertStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLUpdateStatement x) {
      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLUpdateStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(PGUpdateStatement x) {
      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(PGUpdateStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLDeleteStatement x) {
      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLDeleteStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(PGDeleteStatement x) {
      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(PGDeleteStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(PGGrantStatement x) {
      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(PGGrantStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLRevokeStatement x) {
      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLRevokeStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLWithSubqueryClause x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause" + x.toString());
      }

      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLWithSubqueryClause x) {
      if (this.debug) {
         System.out.println("exit SQLWithSubqueryClause" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLWithSubqueryClause.Entry x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause.Entry" + x.toString());
      }

      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLWithSubqueryClause.Entry x) {
      if (this.debug) {
         System.out.println("exit SQLWithSubqueryClause.Entry" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(PGSelectQueryBlock x) {
      if (this.debug) {
         System.out.println("enter PGSelectQueryBlock " + x.toString());
      }

      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(PGSelectQueryBlock x) {
      if (this.debug) {
         System.out.println("exit PGSelectQueryBlock " + x.toString());
      }

      this.scope.exitScope();
   }

   public void endVisit(SQLSelectQueryBlock x) {
      if (this.debug) {
         System.out.println("exit SQLSelectQueryBlock " + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLUnionQuery x) {
      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLUnionQuery x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLLateralViewTableSource x) {
      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLLateralViewTableSource x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLSubqueryTableSource" + x.toString());
      }

      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("exit SQLSubqueryTableSource" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(PGSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("enter PGSubqueryTableSource" + x.toString());
      }

      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(PGSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("exit PGSubqueryTableSource" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLJoinTableSource x) {
      return true;
   }

   public boolean visit(SQLUnionQueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLUnionQueryTableSource" + x.toString());
      }

      this.scope.enterScope(x);
      return true;
   }

   public void endVisit(SQLUnionQueryTableSource x) {
      if (this.debug) {
         System.out.println("exit SQLUnionQueryTableSource" + x.toString());
      }

      this.scope.exitScope();
   }

   public void endVisit(SQLJoinTableSource x) {
   }

   public boolean visit(SQLExprTableSource x) {
      return true;
   }

   public void endVisit(SQLExprTableSource x) {
   }

   public boolean visit(PGExprTableSource x) {
      if (!(x.getExpr() instanceof SQLIdentifierExpr) && !(x.getExpr() instanceof SQLPropertyExpr)) {
         if (this.debug) {
            System.out.println("enter PGExprTableSource  " + x);
         }

         this.scope.enterScope(x);
      } else if (this.debug) {
         System.out.println("begin PGExprTableSource" + x.toString());
      }

      return true;
   }

   public void endVisit(PGExprTableSource x) {
      if (!(x.getExpr() instanceof SQLIdentifierExpr) && !(x.getExpr() instanceof SQLPropertyExpr)) {
         if (this.debug) {
            System.out.println("exit PGExprTableSource  " + x);
         }

         this.scope.exitScope();
      } else if (this.debug) {
         System.out.println("end PGExprTableSource" + x.toString());
      }

   }

   protected void acceptChild(List<? extends SQLObject> children) {
      if (children != null && children.size() != 0) {
         Iterator i$ = children.iterator();

         while(i$.hasNext()) {
            SQLObject child = (SQLObject)i$.next();
            child.accept(this);
         }

      }
   }

   protected void visitChild(SQLObject x) {
      if (x != null) {
         x.accept(this);
      }
   }

   protected void visitChild(List<? extends SQLObject> x) {
      if (x != null && x.size() != 0) {
         Iterator i$ = x.iterator();

         while(i$.hasNext()) {
            SQLObject sqlObject = (SQLObject)i$.next();
            this.visitChild(sqlObject);
         }

      }
   }

   protected boolean isEqual(String name1, String name2) {
      return this.scope.dialector.isEqual(name1, name2);
   }
}