package util.sqlparse.visitor.postgresql.visitor;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.chenyang.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.chenyang.druid.sql.dialect.postgresql.visitor.DefaultPGASTVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WhereVisitor extends DefaultPGASTVisitor {
   private boolean debug = false;
   private List<String> wheres = new ArrayList();

   public List<String> getWheres() {
      return this.wheres;
   }

   public WhereVisitor() {
   }

   public void perform(List<SQLStatement> statements) {
      if (statements != null && statements.size() != 0) {
         Iterator i$ = statements.iterator();

         while(i$.hasNext()) {
            SQLStatement statement = (SQLStatement)i$.next();
            statement.accept(this);
         }

      }
   }

   public boolean visit(SQLUpdateStatement x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      return true;
   }

   public boolean visit(PGUpdateStatement x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      return true;
   }

   public boolean visit(SQLDeleteStatement x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      return true;
   }

   public boolean visit(PGDeleteStatement x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      return true;
   }

   public boolean visit(PGSelectQueryBlock x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      SQLSelectGroupByClause groupBy = x.getGroupBy();
      if (groupBy != null && groupBy.getHaving() != null) {
         this.wheres.add(groupBy.getHaving().toString());
      }

      return true;
   }
}
