package util.sqlparse.visitor.sqlserver.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.JdbcUtil;
import util.SqlUtil;

public class DesensitizationTest {
   public static void main(String[] args) throws Exception {
      sqlserverParseTest("SELECT TOP (2) user_id FROM ry.dbo.sys_user WHERE sys_user.user_name <> '若依'");
   }

   static Map<String, Object> sqlserverParseTest(String sql) throws Exception {
      String content = "{\n      \"ip_port\": \"192.168.2.88:1433\",\n      \"url\": \"jdbc:sqlserver://192.168.2.88:1433;DatabaseName=ry\",\n      \"username\": \"sa\",\n      \"password\": \"123456\",\n      \"dbType\": \"sql server\",\n      \"isIgnorecase\": \"0\",\n      \"excludeSchema\": []\n    }";
      JdbcUtil.initData(content);

      try {
         Thread.sleep(2000L);
      } catch (InterruptedException e) {
         e.printStackTrace();
      }

      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "sql server");
      params.put("schema", "ry");
      params.put("url", "jdbc:sqlserver://192.168.2.88:1433;DatabaseName=ry");
      SqlUtil sqlUtil = new SqlUtil();
      Map<String, Object> stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
      return stringObjectMap;
   }

   static void sqlserverDesensitization() throws Exception {
      String sql = "";
      sql = "SELECT TOP (1000) [c1] ,[c2],[name] FROM [tb8]";
      Map<String, Object> stringObjectMap = sqlserverParseTest(sql);
      Map<String, Object> params = new HashMap();
      params.put("sql", (String)stringObjectMap.get("sql"));
      params.put("dbType", "sql server");
      params.put("url", "jdbc:sqlserver://192.168.2.118:1433;DatabaseName=test");
      params.put("replaceSchema", "dbO");
      params.put("replaceTable", "tB8");
      params.put("replaceColumn", ".*C1.*");
      params.put("expression", "concat(left(${value},1), '**') ");
      SqlUtil sqlUtil = new SqlUtil();
      String newsql = sqlUtil.desensitization(params);
      System.out.println(newsql);
   }

   static void sqlserverFieldReplace() throws Exception {
      String sql = "";
      sql = "SELECT TOP (1000) [c1] ,[c2],[name] FROM [test].[dbo].[tb8]";
      Map<String, Object> stringObjectMap = sqlserverParseTest(sql);
      Map<String, Object> params = new HashMap();
      params.put("sql", (String)stringObjectMap.get("sql"));
      params.put("dbType", "sql server");
      params.put("schema", "dbo");
      params.put("url", "jdbc:sqlserver://192.168.2.118:1433;DatabaseName=test");
      String filedfullname = "dBo.tB8.c1";
      String[] split = filedfullname.split("\\.");
      params.put("replaceSchema", split[0]);
      params.put("replaceTable", split[1]);
      params.put("replaceColumn", split[2]);
      params.put("expression", "concat(left(${value},1), '**') ");
      SqlUtil sqlUtil = new SqlUtil();
      String newsql = sqlUtil.column_desensitization(params);
      System.out.println(newsql);
   }

   static void sqlserverTableReplace() throws Exception {
      String sqls = "";
      sqls = "SELECT TOP (1000) [c1] ,[c2],[name] FROM [test].[dbo].[tb8]";
      Map<String, Object> stringObjectMap = sqlserverParseTest(sqls);
      String sql = (String)stringObjectMap.get("sql");
      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "sql server");
      params.put("schema", "Dbo");
      params.put("url", "jdbc:sqlserver://192.168.2.118:1433;DatabaseName=test");
      params.put("replaceNewTable", "[tb9]");
      params.put("replaceTable", "tb8");
      SqlUtil sqlUtil = new SqlUtil();
      String newSql = sqlUtil.table_desensitization(params);
      System.out.println(newSql);
      System.out.println("---------------------------");
   }

   static void sqlserverParseRowVisitTest8() throws Exception {
      String sqls = "";
      sqls = "SELECT  [login_name] ,[user_name],[phonenumber] FROM [ry].[dbo].[sys_user]";
      Map<String, Object> stringObjectMap = sqlserverParseTest(sqls);
      String tableName = "tB8";
      String columnName = "\"c1\"";
      String columnData = "若依1";
      Map<String, List<String>> modifyTable = new HashMap();
      List<String> valueList = new ArrayList();
      valueList.add(columnData);
      modifyTable.put(tableName, valueList);
      Map<String, String> tableKeyWord = new HashMap();
      tableKeyWord.put(tableName, columnName);
      String dbType = "sql server";
      String sql = (String)stringObjectMap.get("sql");
      String operateType = "select";
      Map<String, Object> param = new HashMap();
      param.put("sql", sql);
      param.put("url", "jdbc:sqlserver://192.168.2.118:1433;DatabaseName=test");
      param.put("schema", "dbo");
      param.put("limit", "2");
      param.put("modifyTable", modifyTable);
      param.put("tableKeyWord", tableKeyWord);
      param.put("operateType", operateType);
      param.put("dbType", dbType);
      SqlUtil util = new SqlUtil();
      String newSQL = util.rowVisitControl(param);
      System.out.println(newSQL);
      System.out.println("---------------------------");
   }
}
