package com.alibaba.druid.sql.ast;

import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLRecordDataType extends SQLDataTypeImpl implements SQLDataType {
   private final List<SQLColumnDefinition> columns = new ArrayList();

   public List<SQLColumnDefinition> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLColumnDefinition column) {
      column.setParent(this);
      this.columns.add(column);
   }

   public SQLRecordDataType clone() {
      SQLRecordDataType x = new SQLRecordDataType();
      this.cloneTo(x);

      for(SQLColumnDefinition c : this.columns) {
         SQLColumnDefinition c2 = c.clone();
         c2.setParent(x);
         x.columns.add(c2);
      }

      return x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
      }

      visitor.endVisit(this);
   }
}
