package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterOutlineStatement extends SQLStatementImpl implements SQLAlterStatement {
   private SQLExpr name;
   private boolean resync;
   private boolean disable;
   private boolean enable;

   public SQLAlterOutlineStatement() {
   }

   public SQLAlterOutlineStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      return children;
   }

   public boolean isResync() {
      return this.resync;
   }

   public void setResync(boolean resync) {
      this.resync = resync;
   }

   public boolean isDisable() {
      return this.disable;
   }

   public void setDisable(boolean disable) {
      this.disable = disable;
   }

   public boolean isEnable() {
      return this.enable;
   }

   public void setEnable(boolean enable) {
      this.enable = enable;
   }
}
