package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableDropColumnItem extends SQLObjectImpl implements SQLAlterTableItem {
   private List<SQLName> columns = new ArrayList();
   private boolean cascade = false;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
      }

      visitor.endVisit(this);
   }

   public List<SQLName> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLName column) {
      if (column != null) {
         column.setParent(this);
      }

      this.columns.add(column);
   }

   public boolean isCascade() {
      return this.cascade;
   }

   public void setCascade(boolean cascade) {
      this.cascade = cascade;
   }
}
