package com.alibaba.druid.sql.dialect.clickhouse.ast;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.dialect.clickhouse.visitor.ClickhouseVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class ClickhouseCreateTableStatement extends SQLCreateTableStatement {
   protected final List<SQLAssignItem> settings = new ArrayList();
   private SQLOrderBy orderBy;
   private SQLExpr partitionBy;
   private SQLExpr sampleBy;

   public ClickhouseCreateTableStatement() {
      super(DbType.clickhouse);
   }

   public SQLOrderBy getOrderBy() {
      return this.orderBy;
   }

   public void setOrderBy(SQLOrderBy x) {
      if (x != null) {
         x.setParent(this);
      }

      this.orderBy = x;
   }

   public SQLExpr getPartitionBy() {
      return this.partitionBy;
   }

   public void setPartitionBy(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.partitionBy = x;
   }

   public SQLExpr getSampleBy() {
      return this.sampleBy;
   }

   public void setSampleBy(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.sampleBy = x;
   }

   public List<SQLAssignItem> getSettings() {
      return this.settings;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof ClickhouseVisitor) {
         ClickhouseVisitor vv = (ClickhouseVisitor)v;
         if (vv.visit(this)) {
            this.acceptChild(vv);
         }

         vv.endVisit(this);
      } else {
         if (v.visit((SQLCreateTableStatement)this)) {
            this.acceptChild(v);
         }

         v.endVisit((SQLCreateTableStatement)this);
      }
   }
}
