package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;

public class MariadbShowOpenTablesStatement extends MariadbStatementImpl implements MariadbShowStatement {
   private SQLExpr database;
   private SQLExpr like;
   private SQLExpr where;
   private SQLIdentifierExpr fromOrInDatabase;

   public SQLExpr getLike() {
      return this.like;
   }

   public void setLike(SQLExpr like) {
      this.like = like;
   }

   public SQLExpr getWhere() {
      return this.where;
   }

   public void setWhere(SQLExpr where) {
      this.where = where;
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.database);
         this.acceptChild(visitor, this.like);
         this.acceptChild(visitor, this.where);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getDatabase() {
      return this.database;
   }

   public void setDatabase(SQLExpr database) {
      this.database = database;
   }

   public SQLIdentifierExpr getFromOrInDatabase() {
      return this.fromOrInDatabase;
   }

   public void setFromOrInDatabase(SQLIdentifierExpr fromOrInDatabase) {
      this.fromOrInDatabase = fromOrInDatabase;
   }
}
