package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleAlterTableModify extends OracleAlterTableItem {
   private List<SQLColumnDefinition> columns = new ArrayList();

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
      }

      visitor.endVisit(this);
   }

   public List<SQLColumnDefinition> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLColumnDefinition column) {
      if (column != null) {
         column.setParent(this);
      }

      this.columns.add(column);
   }
}
