package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleExitStatement extends OracleStatementImpl {
   private String label;
   private SQLExpr when;

   public SQLExpr getWhen() {
      return this.when;
   }

   public void setWhen(SQLExpr when) {
      if (when != null) {
         when.setParent(this);
      }

      this.when = when;
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.when);
      }

      visitor.endVisit(this);
   }

   public String getLabel() {
      return this.label;
   }

   public void setLabel(String label) {
      this.label = label;
   }

   public OracleExitStatement clone() {
      OracleExitStatement x = new OracleExitStatement();
      x.setLabel(this.label);
      x.setAfterSemi(this.afterSemi);
      x.setDbType(this.dbType);
      if (this.when != null) {
         x.setWhen(this.when.clone());
      }

      if (this.headHints != null) {
         List<SQLCommentHint> headHintsClone = new ArrayList(this.headHints.size());

         for(SQLCommentHint hint : this.headHints) {
            SQLCommentHint h2 = hint.clone();
            h2.setParent(x);
            headHintsClone.add(h2);
         }

         x.setHeadHints(headHintsClone);
      }

      return x;
   }
}
